/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.Map;

public interface ImageFilter {
    public static final ImageFilter BLACK_AND_WHITE = (img, settings) -> {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgb = img.getRGB(x, y);
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                int bri = (int)(r * g * b * 255.0f);
                rgb = 0xFF000000 | bri << 16 | bri << 8 | bri;
                img.setRGB(x, y, rgb);
            }
        }
        return img;
    };
    public static final ImageFilter BRIGHTEN = (img, settings) -> {
        RescaleOp rescaleOp = new RescaleOp(1.2f, settings.hasSetting("bright", EnumFilterSettingType.INT) ? (float)settings.getInt("bright") : 15.0f, null);
        rescaleOp.filter(img, img);
        return img;
    };

    default public BufferedImage applyToCopy(BufferedImage img, iFilterSettings settings) {
        BufferedImage i = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        i.createGraphics().drawImage((Image)img, 0, 0, null);
        return this.apply(i, settings);
    }

    public BufferedImage apply(BufferedImage var1, iFilterSettings var2);

    public static enum EnumFilterSettingType {
        INT,
        BOOL,
        FLOAT,
        ANY;

    }

    public static interface iFilterSettings {
        public static final iFilterSettings NONE = id -> null;

        public static iFilterSettings of(Map<String, Object> map) {
            return id -> map.get(id);
        }

        default public boolean hasSetting(String id) {
            return this.hasSetting(id, EnumFilterSettingType.ANY);
        }

        default public boolean hasSetting(String id, EnumFilterSettingType type) {
            if (this.get(id) == null) {
                return false;
            }
            if (type == EnumFilterSettingType.ANY) {
                return true;
            }
            if (type == EnumFilterSettingType.INT && this.get(id) instanceof Integer) {
                return true;
            }
            if (type == EnumFilterSettingType.BOOL && this.get(id) instanceof Boolean) {
                return true;
            }
            return type == EnumFilterSettingType.FLOAT && this.get(id) instanceof Float;
        }

        default public int getInt(String id) {
            Object o = this.get(id);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return 0;
        }

        default public boolean getBool(String id) {
            Object o = this.get(id);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }

        default public float getFloat(String id) {
            Object o = this.get(id);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            return 0.0f;
        }

        public Object get(String var1);
    }
}

