/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.command;

import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.structure.io.StructureElement;
import com.zeitheron.hammercore.utils.structure.io.StructureOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CommandExportStructure
extends CommandBase {
    public String func_71517_b() {
        return "hc_export";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/hc_export <x1> <y1> <z1> <x2> <y2> <z2> <name> [save air]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int x = CommandExportStructure.func_175755_a((String)args[0]);
        int y = CommandExportStructure.func_175755_a((String)args[1]);
        int z = CommandExportStructure.func_175755_a((String)args[2]);
        int x2 = CommandExportStructure.func_175755_a((String)args[3]);
        int y2 = CommandExportStructure.func_175755_a((String)args[4]);
        int z2 = CommandExportStructure.func_175755_a((String)args[5]);
        int mx = Math.min(x, x2);
        int my = Math.min(y, y2);
        int mz = Math.min(z, z2);
        int xx = Math.max(x, x2);
        int xy = Math.max(y, y2);
        int xz = Math.max(z, z2);
        String name = args[6];
        boolean bool = args.length == 8 ? CommandExportStructure.func_180527_d((String)args[7]) : false;
        World world = sender.func_130014_f_();
        sender.func_145747_a((ITextComponent)new TextComponentString("Saving tiles..."));
        new Thread(() -> {
            File f = new File("HammerCore", "structures");
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            File struct = IOUtils.pickFile(new File(f, name + ".hsf"));
            try (StructureOutputStream o = new StructureOutputStream(new FileOutputStream(struct));){
                WorldLocation center = new WorldLocation(world, new BlockPos(mx, my, mz));
                int sa = 0;
                int tot = 0;
                for (int ox = mx; ox <= xx; ++ox) {
                    for (int oy = my; oy <= xy; ++oy) {
                        for (int oz = mz; oz <= xz; ++oz) {
                            ++tot;
                            WorldLocation loc = new WorldLocation(world, new BlockPos(ox, oy, oz));
                            if (loc.isAir() && !bool) continue;
                            ++sa;
                            o.write(StructureElement.capture(loc, center));
                        }
                    }
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Saved " + sa + " tiles." + (sa != tot ? " (" + (tot - sa) + " air tiles skipped)" : "")));
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }).start();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (args.length < 4) {
            tabs.addAll(CommandExportStructure.func_175771_a((String[])args, (int)0, (BlockPos)targetPos));
        }
        if (args.length < 7) {
            tabs.addAll(CommandExportStructure.func_175771_a((String[])args, (int)3, (BlockPos)targetPos));
        }
        if (args.length == 7) {
            tabs.addAll(CommandExportStructure.func_71530_a((String[])args, (String[])new String[]{"NAME"}));
        }
        if (args.length == 8) {
            tabs.addAll(CommandExportStructure.func_71530_a((String[])args, (String[])new String[]{"true", "false"}));
        }
        return tabs;
    }
}

