/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.vertex;

import com.zeitheron.hammercore.client.render.vertex.SpriteTexture;
import com.zeitheron.hammercore.client.utils.GLRenderState;
import com.zeitheron.hammercore.client.utils.RenderBlocks;
import com.zeitheron.hammercore.client.utils.texture.TextureAtlasSpriteFull;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class SimpleBlockRendering {
    public final RenderBlocks rb;
    public SpriteTexture.BlockSpriteTexture[] textures = new SpriteTexture.BlockSpriteTexture[6];
    public double[] bounds = new double[6];
    public boolean[] faces = new boolean[6];
    public int[] rgb = new int[6];
    public int[] bright = new int[6];

    public SimpleBlockRendering(RenderBlocks rb) {
        this.rb = rb;
    }

    public void setColor(EnumFacing side, int rgb) {
        this.rgb[side.ordinal()] = rgb;
    }

    public void setBrightness(int bright) {
        Arrays.fill(this.bright, bright);
    }

    public void setBrightness(EnumFacing side, int bright) {
        this.bright[side.ordinal()] = bright;
    }

    public void disableFace(EnumFacing side) {
        this.faces[side.ordinal()] = false;
    }

    public void enableFace(EnumFacing side) {
        this.faces[side.ordinal()] = true;
    }

    public void enableFaces() {
        Arrays.fill(this.faces, true);
    }

    public void disableFaces() {
        Arrays.fill(this.faces, false);
    }

    public void setSidedSprites(TextureAtlasSprite bottom, TextureAtlasSprite top, TextureAtlasSprite side) {
        this.setSpriteForSide(EnumFacing.DOWN, bottom);
        this.setSpriteForSide(EnumFacing.UP, top);
        this.setSpriteForSide(EnumFacing.EAST, side);
        this.setSpriteForSide(EnumFacing.WEST, side);
        this.setSpriteForSide(EnumFacing.SOUTH, side);
        this.setSpriteForSide(EnumFacing.NORTH, side);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            this.setSpriteForSide(f, sprite);
        }
    }

    public void setSpriteForSide(EnumFacing side, TextureAtlasSprite sprite) {
        SpriteTexture.BlockSpriteTexture t = this.textures[side.ordinal()];
        if (t == null) {
            this.textures[side.ordinal()] = t = new SpriteTexture.BlockSpriteTexture();
        }
        t.setSprite(sprite);
    }

    private TextureAtlasSprite getSpriteForSide(EnumFacing side) {
        SpriteTexture.BlockSpriteTexture t = this.textures[side.ordinal()];
        if (t == null) {
            this.textures[side.ordinal()] = t = new SpriteTexture.BlockSpriteTexture();
        }
        return t.getSprite();
    }

    public void setRenderBounds(Cuboid6 cube) {
        this.setRenderBounds(cube.min, cube.max);
    }

    public void setRenderBounds(Vector3 min, Vector3 max) {
        this.setRenderBounds(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public void setRenderBounds(Vec3d min, Vec3d max) {
        this.setRenderBounds(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public void setRenderBounds(AxisAlignedBB aabb) {
        this.setRenderBounds(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public void setRenderBounds(IBlockState state, IBlockAccess world, BlockPos pos) {
        this.setRenderBounds(state.func_177230_c().func_185496_a(state, world, pos));
    }

    public void setRenderBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.bounds[0] = minX;
        this.bounds[1] = minY;
        this.bounds[2] = minZ;
        this.bounds[3] = maxX;
        this.bounds[4] = maxY;
        this.bounds[5] = maxZ;
    }

    public void begin() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GLRenderState blend = GLRenderState.BLEND;
        blend.captureState();
        blend.on();
        this.enableFaces();
        Arrays.fill(this.rgb, 0xFFFFFF);
        Arrays.fill(this.bright, 255);
        this.setSprite(TextureAtlasSpriteFull.sprite);
        this.setRenderBounds(Block.field_185505_j);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
        this.rb.renderFromInside = false;
    }

    public void drawBlock(double x, double y, double z) {
        this.rb.setRenderBounds(this.bounds[0], this.bounds[1], this.bounds[2], this.bounds[3], this.bounds[4], this.bounds[5]);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!this.faces[f.ordinal()]) continue;
            int rgb = this.rgb[f.ordinal()];
            int bright = this.bright[f.ordinal()];
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            this.rb.renderFace(f, x, y, z, this.getSpriteForSide(f), r, g, b, bright);
        }
        this.enableFaces();
    }

    public void end() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator.func_178181_a().func_78381_a();
        GLRenderState.BLEND.reset();
    }
}

