/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api;

import java.util.HashMap;
import java.util.Map;

public class EnergyUnit {
    public static final EnergyUnit RF = EnergyUnit.getUnit("rf", 1.0);
    public static final EnergyUnit FE = EnergyUnit.getUnit("fe", 1.0);
    public static final EnergyUnit TESLA = EnergyUnit.getUnit("tesla", 1.0);
    public static final EnergyUnit EU = EnergyUnit.getUnit("eu", 4.0);
    public static final EnergyUnit EMC = EnergyUnit.getUnit("emc", 125.0);
    private static final Map<String, EnergyUnit> UNITS = new HashMap<String, EnergyUnit>();
    public final double toRF;

    public static EnergyUnit getUnit(String id, double toRF) {
        if (UNITS.containsKey(id)) {
            return UNITS.get(id);
        }
        return new EnergyUnit(id, toRF);
    }

    public EnergyUnit(String id, double toRF) {
        UNITS.put(id, this);
        this.toRF = toRF;
    }

    public double getInRF(double x) {
        return x * this.toRF;
    }

    public double getFromRF(double rf) {
        return rf / this.toRF;
    }

    public double convertTo(double x, EnergyUnit targetUnit) {
        return targetUnit.getFromRF(this.getInRF(x));
    }

    public double convertFrom(double x, EnergyUnit sourceUnit) {
        return sourceUnit.convertTo(x, this);
    }
}

