/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore;

import com.zeitheron.hammercore.fluiddict.FluidDictionary;
import com.zeitheron.hammercore.lib.zlib.web.HttpRequest;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.oredict.OreDictionary;

class CrashUtil
implements ICrashCallable {
    CrashUtil() {
    }

    public String call() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("FluidDictionary Info: Registered " + FluidDictionary.getFluidNames().length + " fluids.\n");
        int items = 0;
        for (String name : OreDictionary.getOreNames()) {
            items += OreDictionary.getOres((String)name).size();
        }
        sb.append("OreDictionary Info: Registered " + OreDictionary.getOreNames().length + " names; " + items + " stacks.\n");
        sb.append("Pastebin Connection: ");
        try {
            String text = HttpRequest.get("https://pastebin.com/raw/ZQaapJ54").connectTimeout(500).body();
            if (!text.startsWith("[")) {
                sb.append("Failed!");
            }
            sb.append("Okay.\n");
        }
        catch (Throwable err) {
            sb.append("Failed!\n");
        }
        sb.append("Dependent Mods:");
        int f = 0;
        block3: for (ModContainer mc : Loader.instance().getActiveModList()) {
            for (ArtifactVersion av : mc.getRequirements()) {
                if (!av.getLabel().equals("hammercore")) continue;
                sb.append("\n    -" + mc.getName() + " (" + mc.getModId() + ") @" + mc.getVersion());
                ++f;
                continue block3;
            }
        }
        if (f == 0) {
            sb.append(" None.");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getLabel() {
        return "Hammer Core Information";
    }
}

