/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class BlockPosDim {
    BlockPos pos;
    int dimID;

    public BlockPosDim(BlockPos _pos, int _dimID) {
        this.pos = _pos;
        this.dimID = _dimID;
    }

    public BlockPosDim() {
        this.pos = new BlockPos(0, 0, 0);
        this.dimID = 0;
    }

    public BlockPosDim(int x, int y, int z, int d) {
        this.pos = new BlockPos(x, y, z);
        this.dimID = d;
    }

    public BlockPosDim(String seed) {
        this();
        String[] s;
        if (seed != null && seed.contains("-") && (s = seed.split("-")) != null && s.length == 4) {
            int x = 0;
            int y = 0;
            int z = 0;
            int d = 0;
            try {
                x = Integer.parseInt(s[0].substring(1));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            try {
                y = Integer.parseInt(s[1].substring(1));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            try {
                z = Integer.parseInt(s[2].substring(1));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            try {
                d = Integer.parseInt(s[3].substring(1));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            this.pos = new BlockPos(x, y, z);
            this.dimID = d;
        }
    }

    public BlockPosDim(NBTTagCompound nbt, String name) {
        if (nbt != null && name != null && nbt.func_74764_b(name)) {
            NBTTagCompound inbt = nbt.func_74775_l(name);
            this.dimID = inbt.func_74762_e("D");
            this.pos = new BlockPos(inbt.func_74762_e("X"), inbt.func_74762_e("Y"), inbt.func_74762_e("Z"));
        } else {
            this.pos = new BlockPos(0, 0, 0);
        }
    }

    public void WriteToNBT(NBTTagCompound nbt, String name) {
        if (nbt != null && name != null) {
            NBTTagCompound inbt = new NBTTagCompound();
            inbt.func_74768_a("D", this.dimID);
            if (this.pos != null) {
                inbt.func_74768_a("X", this.pos.func_177958_n());
                inbt.func_74768_a("Y", this.pos.func_177956_o());
                inbt.func_74768_a("Z", this.pos.func_177952_p());
            }
            nbt.func_74782_a(name, (NBTBase)inbt);
        }
    }

    public void ReadFromNBT(NBTTagCompound nbt, String name) {
        if (nbt != null && name != null && nbt.func_74764_b(name)) {
            NBTTagCompound inbt = nbt.func_74775_l(name);
            this.dimID = inbt.func_74762_e("D");
            this.pos = new BlockPos(inbt.func_74762_e("X"), inbt.func_74762_e("Y"), inbt.func_74762_e("Z"));
        }
    }

    public TileEntity GetTileEntity() {
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w == null) {
            return null;
        }
        return w.func_175625_s(this.pos);
    }

    public IBlockState GetBlockState() {
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w == null) {
            return null;
        }
        return w.func_180495_p(this.pos);
    }

    public WorldServer GetWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimID() {
        return this.dimID;
    }

    public void setDimID(int _dimID) {
        this.dimID = _dimID;
    }

    public void setPos(BlockPos _pos) {
        this.pos = _pos;
    }

    public void setPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public String toString() {
        return "x" + this.pos.func_177958_n() + "-y" + this.pos.func_177956_o() + "-z" + this.pos.func_177952_p() + "-d" + this.dimID;
    }

    public String toText() {
        return "x=" + this.pos.func_177958_n() + ",y=" + this.pos.func_177956_o() + ",z=" + this.pos.func_177952_p() + ",d=" + this.dimID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockPosDim) {
            return this.dimID == ((BlockPosDim)obj).dimID && ((BlockPosDim)obj).pos.func_177958_n() == this.pos.func_177958_n() && ((BlockPosDim)obj).pos.func_177956_o() == this.pos.func_177956_o() && ((BlockPosDim)obj).pos.func_177952_p() == this.pos.func_177952_p();
        }
        return false;
    }
}

