/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.adders;

import com.google.gson.JsonElement;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import leviathan143.loottweaker.common.lib.DataToJSONConverter;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.ZenLootFunctionWrapper;
import leviathan143.loottweaker.common.zenscript.ZenLootPoolWrapper;
import leviathan143.loottweaker.common.zenscript.adders.AbstractEntryAdder;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.functions.LootFunction;
import stanhebben.zenscript.annotations.ZenMethod;

public class ItemEntryAdder
extends AbstractEntryAdder<LootEntryItem> {
    private final IItemStack stack;
    private LootFunction[] functions = new LootFunction[0];

    public ItemEntryAdder(ZenLootPoolWrapper wrapper, IItemStack stack) {
        super(wrapper);
        this.stack = stack;
    }

    @ZenMethod
    public ItemEntryAdder weight(int weight) {
        return (ItemEntryAdder)super.weight(weight);
    }

    @ZenMethod
    public ItemEntryAdder quality(int quality) {
        return (ItemEntryAdder)super.quality(quality);
    }

    @ZenMethod
    public ItemEntryAdder conditionsJson(IData[] conditions) {
        return (ItemEntryAdder)super.conditionsJson(conditions);
    }

    @ZenMethod
    public ItemEntryAdder conditionsHelper(ZenLootConditionWrapper[] conditions) {
        return (ItemEntryAdder)super.conditionsHelper(conditions);
    }

    @ZenMethod
    public ItemEntryAdder name(String name) {
        return (ItemEntryAdder)super.name(name);
    }

    @ZenMethod
    public ItemEntryAdder functionsJson(IData[] functions) {
        Object[] json = (JsonElement[])Arrays.stream(functions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        this.functions = LootUtils.parseFunctions(json);
        LootUtils.addStackFunctions(this.stack, this.functions);
        return this;
    }

    @ZenMethod
    public ItemEntryAdder functionsHelper(ZenLootFunctionWrapper[] functions) {
        this.functions = LootUtils.parseFunctions(functions);
        LootUtils.addStackFunctions(this.stack, this.functions);
        return this;
    }

    @Override
    protected String getDefaultName() {
        return CraftTweakerMC.getItemStack((IItemStack)this.stack).func_77973_b().getRegistryName().toString();
    }

    @Override
    protected LootEntryItem createLootEntry() {
        Item item = CraftTweakerMC.getItemStack((IItemStack)this.stack).func_77973_b();
        return new LootEntryItem(item, this.weight, this.quality, this.functions, this.conditions.toArray(LootUtils.NO_CONDITIONS), this.name);
    }
}

