/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import leviathan143.loottweaker.common.darkmagic.CommonMethodHandles;
import leviathan143.loottweaker.common.lib.DataToJSONConverter;
import leviathan143.loottweaker.common.lib.IDelayedTweak;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.lib.ZenScriptUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.ZenLootFunctionWrapper;
import leviathan143.loottweaker.common.zenscript.actions.ActionEnqueueDelayedPoolTweak;
import leviathan143.loottweaker.common.zenscript.actions.AddLootEntry;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootPool")
public class ZenLootPoolWrapper {
    private static final Logger logger = LogManager.getLogger();
    private final LootPool backingPool;
    private final ResourceLocation parentTable;
    private final List<IDelayedTweak<LootPool, ZenLootPoolWrapper>> delayedTweaks = Lists.newArrayList();

    public ZenLootPoolWrapper(LootPool pool, ResourceLocation parentTable) {
        if (pool == null) {
            throw new IllegalArgumentException("Backing pool cannot be null!");
        }
        this.backingPool = pool;
        this.parentTable = parentTable;
    }

    @ZenMethod
    public void addConditionsHelper(ZenLootConditionWrapper[] conditions) {
        CraftTweakerAPI.apply((IAction)new AddConditions(this, LootUtils.parseConditions(conditions)));
    }

    @ZenMethod
    public void addConditionsJson(IData[] conditions) {
        if (!this.checkAllAreMaps(conditions)) {
            return;
        }
        Object[] conditionsJSON = (JsonElement[])Arrays.stream(conditions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        CraftTweakerAPI.apply((IAction)new AddConditions(this, LootUtils.parseConditions(conditionsJSON)));
    }

    @ZenMethod
    public void removeEntry(String entryName) {
        CraftTweakerAPI.apply((IAction)new RemoveLootEntry(this, entryName));
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weightIn, @Optional String name) {
        this.addItemEntry(stack, weightIn, 0, name);
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weightIn, int quality, @Optional String name) {
        this.addItemEntryHelper(stack, weightIn, quality, null, null, name);
    }

    @ZenMethod
    public void addItemEntryHelper(IItemStack iStack, int weight, int quality, ZenLootFunctionWrapper[] functions, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addItemEntryInternal(iStack, weight, quality, LootUtils.parseFunctions(functions), LootUtils.parseConditions(conditions), name);
    }

    @ZenMethod
    public void addItemEntryJson(IItemStack iStack, int weight, int quality, IData[] functions, IData[] conditions, @Optional String name) {
        if (!this.checkAllAreMaps(functions)) {
            return;
        }
        if (!this.checkAllAreMaps(conditions)) {
            return;
        }
        Object[] conditionsJSON = (JsonElement[])Arrays.stream(conditions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        Object[] functionsJSON = (JsonElement[])Arrays.stream(functions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        this.addItemEntryInternal(iStack, weight, quality, LootUtils.parseFunctions(functionsJSON), LootUtils.parseConditions(conditionsJSON), name);
    }

    private void addItemEntryInternal(IItemStack iStack, int weight, int quality, LootFunction[] functions, LootCondition[] conditions, String name) {
        Item item = CraftTweakerMC.getItemStack((IItemStack)iStack).func_77973_b();
        if (name == null) {
            name = item.getRegistryName().toString();
        }
        CraftTweakerAPI.apply((IAction)new AddLootEntry(this, (LootEntry)new LootEntryItem(item, weight, quality, LootUtils.addStackFunctions(iStack, functions), conditions, name)));
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weightIn, @Optional String name) {
        this.addLootTableEntry(tableName, weightIn, 0, name);
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weightIn, int qualityIn, @Optional String name) {
        this.addLootTableEntryHelper(tableName, weightIn, qualityIn, null, name);
    }

    @ZenMethod
    public void addLootTableEntryHelper(String tableName, int weightIn, int qualityIn, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addLootTableEntryInternal(tableName, weightIn, qualityIn, LootUtils.parseConditions(conditions), name);
    }

    @ZenMethod
    public void addLootTableEntryJson(String tableName, int weightIn, int qualityIn, IData[] conditions, @Optional String name) {
        if (!this.checkAllAreMaps(conditions)) {
            return;
        }
        Object[] json = (JsonElement[])Arrays.stream(conditions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        this.addLootTableEntryInternal(tableName, weightIn, qualityIn, LootUtils.parseConditions(json), name);
    }

    private void addLootTableEntryInternal(String tableName, int weightIn, int qualityIn, LootCondition[] conditions, String name) {
        if (name == null) {
            name = tableName;
        }
        CraftTweakerAPI.apply((IAction)new AddLootEntry(this, (LootEntry)new LootEntryTable(new ResourceLocation(tableName), weightIn, qualityIn, conditions, name)));
    }

    @ZenMethod
    public void addEmptyEntry(int weight, @Optional String name) {
        this.addEmptyEntryInternal(weight, 0, LootUtils.NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addEmptyEntry(int weight, int quality, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, LootUtils.NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addEmptyEntryHelper(int weight, int quality, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, LootUtils.parseConditions(conditions), name);
    }

    @ZenMethod
    public void addEmptyEntryJson(int weight, int quality, IData[] conditions, @Optional String name) {
        if (!this.checkAllAreMaps(conditions)) {
            return;
        }
        Object[] json = (JsonElement[])Arrays.stream(conditions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        this.addEmptyEntryInternal(weight, quality, LootUtils.parseConditions(json), name);
    }

    public void addEmptyEntryInternal(int weightIn, int qualityIn, LootCondition[] conditions, @Optional String name) {
        if (name == null) {
            name = "empty";
        }
        CraftTweakerAPI.apply((IAction)new AddLootEntry(this, (LootEntry)new LootEntryEmpty(weightIn, qualityIn, conditions, name)));
    }

    @ZenMethod
    public void setRolls(float minRolls, float maxRolls) {
        CraftTweakerAPI.apply((IAction)new SetRolls(this, new RandomValueRange(minRolls, maxRolls)));
    }

    @ZenMethod
    public void setBonusRolls(float minBonusRolls, float maxBonusRolls) {
        CraftTweakerAPI.apply((IAction)new SetBonusRolls(this, new RandomValueRange(minBonusRolls, maxBonusRolls)));
    }

    public void applyLootTweaks(LootPool pool) {
        if (pool.isFrozen()) {
            logger.debug("Skipped modifying pool {} because it is frozen");
            return;
        }
        for (IDelayedTweak<LootPool, ZenLootPoolWrapper> tweak : this.delayedTweaks) {
            tweak.applyTweak(pool, this);
        }
    }

    public LootPool getPool() {
        return this.backingPool;
    }

    public ResourceLocation getParentTable() {
        return this.parentTable;
    }

    public void addDelayedTweak(IDelayedTweak<LootPool, ZenLootPoolWrapper> tweak) {
        this.delayedTweaks.add(tweak);
    }

    private boolean checkAllAreMaps(IData[] data) {
        return Arrays.stream(data).allMatch(ZenScriptUtils::checkIsMap);
    }

    private static class SetBonusRolls
    extends ActionEnqueueDelayedPoolTweak {
        private RandomValueRange range;

        public SetBonusRolls(ZenLootPoolWrapper wrapper, RandomValueRange range) {
            super(wrapper);
            this.range = range;
        }

        @Override
        public void applyTweak(LootPool lootPool, ZenLootPoolWrapper zenWrapper) {
            lootPool.setBonusRolls(this.range);
        }

        public String describe() {
            return String.format("Queuing setting of bonus rolls of pool %s of table %s to (%f, %f)", this.wrapper.backingPool.getName(), this.wrapper.parentTable, Float.valueOf(this.range.func_186509_a()), Float.valueOf(this.range.func_186512_b()));
        }
    }

    private static class SetRolls
    extends ActionEnqueueDelayedPoolTweak {
        private RandomValueRange range;

        public SetRolls(ZenLootPoolWrapper wrapper, RandomValueRange range) {
            super(wrapper);
            this.range = range;
        }

        @Override
        public void applyTweak(LootPool lootPool, ZenLootPoolWrapper zenWrapper) {
            lootPool.setRolls(this.range);
        }

        public String describe() {
            return String.format("Queuing setting rolls of pool %s of table %s to (%f, %f)", this.wrapper.backingPool.getName(), this.wrapper.parentTable, Float.valueOf(this.range.func_186509_a()), Float.valueOf(this.range.func_186512_b()));
        }
    }

    private static class AddConditions
    extends ActionEnqueueDelayedPoolTweak {
        private LootCondition[] conditions;

        public AddConditions(ZenLootPoolWrapper wrapper, LootCondition[] conditions) {
            super(wrapper);
            this.conditions = conditions;
        }

        @Override
        public void applyTweak(LootPool pool, ZenLootPoolWrapper zenWrapper) {
            Collections.addAll(CommonMethodHandles.getConditionsFromPool(pool), this.conditions);
        }

        public String describe() {
            return String.format("Queuing conditions %s for addition to pool %s of table %s", ArrayUtils.toString((Object)this.conditions), this.wrapper.backingPool.getName(), this.wrapper.parentTable);
        }
    }

    private static class RemoveLootEntry
    extends ActionEnqueueDelayedPoolTweak {
        private String entryName;

        public RemoveLootEntry(ZenLootPoolWrapper wrapper, String entryName) {
            super(wrapper);
            this.entryName = entryName;
        }

        @Override
        public void applyTweak(LootPool pool, ZenLootPoolWrapper zenWrapper) {
            if (pool.removeEntry(this.entryName) == null) {
                CraftTweakerAPI.logError((String)String.format("No entry with name %s exists in pool %s", this.entryName, zenWrapper.backingPool.getName()));
                return;
            }
        }

        public String describe() {
            return String.format("Queuing entry %s for removal from pool %s of table", this.entryName, this.wrapper.backingPool.getName(), this.wrapper.getParentTable());
        }
    }
}

