/*
 * Decompiled with CFR 0.152.
 */
package furgl.autoPickup.common.command;

import furgl.autoPickup.common.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandBlacklist
extends CommandBase {
    private static final TextFormatting COLOR_NEUTRAL_DARK = TextFormatting.DARK_AQUA;
    private static final TextFormatting COLOR_NEUTRAL_LIGHT = TextFormatting.AQUA;
    private static final TextFormatting COLOR_SUCCESS = TextFormatting.DARK_GREEN;
    private static final TextFormatting COLOR_FAIL = TextFormatting.RED;
    private static List aliases;
    private static Collection displayNames;
    private static ArrayList<String> actions;
    private static ArrayList<String> presets;
    private static ArrayList<ArrayList<String>> presetItems;

    public CommandBlacklist() {
        actions = new ArrayList();
        actions.add("add");
        actions.add("remove");
        actions.add("clear");
        actions.add("autoAdd");
        actions.add("preset");
        presets = new ArrayList();
        presetItems = new ArrayList();
        presets.add("Mining");
        ArrayList<String> items = CommandBlacklist.getDisplayNames(new ArrayList<Material>(){
            {
                this.add(Material.field_151578_c);
                this.add(Material.field_151595_p);
            }
        });
        items.add(Item.func_150898_a((Block)Blocks.field_150347_e).func_77653_i(new ItemStack(Blocks.field_150347_e)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150348_b).func_77653_i(new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.STONE.func_176642_a())).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150348_b).func_77653_i(new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE.func_176642_a())).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150348_b).func_77653_i(new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE.func_176642_a())).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150348_b).func_77653_i(new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE.func_176642_a())).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150349_c).func_77653_i(new ItemStack((Block)Blocks.field_150349_c)).replace(" ", "_"));
        items.add(Items.field_151145_ak.func_77653_i(new ItemStack(Items.field_151145_ak)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150385_bj).func_77653_i(new ItemStack(Blocks.field_150385_bj)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150386_bk).func_77653_i(new ItemStack(Blocks.field_150386_bk)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150387_bl).func_77653_i(new ItemStack(Blocks.field_150387_bl)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150424_aL).func_77653_i(new ItemStack(Blocks.field_150424_aL)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150322_A).func_77653_i(new ItemStack(Blocks.field_150322_A)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_189877_df).func_77653_i(new ItemStack(Blocks.field_189877_df)).replace(" ", "_"));
        presetItems.add(items);
        presets.add("Monster_Drops");
        items = new ArrayList();
        items.add(Items.field_151078_bh.func_77653_i(new ItemStack(Items.field_151078_bh)).replace(" ", "_"));
        items.add(Items.field_151103_aS.func_77653_i(new ItemStack(Items.field_151103_aS)).replace(" ", "_"));
        items.add(Items.field_151032_g.func_77653_i(new ItemStack(Items.field_151032_g)).replace(" ", "_"));
        items.add(Items.field_151007_F.func_77653_i(new ItemStack(Items.field_151007_F)).replace(" ", "_"));
        items.add(Items.field_151070_bp.func_77653_i(new ItemStack(Items.field_151070_bp)).replace(" ", "_"));
        items.add(Items.field_151016_H.func_77653_i(new ItemStack(Items.field_151016_H)).replace(" ", "_"));
        items.add(Items.field_151123_aH.func_77653_i(new ItemStack(Items.field_151123_aH)).replace(" ", "_"));
        items.add(Items.field_151074_bl.func_77653_i(new ItemStack(Items.field_151074_bl)).replace(" ", "_"));
        items.add(Items.field_151064_bs.func_77653_i(new ItemStack(Items.field_151064_bs)).replace(" ", "_"));
        items.add(Items.field_151069_bo.func_77653_i(new ItemStack(Items.field_151069_bo)).replace(" ", "_"));
        items.add(Items.field_151055_y.func_77653_i(new ItemStack(Items.field_151055_y)).replace(" ", "_"));
        items.add(Items.field_151102_aT.func_77653_i(new ItemStack(Items.field_151102_aT)).replace(" ", "_"));
        items.add(Items.field_151172_bF.func_77653_i(new ItemStack(Items.field_151172_bF)).replace(" ", "_"));
        items.add(Items.field_151174_bG.func_77653_i(new ItemStack(Items.field_151174_bG)).replace(" ", "_"));
        items.add(Items.field_151031_f.func_77653_i(new ItemStack((Item)Items.field_151031_f)).replace(" ", "_"));
        items.add(Items.field_151010_B.func_77653_i(new ItemStack(Items.field_151010_B)).replace(" ", "_"));
        items.add(Items.field_151052_q.func_77653_i(new ItemStack(Items.field_151052_q)).replace(" ", "_"));
        presetItems.add(items);
        presets.add("Animal_Drops");
        items = new ArrayList();
        items.add(Items.field_151076_bf.func_77653_i(new ItemStack(Items.field_151076_bf)).replace(" ", "_"));
        items.add(Items.field_151110_aK.func_77653_i(new ItemStack(Items.field_151110_aK)).replace(" ", "_"));
        items.add(Items.field_151008_G.func_77653_i(new ItemStack(Items.field_151008_G)).replace(" ", "_"));
        items.add(Items.field_151082_bd.func_77653_i(new ItemStack(Items.field_151082_bd)).replace(" ", "_"));
        items.add(Items.field_151116_aA.func_77653_i(new ItemStack(Items.field_151116_aA)).replace(" ", "_"));
        items.add(Items.field_151147_al.func_77653_i(new ItemStack(Items.field_151147_al)).replace(" ", "_"));
        items.add(Items.field_179558_bo.func_77653_i(new ItemStack(Items.field_179558_bo)).replace(" ", "_"));
        items.add(Items.field_179556_br.func_77653_i(new ItemStack(Items.field_179556_br)).replace(" ", "_"));
        items.add(Items.field_179555_bs.func_77653_i(new ItemStack(Items.field_179555_bs)).replace(" ", "_"));
        items.add(Item.func_150898_a((Block)Blocks.field_150325_L).func_77653_i(new ItemStack(Blocks.field_150325_L)).replace(" ", "_"));
        items.add(Items.field_179561_bm.func_77653_i(new ItemStack(Items.field_179561_bm)).replace(" ", "_"));
        items.add(Items.field_151100_aR.func_77653_i(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b())).replace(" ", "_"));
        presetItems.add(items);
        presets.add("Vegetation");
        presetItems.add(CommandBlacklist.getDisplayNames(new ArrayList<Material>(){
            {
                this.add(Material.field_151570_A);
                this.add(Material.field_151572_C);
                this.add(Material.field_151584_j);
                this.add(Material.field_151585_k);
                this.add(Material.field_151582_l);
            }
        }));
    }

    private static ArrayList<String> getDisplayNames(ArrayList<Material> materials) {
        ArrayList<String> items = new ArrayList<String>();
        Iterator itr = Block.field_149771_c.func_148742_b().iterator();
        block2: while (itr.hasNext()) {
            try {
                Block block = CommandBlacklist.func_147180_g(null, (String)((ResourceLocation)itr.next()).toString());
                String prevName = "";
                for (int i = 0; i < 99; ++i) {
                    String newName = block.func_185473_a(null, new BlockPos(0, 0, 0), block.func_176203_a(i)).func_77973_b().func_77653_i(block.func_185473_a(null, new BlockPos(0, 0, 0), block.func_176203_a(i)));
                    Material material = block.func_149688_o(block.func_176203_a(i));
                    if (prevName.equalsIgnoreCase(newName) || items.contains(newName.replace(" ", "_")) || !materials.contains(material)) continue block2;
                    items.add(newName.replace(" ", "_"));
                    prevName = newName;
                }
            }
            catch (Exception exception) {
            }
        }
        return items;
    }

    private static Collection getDisplayNames() {
        if (displayNames == null) {
            displayNames = CommandBlacklist.convertToDisplayNames(Item.field_150901_e.func_148742_b());
        }
        return displayNames;
    }

    public int func_82362_a() {
        return 0;
    }

    private static Collection convertToDisplayNames(Set set) {
        displayNames = new ArrayList();
        Iterator iterator = Item.field_150901_e.func_148742_b().iterator();
        while (iterator.hasNext()) {
            try {
                Item item = CommandBlacklist.func_147179_f(null, (String)iterator.next().toString());
                String prevName = "";
                for (int i = 0; i < 99; ++i) {
                    String newName = item.func_77653_i(new ItemStack(item, 1, i));
                    if (prevName.equalsIgnoreCase(newName) || displayNames.contains(newName.replace(" ", "_"))) continue;
                    displayNames.add(newName.replace(" ", "_"));
                    prevName = newName;
                }
            }
            catch (Exception exception) {
            }
        }
        return displayNames;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        Config.syncFromConfig(sender.func_70005_c_());
        if (args.length == 1) {
            return CommandBlacklist.func_175762_a((String[])args, actions);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add")) {
                return CommandBlacklist.func_175762_a((String[])args, (Collection)CommandBlacklist.getDisplayNames());
            }
            if (args[0].equalsIgnoreCase("remove")) {
                return CommandBlacklist.func_175762_a((String[])args, Config.blacklistNames);
            }
            if (args[0].equalsIgnoreCase("autoAdd")) {
                return CommandBlacklist.func_175762_a((String[])args, (Collection)new ArrayList<String>(){
                    {
                        this.add("enable");
                        this.add("disable");
                    }
                });
            }
            if (args[0].equalsIgnoreCase("preset")) {
                return CommandBlacklist.func_175762_a((String[])args, presets);
            }
            return new ArrayList<String>();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("preset")) {
            return CommandBlacklist.func_175762_a((String[])args, (Collection)new ArrayList<String>(){
                {
                    this.add("enable");
                    this.add("disable");
                }
            });
        }
        return new ArrayList<String>();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2) {
            args[1] = this.addCaps(args[1]);
        }
        Config.syncFromConfig(sender.func_70005_c_());
        if (args.length == 0) {
            sender.func_145747_a(new TextComponentString("[AutoPickup] Blacklist Contains:").func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_DARK)));
            for (int i = 0; i < Config.blacklistNames.size(); ++i) {
                sender.func_145747_a(new TextComponentString("- " + Config.blacklistNames.get(i)).func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_LIGHT)));
            }
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
            Config.blacklistNames.clear();
            Config.syncToConfig(sender.func_70005_c_());
            sender.func_145747_a(new TextComponentString("[AutoPickup] Blacklist cleared.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("autoAdd")) {
            sender.func_145747_a(new TextComponentString("[AutoPickup] AutoAdd is currently " + (Config.autoAdd ? "enabled." : "disabled.")).func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_LIGHT)));
            return;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("autoAdd")) {
            if (args[1].equalsIgnoreCase("enable")) {
                Config.autoAdd = true;
                Config.syncToConfig(sender.func_70005_c_());
                sender.func_145747_a(new TextComponentString("[AutoPickup] AutoAdd enabled.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                return;
            }
            if (args[1].equalsIgnoreCase("disable")) {
                Config.autoAdd = false;
                Config.syncToConfig(sender.func_70005_c_());
                sender.func_145747_a(new TextComponentString("[AutoPickup] AutoAdd disabled.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                return;
            }
            sender.func_145747_a(new TextComponentString("Usage: /b autoAdd [enable/disable]").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("preset")) {
            sender.func_145747_a(new TextComponentString("[AutoPickup] A preset is a collection of items that can be added to or removed from the blacklist easily.").func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_LIGHT)));
            return;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("preset")) {
            for (int i = 0; i < presets.size(); ++i) {
                if (!args[1].equalsIgnoreCase(presets.get(i))) continue;
                sender.func_145747_a(new TextComponentString("[AutoPickup] The " + presets.get(i) + " preset contains these items:").func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_DARK)));
                for (String item : presetItems.get(i)) {
                    sender.func_145747_a(new TextComponentString("- " + item).func_150255_a(new Style().func_150238_a(COLOR_NEUTRAL_LIGHT)));
                }
                return;
            }
            sender.func_145747_a(new TextComponentString("Usage: /b preset [preset] [enable/disable]").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
            return;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("preset")) {
            for (int i = 0; i < presets.size(); ++i) {
                if (!args[1].equalsIgnoreCase(presets.get(i))) continue;
                int changedItems = 0;
                if (args[2].equalsIgnoreCase("enable")) {
                    for (String item : presetItems.get(i)) {
                        if (Config.blacklistNames.contains(item)) continue;
                        Config.blacklistNames.add(item);
                        ++changedItems;
                    }
                    Config.syncToConfig(sender.func_70005_c_());
                    sender.func_145747_a(new TextComponentString("[AutoPickup] Added " + changedItems + " items to blacklist.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                    return;
                }
                if (!args[2].equalsIgnoreCase("disable")) continue;
                for (String item : presetItems.get(i)) {
                    if (!Config.blacklistNames.contains(item)) continue;
                    Config.blacklistNames.remove(item);
                    ++changedItems;
                }
                Config.syncToConfig(sender.func_70005_c_());
                sender.func_145747_a(new TextComponentString("[AutoPickup] Removed " + changedItems + " items from blacklist.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                return;
            }
            sender.func_145747_a(new TextComponentString("Usage: /b preset [preset] [enable/disable]").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
            return;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add")) {
                if (Config.blacklistNames.contains(args[1])) {
                    sender.func_145747_a(new TextComponentString("[AutoPickup] Blacklist already contains " + args[1] + ".").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
                    return;
                }
                if (CommandBlacklist.getDisplayNames().contains(args[1])) {
                    Config.blacklistNames.add(args[1]);
                    Config.syncToConfig(sender.func_70005_c_());
                    sender.func_145747_a(new TextComponentString("[AutoPickup] Added " + args[1] + " to blacklist.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                    return;
                }
            } else {
                if (args[0].equalsIgnoreCase("remove")) {
                    if (Config.blacklistNames.contains(args[1])) {
                        Config.blacklistNames.remove(args[1]);
                        Config.syncToConfig(sender.func_70005_c_());
                        sender.func_145747_a(new TextComponentString("[AutoPickup] Removed " + args[1] + " from blacklist.").func_150255_a(new Style().func_150238_a(COLOR_SUCCESS)));
                        return;
                    }
                    sender.func_145747_a(new TextComponentString("[AutoPickup] Blacklist does not contain " + args[1] + ".").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
                    return;
                }
                sender.func_145747_a(new TextComponentString("Usage: /b <action> [<item>]").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
                return;
            }
        }
        sender.func_145747_a(new TextComponentString("Usage: /b <action> [<item/true/false>]").func_150255_a(new Style().func_150238_a(COLOR_FAIL)));
    }

    private String addCaps(String string) {
        if ((string = string.substring(0, 1).toUpperCase() + string.substring(1)).length() >= string.indexOf("_") + 2) {
            string = string.substring(0, string.indexOf("_") + 1) + string.substring(string.indexOf("_") + 1, string.indexOf("_") + 2).toUpperCase() + string.substring(string.indexOf("_") + 2);
        }
        if (string.length() >= string.lastIndexOf("_") + 2) {
            string = string.substring(0, string.lastIndexOf("_") + 1) + string.substring(string.lastIndexOf("_") + 1, string.lastIndexOf("_") + 2).toUpperCase() + string.substring(string.lastIndexOf("_") + 2);
        }
        return string;
    }

    public List<String> func_71514_a() {
        aliases = new ArrayList();
        aliases.add("blacklist");
        aliases.add("b");
        return aliases;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/b <action> [<item>]";
    }

    public String func_71517_b() {
        return "blacklist";
    }
}

