/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.lib.Logger;
import java.io.File;

public class RangeMinMax
implements IJsonObject {
    private Float min;
    private Float max;

    public float GetMin() {
        return this.min.floatValue();
    }

    public float GetMax() {
        return this.max.floatValue();
    }

    public RangeMinMax(int min, int max) {
        this((float)min, (float)max);
    }

    public RangeMinMax(float min, float max) {
        this.min = Float.valueOf(min);
        this.max = Float.valueOf(max);
        if (max < min) {
            max = min;
        }
    }

    public String toString() {
        return String.format("RangeMinMax{min: %f, max: %f}", this.min, this.max);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.min == null) {
            throw new InvalidJsonException("Missing min for " + this.toString(), file);
        }
        if (this.max == null) {
            Logger.Debug("Missing max for " + this.toString() + ". Max will now be equal to min");
            this.max = this.min;
        }
        if (this.max.floatValue() < this.min.floatValue()) {
            Logger.Debug("Min is greater than max " + this.toString() + ". Max will now be equal to min");
            this.max = this.min;
        }
    }
}

