/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.mobs;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.Mob;
import insane96mcp.mpr.json.utils.RangeMinMax;
import java.io.File;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Ghast
implements IJsonObject {
    @SerializedName(value="explosion_power")
    public RangeMinMax explosionPower;

    public String toString() {
        return String.format("Ghast{explosionPower: %s}", this.explosionPower);
    }

    public static void Apply(Entity entity, World world, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityGhast)) {
            return;
        }
        EntityGhast entityGhast = (EntityGhast)entity;
        NBTTagCompound compound = new NBTTagCompound();
        entityGhast.func_70014_b(compound);
        for (Mob mob : Mob.mobs) {
            if (mob.ghast == null || !EntityList.func_180123_a((Entity)entityGhast, (ResourceLocation)new ResourceLocation(mob.mobId))) continue;
            if (compound.func_74762_e("ExplosionPower") == 1) {
                int minExplosionPower = (int)mob.ghast.explosionPower.GetMin();
                int maxExplosionPower = (int)mob.ghast.explosionPower.GetMax();
                int explosionPower = MathHelper.func_76136_a((Random)random, (int)minExplosionPower, (int)maxExplosionPower);
                compound.func_74768_a("ExplosionPower", explosionPower);
            }
            entityGhast.func_70037_a(compound);
        }
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.explosionPower == null) {
            throw new InvalidJsonException("Missing explosion_power for " + this, file);
        }
        this.explosionPower.Validate(file);
    }
}

