/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.mobs;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.MobsPropertiesRandomness;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.Mob;
import insane96mcp.mpr.json.utils.Chance;
import insane96mcp.mpr.json.utils.RangeMinMax;
import insane96mcp.mpr.lib.Reflection;
import insane96mcp.mpr.network.CreeperFuse;
import insane96mcp.mpr.network.PacketHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Creeper
implements IJsonObject {
    public RangeMinMax fuse;
    @SerializedName(value="explosion_radius")
    public RangeMinMax explosionRadius;
    @SerializedName(value="powered_chance")
    public Chance poweredChance;

    public String toString() {
        return String.format("Creeper{fuse: %s, explosionRadius: %s, poweredChance: %s}", this.fuse, this.explosionRadius, this.poweredChance);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.poweredChance != null) {
            this.poweredChance.Validate(file);
        }
    }

    public static void Apply(EntityLiving entity, World world, Random random) {
        if (!(entity instanceof EntityCreeper)) {
            return;
        }
        EntityCreeper entityCreeper = (EntityCreeper)entity;
        if (world.field_72995_K) {
            PacketHandler.SendToServer(new CreeperFuse(entityCreeper.func_145782_y()));
            return;
        }
        for (Mob mob : Mob.mobs) {
            if (mob.creeper == null || !EntityList.func_180123_a((Entity)entityCreeper, (ResourceLocation)new ResourceLocation(mob.mobId))) continue;
            Creeper creeper = mob.creeper;
            NBTTagCompound compound = new NBTTagCompound();
            entityCreeper.func_70014_b(compound);
            if (mob.creeper.fuse != null && compound.func_74765_d("Fuse") == 30) {
                int minFuse = (int)mob.creeper.fuse.GetMin();
                int maxFuse = (int)mob.creeper.fuse.GetMax();
                int fuse = MathHelper.func_76136_a((Random)random, (int)minFuse, (int)maxFuse);
                compound.func_74777_a("Fuse", (short)fuse);
            }
            if (mob.creeper.explosionRadius != null && compound.func_74771_c("ExplosionRadius") == 30) {
                int minExplosionRadius = (int)mob.creeper.explosionRadius.GetMin();
                int maxExplosionRadius = (int)mob.creeper.explosionRadius.GetMax();
                int explosionRadius = MathHelper.func_76136_a((Random)random, (int)minExplosionRadius, (int)maxExplosionRadius);
                compound.func_74774_a("ExplosionRadius", (byte)explosionRadius);
            }
            if (creeper.poweredChance.ChanceMatches(entity, world, random)) {
                compound.func_74757_a("powered", true);
            }
            entityCreeper.func_70037_a(compound);
        }
    }

    public static void FixAreaEffectClouds(Entity entity) {
        if (!(entity instanceof EntityAreaEffectCloud)) {
            return;
        }
        NBTTagCompound tags = entity.getEntityData();
        boolean isAlreadyChecked = tags.func_74767_n(MobsPropertiesRandomness.RESOURCE_PREFIX + "checked");
        if (isAlreadyChecked) {
            return;
        }
        EntityAreaEffectCloud areaEffectCloud = (EntityAreaEffectCloud)entity;
        if (areaEffectCloud.func_184494_w() instanceof EntityPlayer) {
            tags.func_74757_a(MobsPropertiesRandomness.RESOURCE_PREFIX + "checked", true);
            return;
        }
        ArrayList effects = new ArrayList();
        effects = (ArrayList)Reflection.Get(Reflection.EntityAreaEffectCloud_effects, areaEffectCloud);
        ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
        for (PotionEffect potionEffect : effects) {
            if (potionEffect.func_76459_b() > 9600) {
                PotionEffect newPotionEffect = new PotionEffect(potionEffect.func_188419_a(), 600, potionEffect.func_76458_c());
                newEffects.add(newPotionEffect);
                continue;
            }
            newEffects.add(potionEffect);
        }
        Reflection.Set(Reflection.EntityAreaEffectCloud_effects, areaEffectCloud, newEffects);
        tags.func_74757_a(MobsPropertiesRandomness.RESOURCE_PREFIX + "checked", true);
    }
}

