/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.util;

import com.google.common.base.Strings;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.capability.IVSBPlayer;
import v0id.api.vsb.item.EnumBackpackType;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.upgrade.UpgradeHotbarSwapper;
import v0id.vsb.item.upgrade.UpgradeNesting;

public class VSBUtils {
    public static Object invokeMethod(Method method, Object instance, Object ... params) {
        try {
            return method.invoke(instance, params);
        }
        catch (IllegalAccessException ex) {
            try {
                method.setAccessible(true);
                return method.invoke(instance, params);
            }
            catch (IllegalAccessException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Impossible reflection exception thrown", true);
            }
            catch (InvocationTargetException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Invalid parameters passed to method!", true);
            }
        }
        catch (InvocationTargetException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Invalid parameters passed to method!", true);
        }
        return null;
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException ex) {
            try {
                field.setAccessible(true);
                return field.get(instance);
            }
            catch (IllegalAccessException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Impossible reflection exception thrown", true);
                return null;
            }
        }
    }

    public static boolean areStringsEqual(String s1, String s2) {
        if (Strings.isNullOrEmpty((String)s1)) {
            return Strings.isNullOrEmpty((String)s2);
        }
        return s1.equals(s2);
    }

    public static <T> boolean anyMatch(T[] array, Predicate<T> matcher) {
        Objects.requireNonNull(array);
        Objects.requireNonNull(matcher);
        for (T t : array) {
            if (!matcher.test(t)) continue;
            return true;
        }
        return false;
    }

    public static int[] createDefaultArray(int size, int defaultElement) {
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = defaultElement;
        }
        return ret;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)VSBUtils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addXP(EntityPlayer player, int amt) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, VSBUtils.getPlayerXP(player) + amt);
        player.field_71068_ca = VSBUtils.getLevelForExperience(experience);
        int expForLevel = VSBUtils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (VSBUtils.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 15 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    public static void registerOreSafe(String ore, ItemStack item) {
        NonNullList itemsList = OreDictionary.getOres((String)ore, (boolean)false);
        if (itemsList.isEmpty() || itemsList.stream().noneMatch(s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)item))) {
            OreDictionary.registerOre((String)ore, (ItemStack)item);
        }
    }

    public static Method getMethodSafe(Class<?> clazz, Class[] params, String ... names) {
        try {
            return ReflectionHelper.findMethod(clazz, (String)names[0], (String)(names.length == 1 ? names[0] : names[1]), (Class[])params);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "VSB was unable to reflect a constructor!", true);
            return null;
        }
    }

    public static Constructor<?> getConstructorSafe(Class<?> clazz, Class ... params) {
        try {
            Constructor<?> c = clazz.getConstructor(params);
            c.setAccessible(true);
            return c;
        }
        catch (NoSuchMethodException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "VSB was unable to reflect a constructor!", true);
            return null;
        }
    }

    public static Class<?> getOptionalClass(String clazzName, BooleanSupplier optionalTester) {
        if (optionalTester == null || optionalTester.getAsBoolean()) {
            try {
                return Class.forName(clazzName);
            }
            catch (ClassNotFoundException ex) {
                FMLCommonHandler.instance().raiseException((Throwable)ex, "VSB couldn't reflect a class. This is probably due to compatibility patches not finding the mod required", false);
                return null;
            }
        }
        return null;
    }

    public static Field getFieldSafe(Class<?> clazz, String ... fieldNames) {
        try {
            return ReflectionHelper.findField(clazz, (String[])fieldNames);
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "VSB was unable to reflect field!", true);
            return null;
        }
    }

    public static Iterable<ItemStack> getPlayerInventory(EntityPlayer player) {
        return () -> Stream.concat(player.field_71071_by.field_70462_a.stream(), player.field_71071_by.field_184439_c.stream()).iterator();
    }

    public static boolean isOreDictionaryMatch(ItemStack test, ItemStack matchTo) {
        if (!matchTo.func_190926_b() && !test.func_190926_b()) {
            int[] ids_to = OreDictionary.getOreIDs((ItemStack)matchTo);
            int[] ids_test = OreDictionary.getOreIDs((ItemStack)test);
            for (int i : ids_to) {
                for (int j : ids_test) {
                    if (i != j) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String[] getOreNames(ItemStack is) {
        return (String[])Arrays.stream(OreDictionary.getOreIDs((ItemStack)is)).mapToObj(OreDictionary::getOreName).toArray(String[]::new);
    }

    public static <T> T firstMatch(Predicate<T> matcher, T ... things) {
        for (T t : things) {
            if (!matcher.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T firstMatch(Predicate<T> matcher, Iterable<T> things) {
        for (T t : things) {
            if (!matcher.test(t)) continue;
            return t;
        }
        return null;
    }

    public static void openContainer(EntityPlayerMP playerMP, Container container) {
        playerMP.func_71117_bO();
        playerMP.func_71128_l();
        playerMP.field_71070_bA = container;
        container.field_75152_c = playerMP.field_71139_cq;
        playerMP.field_71070_bA.func_75132_a((IContainerListener)playerMP);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)playerMP, container));
    }

    public static <T> T[] capabilityToArray(IItemHandler cap, Class<T> clazz, Function<ItemStack, T> mapper) {
        Objects.requireNonNull(mapper);
        Object[] array = (Object[])Array.newInstance(clazz, cap.getSlots());
        for (int i = 0; i < array.length; ++i) {
            array[i] = mapper.apply(cap.getStackInSlot(i));
        }
        return array;
    }

    public static ItemStack checkBackpackForHotbarUpgrade(ItemStack backpack) {
        IBackpack iBackpack;
        if (!backpack.func_190926_b() && (iBackpack = IBackpack.of(backpack)) != null) {
            boolean hasNesting = false;
            for (IUpgradeWrapper iUpgradeWrapper : iBackpack.createWrapper().getReadonlyUpdatesArray()) {
                if (iUpgradeWrapper == null) continue;
                if (iUpgradeWrapper.getUpgrade() instanceof UpgradeNesting) {
                    hasNesting = true;
                    continue;
                }
                if (!(iUpgradeWrapper.getUpgrade() instanceof UpgradeHotbarSwapper)) continue;
                return backpack;
            }
            if (hasNesting) {
                for (IUpgradeWrapper iUpgradeWrapper : iBackpack.createWrapper().getReadonlyInventory()) {
                    ItemStack test = VSBUtils.checkBackpackForHotbarUpgrade((ItemStack)iUpgradeWrapper);
                    if (test.func_190926_b()) continue;
                    return test;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getBackpack(EntityPlayer player, int slot) {
        if (slot == -1) {
            return IVSBPlayer.of(player).getCurrentBackpack();
        }
        return player.field_71071_by.func_70301_a(slot);
    }

    public static int getBackpackRows(EnumBackpackType backpackType) {
        switch (backpackType) {
            case BASIC: {
                return 2;
            }
            case REINFORCED: {
                return 4;
            }
            case ADVANCED: {
                return 6;
            }
            case ULTIMATE: {
                return 9;
            }
        }
        return backpackType.getInventorySize() / 9;
    }
}

