/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.container.ContainerBackpack;
import v0id.vsb.item.ItemSimple;

public class UpgradeSorter
extends ItemSimple
implements IUpgrade {
    public UpgradeSorter() {
        super("upgrade_sorting", 1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.sorting.desc", (Object[])new Object[0]).split("\\|")));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af() && !worldIn.field_72995_K) {
            ItemStack is = playerIn.func_184586_b(handIn);
            if (!is.func_77942_o()) {
                is.func_77982_d(new NBTTagCompound());
            }
            is.func_77978_p().func_74757_a("light", !is.func_77978_p().func_74767_n("light"));
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
        int current;
        int n = current = self.getSelf().func_77942_o() ? (int)self.getSelf().func_77978_p().func_74771_c("pulses") : 0;
        if (++current >= 10) {
            current = 0;
            ArrayList allItems = Lists.newArrayList();
            for (int i = 0; i < backpack.getInventory().getSlots(); ++i) {
                ItemStack is = backpack.getInventory().getStackInSlot(i).func_77946_l();
                if (is.func_190926_b()) continue;
                backpack.getInventory().extractItem(i, Integer.MAX_VALUE, false);
                allItems.add(is);
            }
            if (!self.getSelf().func_77942_o() || !self.getSelf().func_77978_p().func_74767_n("light")) {
                allItems.sort(new ComparatorItemStack());
            }
            for (ItemStack is : allItems) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)is, (boolean)false);
            }
            if (pulsar instanceof EntityPlayer) {
                Container openContainer = ((EntityPlayer)pulsar).field_71070_bA;
                if (container instanceof ContainerBackpack) {
                    for (Slot s : ((ContainerBackpack)((Object)container)).field_75151_b) {
                        s.func_75218_e();
                    }
                }
            }
        }
        if (!self.getSelf().func_77942_o()) {
            self.getSelf().func_77982_d(new NBTTagCompound());
        }
        self.getSelf().func_77978_p().func_74774_a("pulses", (byte)current);
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }

    private static class ComparatorItemStack
    implements Comparator<ItemStack> {
        private ComparatorItemStack() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.func_77973_b() != o2.func_77973_b()) {
                return String.valueOf(o1.func_77973_b().getRegistryName()).compareTo(String.valueOf(o2.func_77973_b().getRegistryName()));
            }
            if (o1.func_77960_j() != o2.func_77960_j()) {
                return Ints.compare((int)o1.func_77960_j(), (int)o2.func_77960_j());
            }
            if (ItemStack.func_77970_a((ItemStack)o1, (ItemStack)o2)) {
                return 0;
            }
            return Ints.compare((int)System.identityHashCode(o1), (int)System.identityHashCode(o2));
        }
    }
}

