/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.item.ItemSimple;

public class UpgradeSolarGenerator
extends ItemSimple
implements IUpgrade {
    public UpgradeSolarGenerator() {
        super("upgrade_generator_solar", 1);
    }

    private float getEnergyByTime(long time) {
        if ((time %= 24000L) >= 1000L && time <= 11000L) {
            return 1.0f;
        }
        if (time <= 1000L) {
            return (float)time / 1000.0f;
        }
        if (time < 12000L) {
            return 1.0f - (float)(time - 11000L) / 1000.0f;
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.generator_solar.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        BlockPos tickerPos = ticker.func_180425_c();
        boolean raining = ticker.func_130014_f_().func_72896_J();
        float mul = this.getEnergyByTime(ticker.func_130014_f_().func_72820_D());
        if (raining) {
            mul = (float)((double)mul * 0.35);
        }
        if (mul > 1.0E-4f && ticker.func_130014_f_().func_175710_j(tickerPos.func_177984_a())) {
            backpack.getSelfAsCapability().getEnergyStorage().receiveEnergy(Math.round((float)VSBCfg.solarUpgradeFEPerTick * mul), false);
        }
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return backpack.getMaxEnergy() > 0;
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

