/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.ItemSimple;

public class UpgradeNesting
extends ItemSimple
implements IUpgrade {
    public UpgradeNesting() {
        super("upgrade_nesting", 1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.nesting.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        for (ItemStack stack : backpack.getReadonlyInventory()) {
            IBackpack backpackCap = IBackpack.of(stack);
            if (backpackCap == null) continue;
            for (IUpgradeWrapper upgradeWrapper : backpackCap.createWrapper().getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null) continue;
                upgradeWrapper.getUpgrade().onTick(backpack, backpackCap.createWrapper(), upgradeWrapper, ticker);
            }
        }
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
        for (ItemStack stack : backpack.getReadonlyInventory()) {
            IBackpack backpackCap = IBackpack.of(stack);
            if (backpackCap == null) continue;
            for (IUpgradeWrapper upgradeWrapper : backpackCap.createWrapper().getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null) continue;
                upgradeWrapper.getUpgrade().onPulse(backpack, backpackCap.createWrapper(), upgradeWrapper, pulsar);
            }
        }
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem is, Entity picker) {
        for (ItemStack stack : backpack.getReadonlyInventory()) {
            IBackpack backpackCap = IBackpack.of(stack);
            if (backpackCap == null) continue;
            for (IUpgradeWrapper upgradeWrapper : backpackCap.createWrapper().getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null || !upgradeWrapper.getUpgrade().onItemPickup(backpack, backpackCap.createWrapper(), upgradeWrapper, is, picker)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EnumActionResult onBlockClick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityPlayer player, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (ItemStack is : backpack.getReadonlyInventory()) {
            IBackpack isBackpack = IBackpack.of(is);
            if (isBackpack == null) continue;
            for (IUpgradeWrapper upgradeWrapper : isBackpack.createWrapper().getReadonlyUpdatesArray()) {
                EnumActionResult result;
                if (upgradeWrapper == null || (result = upgradeWrapper.getUpgrade().onBlockClick(backpack, isBackpack.createWrapper(), upgradeWrapper, player, pos, side, hitX, hitY, hitZ)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

