/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.container.ContainerUpgradeEnderStorage;
import v0id.vsb.item.upgrade.UpgradeFiltered;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.EnumGuiType;
import v0id.vsb.util.Lazy;
import v0id.vsb.util.VSBUtils;

public class UpgradeEnderStorage
extends UpgradeFiltered {
    private static final Lazy<Class<?>> classEnderStorageManager = new Lazy<Class>(() -> VSBUtils.getOptionalClass("codechicken.enderstorage.manager.EnderStorageManager", () -> Loader.isModLoaded((String)"enderstorage")));
    private static final Lazy<Class<?>> classFrequency = new Lazy<Class>(() -> VSBUtils.getOptionalClass("codechicken.enderstorage.api.Frequency", () -> Loader.isModLoaded((String)"enderstorage")));
    private static final Lazy<Class<?>> classChestHelper = new Lazy<Class>(() -> VSBUtils.getOptionalClass("shetiphian.multistorage.common.enderlink.ChestHelper", () -> Loader.isModLoaded((String)"multistorage")));
    private static final Lazy<Method> frequency_fromString = new Lazy<Method>(() -> VSBUtils.getMethodSafe(classFrequency.get(), new Class[]{String.class, String.class, String.class}, "fromString"));
    private static final Lazy<Method> enderStorageManager_instance = new Lazy<Method>(() -> VSBUtils.getMethodSafe(classEnderStorageManager.get(), new Class[]{Boolean.TYPE}, "instance"));
    private static final Lazy<Method> enderStorageManager_getStorage = new Lazy<Method>(() -> VSBUtils.getMethodSafe(classEnderStorageManager.get(), new Class[]{classFrequency.get(), String.class}, "getStorage"));
    private static final Lazy<Method> chestHelper_getChest = new Lazy<Method>(() -> VSBUtils.getMethodSafe(classChestHelper.get(), new Class[]{World.class, String.class, String.class}, "getChest"));

    public UpgradeEnderStorage() {
        super("upgrade_ender_storage");
        this.inventory_size = 4;
    }

    private int getSlot(ItemStack is) {
        return is.func_77978_p().func_74762_e("index");
    }

    private void setSlot(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("index", i);
    }

    private String dyeToColour(ItemStack dye) {
        if (!dye.func_190926_b()) {
            for (String s : VSBUtils.getOreNames(dye)) {
                String colour = this.oreDictToColour(s);
                if (colour == null) continue;
                return colour;
            }
        }
        return null;
    }

    private String oreDictToColour(String oreDictName) {
        if (!oreDictName.startsWith("dye")) {
            return null;
        }
        if (oreDictName.equalsIgnoreCase("dyeWhite")) {
            return "white";
        }
        if (oreDictName.equalsIgnoreCase("dyeOrange")) {
            return "orange";
        }
        if (oreDictName.equalsIgnoreCase("dyeMagenta")) {
            return "magenta";
        }
        if (oreDictName.equalsIgnoreCase("dyeLightBlue")) {
            return "light_blue";
        }
        if (oreDictName.equalsIgnoreCase("dyeYellow")) {
            return "yellow";
        }
        if (oreDictName.equalsIgnoreCase("dyeLime")) {
            return "lime";
        }
        if (oreDictName.equalsIgnoreCase("dyePink")) {
            return "pink";
        }
        if (oreDictName.equalsIgnoreCase("dyeGray")) {
            return "gray";
        }
        if (oreDictName.equalsIgnoreCase("dyeLightGray")) {
            return "light_gray";
        }
        if (oreDictName.equalsIgnoreCase("dyeCyan")) {
            return "cyan";
        }
        if (oreDictName.equalsIgnoreCase("dyePurple")) {
            return "purple";
        }
        if (oreDictName.equalsIgnoreCase("dyeBlue")) {
            return "blue";
        }
        if (oreDictName.equalsIgnoreCase("dyeBrown")) {
            return "brown";
        }
        if (oreDictName.equalsIgnoreCase("dyeGreen")) {
            return "green";
        }
        if (oreDictName.equalsIgnoreCase("dyeRed")) {
            return "red";
        }
        if (oreDictName.equalsIgnoreCase("dyeBlack")) {
            return "black";
        }
        return null;
    }

    private String dyeToCode(ItemStack dye) {
        if (!dye.func_190926_b()) {
            for (String s : VSBUtils.getOreNames(dye)) {
                String code = this.oreDictToCode(s);
                if (code == null) continue;
                return code;
            }
        }
        return null;
    }

    private String oreDictToCode(String oreDictName) {
        if (!oreDictName.startsWith("dye")) {
            return null;
        }
        if (oreDictName.equalsIgnoreCase("dyeWhite")) {
            return "0";
        }
        if (oreDictName.equalsIgnoreCase("dyeOrange")) {
            return "1";
        }
        if (oreDictName.equalsIgnoreCase("dyeMagenta")) {
            return "2";
        }
        if (oreDictName.equalsIgnoreCase("dyeLightBlue")) {
            return "3";
        }
        if (oreDictName.equalsIgnoreCase("dyeYellow")) {
            return "4";
        }
        if (oreDictName.equalsIgnoreCase("dyeLime")) {
            return "5";
        }
        if (oreDictName.equalsIgnoreCase("dyePink")) {
            return "6";
        }
        if (oreDictName.equalsIgnoreCase("dyeGray")) {
            return "7";
        }
        if (oreDictName.equalsIgnoreCase("dyeLightGray")) {
            return "8";
        }
        if (oreDictName.equalsIgnoreCase("dyeCyan")) {
            return "9";
        }
        if (oreDictName.equalsIgnoreCase("dyePurple")) {
            return "A";
        }
        if (oreDictName.equalsIgnoreCase("dyeBlue")) {
            return "B";
        }
        if (oreDictName.equalsIgnoreCase("dyeBrown")) {
            return "C";
        }
        if (oreDictName.equalsIgnoreCase("dyeGreen")) {
            return "D";
        }
        if (oreDictName.equalsIgnoreCase("dyeRed")) {
            return "E";
        }
        if (oreDictName.equalsIgnoreCase("dyeBlack")) {
            return "F";
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.ender_storage.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af() && !worldIn.field_72995_K) {
            ItemStack is = playerIn.func_184586_b(handIn);
            if (!is.func_77942_o()) {
                is.func_77982_d(new NBTTagCompound());
            }
            is.func_77978_p().func_74757_a("multistorage", !is.func_77978_p().func_74767_n("multistorage"));
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        int index;
        boolean useMultiStorage;
        if (!Loader.isModLoaded((String)"enderstorage") && !Loader.isModLoaded((String)"multistorage")) {
            return;
        }
        boolean bl = Loader.isModLoaded((String)"enderstorage") && Loader.isModLoaded((String)"multistorage") ? self.getSelf().func_77942_o() && self.getSelf().func_77978_p().func_74767_n("multistorage") : (useMultiStorage = Loader.isModLoaded((String)"multistorage"));
        if (!self.getSelf().func_77942_o()) {
            self.getSelf().func_77982_d(new NBTTagCompound());
        }
        if ((index = this.getSlot(self.getSelf())) >= backpack.getInventory().getSlots()) {
            index = 0;
        }
        ItemStack is = backpack.getInventory().getStackInSlot(index).func_77946_l();
        IFilter filter = IFilter.of(((IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0));
        if (!is.func_190926_b() && IBackpack.of(is) == null && (filter == null || filter.accepts(is))) {
            IItemHandler inv = (IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack dye0 = inv.getStackInSlot(1);
            ItemStack dye1 = inv.getStackInSlot(2);
            ItemStack dye2 = inv.getStackInSlot(3);
            if (!(dye0.func_190926_b() || dye1.func_190926_b() || dye2.func_190926_b())) {
                if (!useMultiStorage) {
                    String dyeName0 = this.dyeToColour(dye0);
                    String dyeName1 = this.dyeToColour(dye1);
                    String dyeName2 = this.dyeToColour(dye2);
                    if (dyeName0 != null && dyeName1 != null && dyeName2 != null) {
                        InvWrapper itemHandler;
                        ItemStack result;
                        Object frequency = VSBUtils.invokeMethod(frequency_fromString.get(), null, dyeName0, dyeName1, dyeName2);
                        Object enderStorageManager = VSBUtils.invokeMethod(enderStorageManager_instance.get(), null, false);
                        Object storage = VSBUtils.invokeMethod(enderStorageManager_getStorage.get(), enderStorageManager, frequency, "item");
                        if (storage instanceof IInventory && (result = ItemHandlerHelper.insertItemStacked((IItemHandler)(itemHandler = new InvWrapper((IInventory)storage)), (ItemStack)is, (boolean)true)) != is) {
                            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)is, (boolean)false);
                            int extracted = result.func_190926_b() ? is.func_190916_E() : is.func_190916_E() - result.func_190916_E();
                            backpack.getInventory().extractItem(index, extracted, false);
                        }
                    }
                } else {
                    InvWrapper itemHandler;
                    ItemStack result;
                    Object chest;
                    String dyeCode0 = this.dyeToCode(dye0);
                    String dyeCode1 = this.dyeToCode(dye1);
                    String dyeCode2 = this.dyeToCode(dye2);
                    if (dyeCode0 != null && dyeCode1 != null && dyeCode2 != null && (chest = VSBUtils.invokeMethod(chestHelper_getChest.get(), null, ticker.field_70170_p, "all", dyeCode0 + dyeCode1 + dyeCode2)) instanceof IInventory && (result = ItemHandlerHelper.insertItemStacked((IItemHandler)(itemHandler = new InvWrapper((IInventory)chest)), (ItemStack)is, (boolean)true)) != is) {
                        ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)is, (boolean)false);
                        int extracted = result.func_190926_b() ? is.func_190916_E() : is.func_190916_E() - result.func_190916_E();
                        backpack.getInventory().extractItem(index, extracted, false);
                    }
                }
            }
        }
        this.setSlot(self.getSelf(), ++index);
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return Loader.isModLoaded((String)"enderstorage") || Loader.isModLoaded((String)"multistorage");
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }

    @Override
    public void openContainer(EntityPlayerMP player, ItemStack stack, int slot, int slotID, boolean inventory) {
        VSBUtils.openContainer(player, new ContainerUpgradeEnderStorage(player.field_71071_by, stack, slot));
        VSBNet.sendOpenGUI((EntityPlayer)player, slotID, inventory, slot, EnumGuiType.UPGRADE_ENDER_STORAGE);
    }
}

