/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.handler;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.capability.IVSBPlayer;
import v0id.api.vsb.capability.VSBCaps;
import v0id.api.vsb.data.VSBRegistryNames;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.capability.Player;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.container.ContainerBackpack;
import v0id.vsb.item.upgrade.UpgradeSharing;
import v0id.vsb.item.upgrade.UpgradeSoulbound;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.VSBUtils;

@Mod.EventBusSubscriber(modid="v0idssmartbackpacks")
public class VSBEventHandler {
    public static boolean tmbCompatInitialized;
    public static ResourceLocation tableScales;

    @SubscribeEvent
    public static void onCapsAttach(final AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(VSBRegistryNames.asLocation("vsbplayer"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private final Player cap;
                {
                    this.cap = new Player((EntityPlayer)event.getObject());
                }

                public NBTTagCompound serializeNBT() {
                    return this.cap.serializeNBT();
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    this.cap.deserializeNBT(nbt);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == VSBCaps.PLAYER_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == VSBCaps.PLAYER_CAPABILITY ? VSBCaps.PLAYER_CAPABILITY.cast((Object)this.cap) : null);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        IBackpack backpack;
        int i;
        ItemStack is2;
        IVSBPlayer.of(event.getEntityPlayer()).copyFrom(IVSBPlayer.of(event.getOriginal()));
        IVSBPlayer.of(event.getEntityPlayer()).sync();
        if (event.isCanceled() || !event.isWasDeath()) {
            return;
        }
        if (event.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (ItemStack is2 : IVSBPlayer.of(event.getEntityPlayer()).getSavedBackpacks()) {
            if (event.getEntityPlayer().field_71071_by.func_70441_a(is2)) continue;
            event.getEntityPlayer().func_71019_a(is2, false);
        }
        IVSBPlayer.of(event.getEntityPlayer()).getSavedBackpacks().clear();
        for (i = 0; i < event.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
            is2 = (ItemStack)event.getOriginal().field_71071_by.field_70462_a.get(i);
            backpack = IBackpack.of(is2);
            if (backpack == null || !Arrays.stream(backpack.createWrapper().getReadonlyUpdatesArray()).filter(Objects::nonNull).anyMatch(e -> e.getSelf().func_77973_b() instanceof UpgradeSoulbound)) continue;
            event.getOriginal().field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < event.getOriginal().field_71071_by.field_184439_c.size(); ++i) {
            is2 = (ItemStack)event.getOriginal().field_71071_by.field_184439_c.get(i);
            backpack = IBackpack.of(is2);
            if (backpack == null || !Arrays.stream(backpack.createWrapper().getReadonlyUpdatesArray()).filter(Objects::nonNull).anyMatch(e -> e.getSelf().func_77973_b() instanceof UpgradeSoulbound)) continue;
            event.getOriginal().field_71071_by.field_184439_c.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof EntityPlayerMP) {
            IBackpack backpack;
            IVSBPlayer player = IVSBPlayer.of(event.player);
            if (!player.wasTicked()) {
                player.sync();
                player.setWasTicked();
            }
            Iterator<EntityPlayer> iter = player.getListeners().iterator();
            while (iter.hasNext()) {
                EntityPlayer listener = iter.next();
                if (listener == event.player || !(listener.func_70068_e((Entity)event.player) > 4096.0)) continue;
                iter.remove();
            }
            for (EntityPlayer entPlayer : event.player.field_70170_p.field_73010_i) {
                if (player.getListeners().contains(entPlayer) || !(entPlayer.func_70068_e((Entity)event.player) < 4096.0)) continue;
                player.getListeners().add(entPlayer);
                player.syncTo(entPlayer);
            }
            if (!player.getCurrentBackpack().func_190926_b() && (backpack = IBackpack.of(player.getCurrentBackpack())) != null) {
                backpack.onTick(null, (Entity)event.player);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        if (event.getResult() == Event.Result.ALLOW || event.isCanceled()) {
            return;
        }
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            IVSBPlayer player = IVSBPlayer.of(event.getEntityPlayer());
            IBackpack backpack = IBackpack.of(player.getCurrentBackpack());
            if (backpack != null && VSBEventHandler.pickupItem(event.getItem(), backpack.createWrapper(), event.getEntityPlayer())) {
                event.setResult(Event.Result.ALLOW);
                return;
            }
            for (ItemStack is : VSBUtils.getPlayerInventory(event.getEntityPlayer())) {
                if (is.func_190926_b() || (backpack = IBackpack.of(is)) == null || !VSBEventHandler.pickupItem(event.getItem(), backpack.createWrapper(), event.getEntityPlayer())) continue;
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(PlayerDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        IVSBPlayer player = IVSBPlayer.of(event.getEntityPlayer());
        if (!player.getCurrentBackpack().func_190926_b()) {
            boolean hasSoulbound = false;
            IBackpack backpack = IBackpack.of(player.getCurrentBackpack());
            if (backpack != null) {
                for (IUpgradeWrapper upgradeWrapper : backpack.createWrapper().getReadonlyUpdatesArray()) {
                    if (upgradeWrapper == null || !(upgradeWrapper.getSelf().func_77973_b() instanceof UpgradeSoulbound)) continue;
                    hasSoulbound = true;
                    break;
                }
            }
            if (!hasSoulbound) {
                if (!tmbCompatInitialized) {
                    event.getDrops().add(new EntityItem(event.getEntityPlayer().field_70170_p, event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, player.getCurrentBackpack().func_77946_l()));
                }
                player.setCurrentBackpack(ItemStack.field_190927_a);
            }
        }
        Iterator iter = event.getDrops().iterator();
        while (iter.hasNext()) {
            EntityItem item = (EntityItem)iter.next();
            ItemStack is = item.func_92059_d();
            IBackpack backpack = IBackpack.of(is);
            if (backpack == null) continue;
            boolean hasSoulbound = false;
            for (IUpgradeWrapper upgradeWrapper : backpack.createWrapper().getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null || !(upgradeWrapper.getSelf().func_77973_b() instanceof UpgradeSoulbound)) continue;
                hasSoulbound = true;
                break;
            }
            if (!hasSoulbound) continue;
            player.addSavedBackpack(is.func_77946_l());
            iter.remove();
        }
    }

    @SubscribeEvent
    public static void onLootTable(LootTableLoadEvent event) {
        if (event.getName().toString().equals("minecraft:entities/ender_dragon") && VSBCfg.dragonDropsScales) {
            LootEntryTable entry = new LootEntryTable(tableScales, 1, 0, new LootCondition[0], "v0idssmartbackpacks_inject_dragon_scales_entry");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "v0idssmartbackpacks_inject_dragon_scales_pool");
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void onDimensionsChanged(PlayerEvent.PlayerChangedDimensionEvent event) {
        IVSBPlayer.of(event.player).sync();
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityPlayerMP && event.getEntityPlayer() instanceof EntityPlayerMP) {
            IUpgradeWrapper wrapper;
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            EntityPlayerMP other = (EntityPlayerMP)event.getTarget();
            IVSBPlayer ofOther = IVSBPlayer.of((EntityPlayer)other);
            IBackpack backpack = IBackpack.of(ofOther.getCurrentBackpack());
            if (backpack != null && (wrapper = (IUpgradeWrapper)Arrays.stream(backpack.createWrapper().getReadonlyUpdatesArray()).filter(u -> u != null && u.getUpgrade() instanceof UpgradeSharing).findAny().orElse(null)) != null) {
                boolean strict;
                boolean bl = strict = wrapper.getSelf().func_77942_o() && wrapper.getSelf().func_77978_p().func_74767_n("strict");
                if (!strict || other.func_96124_cp() == null || player.func_96124_cp().func_142054_a(other.func_96124_cp())) {
                    VSBUtils.openContainer(player, new ContainerBackpack.ContainerBackpackInventory(ofOther.getCurrentBackpack(), player.field_71071_by, -2, -2));
                    VSBNet.sendOpenWornBackpackOther(player, other);
                    other.func_146105_b((ITextComponent)new TextComponentTranslation("vsb.backpack_opened", new Object[]{player.getDisplayNameString()}), true);
                }
            }
        }
    }

    private static boolean pickupItem(EntityItem item, IBackpackWrapper backpack, EntityPlayer player) {
        for (IUpgradeWrapper wrapper : backpack.getReadonlyUpdatesArray()) {
            if (wrapper == null || !wrapper.getUpgrade().onItemPickup(null, backpack, wrapper, item, (Entity)player)) continue;
            return true;
        }
        return false;
    }
}

