/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.capability.ICraftingUpgrade;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.capability.IVSBPlayer;
import v0id.api.vsb.data.VSBRegistryNames;
import v0id.api.vsb.util.ILifecycleListener;
import v0id.vsb.capability.Backpack;
import v0id.vsb.capability.CraftingUpgrade;
import v0id.vsb.capability.Filter;
import v0id.vsb.capability.Player;
import v0id.vsb.handler.VSBEventHandler;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.IProxy;

@Mod(modid="v0idssmartbackpacks", useMetadata=true, dependencies="after:harvestcraft;after:tombmanygraves2api@[1.12-4.1.0,);after:tombmanygraves@[1.12-4.1.0,)", certificateFingerprint="751ba7c2091ec5cc4cd1fcc6e9a4e9d5a2cace8d", acceptedMinecraftVersions="[1.12.2]")
public class VSB {
    public static List<ILifecycleListener> listeners = Lists.newArrayList();
    @SidedProxy(clientSide="v0id.vsb.client.ClientProxy", serverSide="v0id.vsb.server.ServerProxy")
    public static IProxy proxy;
    private static Logger modLogger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IBackpack.class, (Capability.IStorage)new Capability.IStorage<IBackpack>(){

            @Nullable
            public NBTBase writeNBT(Capability<IBackpack> capability, IBackpack instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IBackpack> capability, IBackpack instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, Backpack::new);
        CapabilityManager.INSTANCE.register(IVSBPlayer.class, (Capability.IStorage)new Capability.IStorage<IVSBPlayer>(){

            @Nullable
            public NBTBase writeNBT(Capability<IVSBPlayer> capability, IVSBPlayer instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IVSBPlayer> capability, IVSBPlayer instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, Player::new);
        CapabilityManager.INSTANCE.register(IFilter.class, (Capability.IStorage)new Capability.IStorage<IFilter>(){

            @Nullable
            public NBTBase writeNBT(Capability<IFilter> capability, IFilter instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IFilter> capability, IFilter instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, Filter::new);
        CapabilityManager.INSTANCE.register(ICraftingUpgrade.class, (Capability.IStorage)new Capability.IStorage<ICraftingUpgrade>(){

            @Nullable
            public NBTBase writeNBT(Capability<ICraftingUpgrade> capability, ICraftingUpgrade instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICraftingUpgrade> capability, ICraftingUpgrade instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, CraftingUpgrade::new);
        VSBNet.register();
        listeners.add(proxy);
        listeners.forEach(l -> l.preInit(event));
        VSBEventHandler.tableScales = LootTableList.func_186375_a((ResourceLocation)VSBRegistryNames.asLocation("inject_dragon_scales"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"tombmanygraves2api")) {
            try {
                Class<?> c = Class.forName("v0id.vsb.compat.TombManyGravesCompat");
                Method m = c.getDeclaredMethod("register", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                FMLCommonHandler.instance().raiseException((Throwable)ex, "VSB was unable to instantinate TombManyGraves compatibility patch!", false);
            }
        }
        listeners.forEach(l -> l.init(event));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        listeners.forEach(l -> l.postInit(event));
    }

    @Mod.EventHandler
    public static void fingerprintViolated(FMLFingerprintViolationEvent event) {
        if (event.isDirectory()) {
            modLogger.warn("VSB fingerprint doesn't match but we are in a dev environment so that's okay.");
        } else {
            modLogger.error("VSB fingerprint doesn't match! Expected {}, got {}!", (Object)event.getExpectedFingerprint(), (Object)String.join((CharSequence)" , ", event.getFingerprints()));
        }
    }

    static {
        modLogger = LogManager.getLogger(VSB.class);
    }
}

