/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import slimeknights.mantle.util.SlimeknightException;

public abstract class BaseContainer<T extends TileEntity>
extends Container {
    protected double maxDist = 64.0;
    protected T tile;
    protected final Block originalBlock;
    protected final BlockPos pos;
    protected final World world;
    protected final IItemHandler itemHandler;
    public List<Container> subContainers = Lists.newArrayList();
    protected int playerInventoryStart = -1;

    public BaseContainer(T tile) {
        this(tile, null);
    }

    public BaseContainer(T tile, EnumFacing invDir) {
        this.tile = tile;
        this.itemHandler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, invDir) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, invDir) : new EmptyHandler();
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.originalBlock = this.world.func_180495_p(this.pos).func_177230_c();
    }

    public void syncOnOpen(EntityPlayerMP playerOpened) {
        WorldServer server = playerOpened.func_71121_q();
        for (EntityPlayer player : server.field_73010_i) {
            if (player == playerOpened || !(player.field_71070_bA instanceof BaseContainer) || !this.sameGui((BaseContainer)player.field_71070_bA)) continue;
            this.syncWithOtherContainer((BaseContainer)player.field_71070_bA, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    public T getTile() {
        return this.tile;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void syncWithOtherContainer(BaseContainer<T> otherContainer, EntityPlayerMP player) {
    }

    protected void syncNewContainer(EntityPlayerMP player) {
    }

    public boolean sameGui(BaseContainer otherContainer) {
        return this.tile == otherContainer.tile;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        Block block = this.world.func_180495_p(this.pos).func_177230_c();
        if (block == Blocks.field_150350_a || block != this.originalBlock) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= this.maxDist;
    }

    @Nonnull
    public NonNullList<ItemStack> func_75138_a() {
        return super.func_75138_a();
    }

    public String getInventoryDisplayName() {
        IInventory nameable = null;
        if (this.itemHandler instanceof InvWrapper && (nameable = ((InvWrapper)this.itemHandler).getInv()).func_145748_c_() == null) {
            nameable = null;
        }
        if (nameable == null && this.tile instanceof IWorldNameable) {
            nameable = (IWorldNameable)this.tile;
        }
        if (nameable != null) {
            ITextComponent textName = nameable.func_145748_c_();
            return textName != null ? textName.func_150254_d() : nameable.func_70005_c_();
        }
        return null;
    }

    protected void addPlayerInventory(InventoryPlayer playerInventory, int xCorner, int yCorner) {
        int index = 9;
        int start = this.field_75151_b.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + row * 18));
                ++index;
            }
        }
        index = 0;
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + 58));
            ++index;
        }
        this.playerInventoryStart = start;
    }

    @Nonnull
    protected Slot func_75146_a(Slot slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new SlimeknightException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.func_75146_a(slotIn);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int end = this.field_75151_b.size();
            if (index < this.playerInventoryStart ? !this.func_75135_a(itemstack1, this.playerInventoryStart, end, true) : !this.func_75135_a(itemstack1, 0, this.playerInventoryStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.func_190926_b() && stack.func_190916_E() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1) && this.func_94530_a(stack, slot)) {
                    int limit;
                    int l = itemstack1.func_190916_E() + stack.func_190916_E();
                    if (l <= (limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        itemstack1.func_190920_e(l);
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.func_190916_E() < limit) {
                        stack.func_190918_g(limit - itemstack1.func_190916_E());
                        itemstack1.func_190920_e(limit);
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_190926_b() && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.func_190916_E() > limit) {
                    stack2.func_190920_e(limit);
                    stack.func_190918_g(limit);
                } else {
                    stack.func_190920_e(0);
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.func_190926_b()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }
}

