/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.little;

import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.gui.handler.LittleGuiHandler;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileTE;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.opf.OPFrameConfig;
import com.creativemd.opf.block.TileEntityPicFrame;
import com.creativemd.opf.little.LittlePlacedOpFrame;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class LittleOpFrame
extends LittleTileTE {
    public LittleOpFrame() {
    }

    public LittleOpFrame(TileEntityPicFrame te, Block block, int meta) {
        super(block, meta, (TileEntity)te);
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<LittleRenderingCube> getInternalRenderingCubes() {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        if (((TileEntityPicFrame)this.getTileEntity()).visibleFrame) {
            CubeObject cube = this.box.getCube(this.getContext());
            EnumFacing direction = EnumFacing.func_82600_a((int)this.getMeta());
            double width = 0.025;
            switch (direction) {
                case EAST: {
                    cube.maxX = (float)((double)cube.minX + width);
                    break;
                }
                case WEST: {
                    cube.minX = (float)((double)cube.maxX - width);
                    break;
                }
                case UP: {
                    cube.maxY = (float)((double)cube.minY + width);
                    break;
                }
                case DOWN: {
                    cube.minY = (float)((double)cube.maxY - width);
                    break;
                }
                case SOUTH: {
                    cube.maxZ = (float)((double)cube.minZ + width);
                    break;
                }
                case NORTH: {
                    cube.minZ = (float)((double)cube.maxZ - width);
                    break;
                }
            }
            cubes.add(new LittleRenderingCube(cube, this.box, Blocks.field_150344_f, 0));
        }
        return cubes;
    }

    public boolean canBeRenderCombined(LittleTile tile) {
        return false;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!super.onBlockActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ, action)) {
            if (!world.field_72995_K && OPFrameConfig.limitations.canInteract(player, world)) {
                LittleGuiHandler.openGui((String)"littleOpFrame", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)player, (LittleTile)this);
            }
            return true;
        }
        return true;
    }

    public boolean shouldTick() {
        return false;
    }

    public ItemStack getDrop() {
        return new ItemStack(this.getBlock(), 1, this.getMeta());
    }

    public static CubeObject getBoundingBoxByTilenEntity(LittleGridContext context, TileEntityPicFrame frame, int meta) {
        Matrix3f rotation;
        float thickness = 0.05f;
        float offsetX = 0.0f;
        if (frame.posX == 1) {
            offsetX = -frame.sizeX / 2.0f;
        } else if (frame.posX == 2) {
            offsetX = (float)((double)(-frame.sizeX) + context.gridMCLength);
        }
        float offsetY = 0.0f;
        if (frame.posY == 1) {
            offsetY = -frame.sizeY / 2.0f;
        } else if (frame.posY == 2) {
            offsetY = (float)((double)(-frame.sizeY) + context.gridMCLength);
        }
        CubeObject cube = new CubeObject(0.0f, offsetY, offsetX, thickness, frame.sizeY + offsetY, frame.sizeX + offsetX);
        EnumFacing direction = EnumFacing.func_82600_a((int)meta);
        Vector3f center = new Vector3f(thickness / 2.0f, (float)context.gridMCLength / 2.0f, (float)context.gridMCLength / 2.0f);
        if (frame.rotation > 0) {
            rotation = new Matrix3f();
            rotation.rotX((float)Math.toRadians((float)frame.rotation * 90.0f));
            cube.rotate(rotation, center);
        }
        if (direction.func_176740_k() != EnumFacing.Axis.Y) {
            cube.rotate(direction.func_176746_e(), center);
        } else {
            rotation = new Matrix3f();
            if (direction == EnumFacing.UP) {
                rotation.rotZ((float)Math.toRadians(90.0));
            } else {
                rotation.rotZ((float)Math.toRadians(-90.0));
            }
            cube.rotate(rotation, center);
        }
        return cube;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.getTileEntity() != null) {
            return LittleOpFrame.getBoundingBoxByTilenEntity(this.getContext(), (TileEntityPicFrame)this.getTileEntity(), this.getMeta()).getAxis().func_72317_d(this.getContext().toVanillaGrid(this.box.minX), this.getContext().toVanillaGrid(this.box.minY), this.getContext().toVanillaGrid(this.box.minZ));
        }
        return super.getRenderBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTileEntity(double x, double y, double z, float partialTickTime) {
        GlStateManager.func_179094_E();
        TileEntityPicFrame frame = (TileEntityPicFrame)this.getTileEntity();
        LittleGridContext context = this.getContext();
        if (!frame.url.equals("")) {
            if (!frame.isTextureLoaded()) {
                frame.loadTexture();
            }
            if (frame.isTextureLoaded()) {
                frame.texture.tick();
                int textureID = frame.texture.getTextureID();
                if (textureID != -1 && frame.transparency > 0.0f) {
                    float sizeX = frame.sizeX;
                    float sizeY = frame.sizeY;
                    GlStateManager.func_179147_l();
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179131_c((float)frame.brightness, (float)frame.brightness, (float)frame.brightness, (float)frame.transparency);
                    GlStateManager.func_179144_i((int)textureID);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.5, (double)0.5);
                    LittleTileVec position = this.box.getMinVec();
                    EnumFacing direction = EnumFacing.func_82600_a((int)this.getMeta());
                    if (direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                        position.add(new LittleTileVec(direction));
                    }
                    switch (direction) {
                        case SOUTH: {
                            ++position.x;
                            break;
                        }
                        case WEST: {
                            ++position.z;
                            break;
                        }
                        case UP: {
                            ++position.z;
                            break;
                        }
                    }
                    GlStateManager.func_179137_b((double)position.getPosX(context), (double)position.getPosY(context), (double)position.getPosZ(context));
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179137_b((double)0.5, (double)-0.5, (double)-0.5);
                    GlStateManager.func_179094_E();
                    if (direction == EnumFacing.UP) {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        GlStateManager.func_179137_b((double)0.0, (double)(-context.gridMCLength), (double)(-context.gridMCLength));
                        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                        GlStateManager.func_179137_b((double)0.0, (double)(-context.gridMCLength), (double)(-context.gridMCLength));
                    } else if (direction == EnumFacing.DOWN) {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                    } else {
                        RenderHelper3D.applyDirection((EnumFacing)direction);
                    }
                    GlStateManager.func_179137_b((double)0.001, (double)(context.gridMCLength / 2.0), (double)(context.gridMCLength / 2.0));
                    GL11.glRotated((double)(frame.rotation * 90), (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)frame.rotationX, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)frame.rotationY, (double)0.0, (double)0.0, (double)1.0);
                    GlStateManager.func_179137_b((double)-0.5, (double)(0.5 + (double)((frame.sizeY - 1.0f) / 2.0f) - context.gridMCLength / 2.0), (double)(0.5 + (double)((frame.sizeX - 1.0f) / 2.0f) - context.gridMCLength / 2.0));
                    double posX = 0.0;
                    if (frame.posX == 1) {
                        posX = -sizeX / 2.0f;
                    } else if (frame.posX == 2) {
                        posX = (double)(-sizeX) + context.gridMCLength;
                    }
                    double posY = 0.0;
                    if (frame.posY == 1) {
                        posY = -sizeY / 2.0f;
                    } else if (frame.posY == 2) {
                        posY = (double)(-sizeY) + context.gridMCLength;
                    }
                    GL11.glTranslated((double)0.0, (double)posY, (double)posX);
                    GlStateManager.func_179091_B();
                    GL11.glScaled((double)1.0, (double)frame.sizeY, (double)frame.sizeX);
                    GL11.glBegin((int)9);
                    GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTexCoord3f((float)(frame.flippedY ? 0.0f : 1.0f), (float)(frame.flippedX ? 0.0f : 1.0f), (float)0.0f);
                    GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
                    GL11.glTexCoord3f((float)(frame.flippedY ? 0.0f : 1.0f), (float)(frame.flippedX ? 1.0f : 0.0f), (float)0.0f);
                    GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
                    GL11.glTexCoord3f((float)(frame.flippedY ? 1.0f : 0.0f), (float)(frame.flippedX ? 1.0f : 0.0f), (float)0.0f);
                    GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
                    GL11.glTexCoord3f((float)(frame.flippedY ? 1.0f : 0.0f), (float)(frame.flippedX ? 0.0f : 1.0f), (float)0.0f);
                    GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
                    GL11.glEnd();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179101_C();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179145_e();
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    public LittleTilePreview getPreviewTile() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTileExtra(nbt);
        nbt.func_74778_a("tID", this.getID());
        return new LittlePlacedOpFrame(this.box.copy(), nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
        super.receivePacket(nbt, net);
        this.te.updateRenderBoundingBox();
        this.te.updateRenderDistance();
    }

    public boolean needCustomRendering() {
        return true;
    }
}

