/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;

public class UnloadDimensionSubCommand
extends BasePregenCommand {
    public UnloadDimensionSubCommand() {
        super(1);
        this.addDescription(0, "Dimension: The Dimension that should be unloaded");
        this.addSuggestion("unloadDimension -1", "Unloads the Nether");
        this.addSuggestion("unloadDimension 1", "Unloads the End");
    }

    @Override
    public String getName() {
        return "unloadDimension";
    }

    @Override
    public String getDescription() {
        return "Unloads a Dimension";
    }

    @Override
    public int getRequiredParameterCount() {
        return 1;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 1) {
            int dimension = UnloadDimensionSubCommand.parseNumber(args[0], 0);
            if (dimension == 0) {
                container.sendChatMessage("Overworld can not be Unloaded");
                return;
            }
            if (!UnloadDimensionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            DimensionManager.unloadWorld((int)dimension);
            container.sendChatMessage("Unloaded Dimension " + dimension);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return UnloadDimensionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }
}

