/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo;

import java.text.DecimalFormat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.TrackerEntry;

public class ServerUsage
extends TrackerEntry {
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.##");
    long data;

    public ServerUsage() {
        this.register();
    }

    @Override
    public String getName() {
        return "Server-Usage";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        buf.writeLong(this.getTracker().getAverage());
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.data = buf.readLong();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public int getYOffset() {
        return 12;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        progress = this.clamp(0.0f, 1.0f, (float)this.getValue() / 50.0f);
        int progresBar = (int)(progress * (float)width);
        int value = this.getValue();
        helper.renderBar(x - width / 2, y, width, progresBar, "Server: " + value + " / 50 ms (" + this.data / 1000L + " qs)");
        float max = (float)value / 50.0f;
        float tps = Math.min(20.0f, 20.0f / max);
        progress = this.clamp(0.0f, 1.0f, tps / 20.0f);
        progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y += 6, width, progresBar, "TPS: " + DECIMALFORMAT.format(tps) + " / 20");
    }

    public int getValue() {
        return (int)(this.data / 1000L / 1000L);
    }

    public float clamp(float min, float max, float current) {
        return current < min ? min : (current > max ? max : current);
    }
}

