/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.machines.BasicDecrystallizer;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityBasicDecrystallizer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory {
    private final int tankCapacity = 20000;
    private int amountAdded = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank outputTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);

    public TileEntityBasicDecrystallizer() {
        this.outputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.SALT_FLUID, 0));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(2, this.outputTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 1;
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 1 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidStack liquid;
        if (this.func_70301_a(slot) != null && this.func_70301_a(slot).func_77973_b() == Items.field_151133_ar && tank.getFluidAmount() >= 1000 && this.func_70301_a(slot).func_190916_E() == 1 && FluidUtil.isValidContainer((ItemStack)this.func_70301_a(slot)) && (liquid = tank.getFluid()) != null) {
            FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, this.stacks, (int)slot, (Item)ForgeModContainer.getInstance().universalBucket);
        }
    }

    public int getScaledFuelLevel(int i) {
        return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.outputTank.getFluidAmount() >= this.outputTank.getCapacity()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(1)).func_77973_b() != ExtraPlanets_Items.IODIDE_SALT) {
            return false;
        }
        if (this.func_70301_a(1).func_190916_E() < 6) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int amountToAdd = 25;
            this.amountAdded += 25;
            this.outputTank.fill(FluidRegistry.getFluidStack((String)"salt_fluid", (int)25), true);
            if (this.amountAdded == 1000) {
                this.amountAdded = 0;
                this.func_70298_a(1, 6);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("outputTank")) {
            this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
        }
        if (this.outputTank.getFluid() != null && this.outputTank.getFluid().getFluid() != ExtraPlanets_Fluids.SALT_FLUID) {
            this.outputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.SALT_FLUID, this.outputTank.getFluidAmount()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        if (this.outputTank.getFluid() != null) {
            nbt.func_74782_a("outputTank", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.basic.decrystallizer.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemStack);
                }
                case 1: {
                    return itemStack.func_77973_b() == ExtraPlanets_Items.IODIDE_SALT;
                }
                case 2: {
                    return itemStack.func_77973_b() == Items.field_151133_ar;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemStack) || !this.shouldPullEnergy();
                }
                case 2: {
                    return FluidUtil.isValidContainer((ItemStack)itemStack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: 
            case 2: {
                return FluidUtil.isValidContainer((ItemStack)itemStack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.func_176731_b((int)(((this.func_145832_p() & 3) + 1) % 4));
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BasicDecrystallizer) {
            return (EnumFacing)state.func_177229_b((IProperty)BasicDecrystallizer.FACING);
        }
        return EnumFacing.NORTH;
    }
}

