/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.items.rockets;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.entities.rockets.EntityTier6Rocket;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPad;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Tier6Rocket
extends Item
implements IHoldableItem {
    public Tier6Rocket(String name) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b(name);
        this.func_77637_a(ExtraPlanets.ItemsTab);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (world.field_72995_K && playerIn instanceof EntityPlayerSP) {
            ClientProxyCore.playerClientHandler.onBuild(8, (EntityPlayerSP)playerIn);
            return EnumActionResult.FAIL;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = world.func_180495_p(pos1);
                Block id = state.func_177230_c();
                int meta = id.func_176201_c(state);
                if (id != ExtraPlanets_Blocks.ADVANCED_LAUCHPAD_FULL || meta != 0) continue;
                padFound = true;
                tile = world.func_175625_s(pos.func_177982_a(i, 0, j));
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (tile instanceof TileEntityTier2LandingPad) {
                if (((TileEntityTier2LandingPad)tile).getDockedEntity() != null) {
                    return EnumActionResult.FAIL;
                }
            } else {
                return EnumActionResult.FAIL;
            }
            EntityTier6Rocket spaceship = new EntityTier6Rocket(world, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()]);
            spaceship.func_70107_b(spaceship.field_70165_t, spaceship.field_70163_u + spaceship.getOnPadYOffset(), spaceship.field_70161_v);
            world.func_72838_d((Entity)spaceship);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
                spaceship.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (spaceship.rocketType.getPreFueled()) {
                spaceship.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, spaceship.getMaxFuel()), true);
            }
        } else {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (int i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> par2List, ITooltipFlag flagIn) {
        IRocketType.EnumRocketType type = itemStack.func_77952_i() < 10 ? IRocketType.EnumRocketType.values()[itemStack.func_77952_i()] : IRocketType.EnumRocketType.values()[itemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            par2List.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            par2List.add(EnumColor.RED + "\u00a7o" + TranslateUtilities.translate((String)"gui.creative_only.desc"));
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("RocketFuel")) {
            EntityTier6Rocket rocket = new EntityTier6Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[itemStack.func_77952_i()]);
            par2List.add(TranslateUtilities.translate((String)"gui.message.fuel.name") + ": " + itemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + rocket.fuelTank.getCapacity());
        }
        par2List.add(EnumColor.AQUA + TranslateUtilities.translate((String)"rocket_pad.tier2.desc"));
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + ".t6Rocket";
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }
}

