/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.SchematicPrinter;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.SchematicWorld;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.AxisAlignedBB;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int ticks = -1;

    private TickHandler() {
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Reference.logger.info("Scheduling client settings reset.");
        ClientProxy.isPendingReset = true;
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Reference.logger.info("Scheduling client settings reset.");
        ClientProxy.isPendingReset = true;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.minecraft.field_71424_I.func_76320_a("schematica");
            SchematicWorld schematic = Schematica.proxy.getActiveSchematic();
            if (this.minecraft.field_71439_g != null && schematic != null && schematic.isRendering) {
                this.minecraft.field_71424_I.func_76320_a("printer");
                SchematicPrinter printer = SchematicPrinter.INSTANCE;
                if (printer.isEnabled() && printer.isPrinting() && this.ticks-- < 0) {
                    this.ticks = ConfigurationHandler.placeDelay;
                    printer.print();
                }
                this.minecraft.field_71424_I.func_76318_c("checkDirty");
                this.checkDirty(schematic);
                this.minecraft.field_71424_I.func_76318_c("canUpdate");
                RendererSchematicChunk.setCanUpdate(true);
                this.minecraft.field_71424_I.func_76319_b();
            }
            if (ClientProxy.isPendingReset) {
                Schematica.proxy.resetSettings();
                ClientProxy.isPendingReset = false;
            }
            this.minecraft.field_71424_I.func_76319_b();
        }
    }

    private void checkDirty(SchematicWorld schematic) {
        WorldRenderer[] renderers = this.minecraft.field_71438_f.field_72768_k;
        if (renderers != null) {
            int count = 0;
            for (WorldRenderer worldRenderer : renderers) {
                if (worldRenderer == null || !worldRenderer.field_78939_q || count++ >= 125) continue;
                AxisAlignedBB worldRendererBoundingBox = worldRenderer.field_78938_r.func_72325_c((double)(-schematic.position.x), (double)(-schematic.position.y), (double)(-schematic.position.z));
                for (RendererSchematicChunk renderer : RendererSchematicGlobal.INSTANCE.sortedRendererSchematicChunk) {
                    if (renderer.getDirty() || !renderer.getBoundingBox().func_72326_a(worldRendererBoundingBox)) continue;
                    renderer.setDirty();
                }
            }
        }
    }
}

