/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.config;

import com.github.lunatrius.schematica.config.PlacementData;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class BlockInfo {
    public static final List<Block> BLOCK_LIST_IGNORE_BLOCK = new ArrayList<Block>();
    public static final List<Block> BLOCK_LIST_IGNORE_METADATA = new ArrayList<Block>();
    public static final Map<Block, Item> BLOCK_ITEM_MAP = new HashMap<Block, Item>();
    public static final Map<Class, PlacementData> CLASS_PLACEMENT_MAP = new HashMap<Class, PlacementData>();
    public static final Map<Item, PlacementData> ITEM_PLACEMENT_MAP = new HashMap<Item, PlacementData>();
    private static String modId = "minecraft";

    public static void setModId(String modId) {
        BlockInfo.modId = modId;
    }

    public static void populateIgnoredBlocks() {
        BLOCK_LIST_IGNORE_BLOCK.clear();
        BlockInfo.addIgnoredBlock((Block)Blocks.field_150332_K);
        BlockInfo.addIgnoredBlock((Block)Blocks.field_150326_M);
        BlockInfo.addIgnoredBlock((Block)Blocks.field_150427_aO);
        BlockInfo.addIgnoredBlock(Blocks.field_150384_bq);
    }

    private static boolean addIgnoredBlock(Block block) {
        if (block == null) {
            return false;
        }
        return BLOCK_LIST_IGNORE_BLOCK.add(block);
    }

    private static boolean addIgnoredBlock(String blockName) {
        if (!"minecraft".equals(modId) && !Loader.isModLoaded((String)modId)) {
            return false;
        }
        return BlockInfo.addIgnoredBlock((Block)GameData.getBlockRegistry().func_82594_a(String.format("%s:%s", modId, blockName)));
    }

    public static void populateIgnoredBlockMetadata() {
        BLOCK_LIST_IGNORE_METADATA.clear();
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150358_i);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150355_j);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150356_k);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150353_l);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150367_z);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150324_C);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150318_D);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150319_E);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150320_F);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150331_J);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150478_aa);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150476_ad);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150486_ae);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150488_af);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150464_aj);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150458_ak);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150460_al);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150470_am);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150472_an);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150466_ao);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150468_ap);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150448_aq);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150446_ar);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150444_as);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150442_at);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150456_au);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150454_av);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150452_aw);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150437_az);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150429_aA);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150430_aB);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150434_aF);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150436_aH);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150423_aK);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150427_aO);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150428_aP);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150414_aQ);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150413_aR);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150416_aS);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150415_aT);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150395_bd);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150396_be);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150389_bf);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150390_bg);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150392_bi);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150387_bl);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150388_bm);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150378_br);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150379_bu);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150374_bv);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150372_bz);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150477_bB);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150479_bC);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150473_bD);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150485_bF);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150487_bG);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150481_bH);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150483_bI);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150457_bL);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150459_bM);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150469_bN);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150471_bO);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150467_bQ);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150447_bR);
        BlockInfo.addIgnoredBlockMetadata((Block)Blocks.field_150438_bZ);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150370_cb);
        BlockInfo.addIgnoredBlockMetadata(Blocks.field_150409_cd);
    }

    private static boolean addIgnoredBlockMetadata(Block block) {
        if (block == null) {
            return false;
        }
        return BLOCK_LIST_IGNORE_METADATA.add(block);
    }

    private static boolean addIgnoredBlockMetadata(String blockName) {
        if (!"minecraft".equals(modId) && !Loader.isModLoaded((String)modId)) {
            return false;
        }
        return BlockInfo.addIgnoredBlockMetadata((Block)GameData.getBlockRegistry().func_82594_a(String.format("%s:%s", modId, blockName)));
    }

    public static void populateBlockItemMap() {
        BLOCK_ITEM_MAP.clear();
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150358_i, Items.field_151131_as);
        BlockInfo.addBlockItemMapping(Blocks.field_150355_j, Items.field_151131_as);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150356_k, Items.field_151129_at);
        BlockInfo.addBlockItemMapping(Blocks.field_150353_l, Items.field_151129_at);
        BlockInfo.addBlockItemMapping(Blocks.field_150324_C, Items.field_151104_aV);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150488_af, Items.field_151137_ax);
        BlockInfo.addBlockItemMapping(Blocks.field_150464_aj, Items.field_151014_N);
        BlockInfo.addBlockItemMapping(Blocks.field_150470_am, Blocks.field_150460_al);
        BlockInfo.addBlockItemMapping(Blocks.field_150472_an, Items.field_151155_ap);
        BlockInfo.addBlockItemMapping(Blocks.field_150466_ao, Items.field_151135_aq);
        BlockInfo.addBlockItemMapping(Blocks.field_150454_av, Items.field_151139_aw);
        BlockInfo.addBlockItemMapping(Blocks.field_150444_as, Items.field_151155_ap);
        BlockInfo.addBlockItemMapping(Blocks.field_150437_az, Blocks.field_150429_aA);
        BlockInfo.addBlockItemMapping(Blocks.field_150436_aH, Items.field_151120_aE);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150413_aR, Items.field_151107_aW);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150416_aS, Items.field_151107_aW);
        BlockInfo.addBlockItemMapping(Blocks.field_150393_bb, Items.field_151080_bb);
        BlockInfo.addBlockItemMapping(Blocks.field_150394_bc, Items.field_151081_bc);
        BlockInfo.addBlockItemMapping(Blocks.field_150388_bm, Items.field_151075_bm);
        BlockInfo.addBlockItemMapping(Blocks.field_150382_bo, Items.field_151067_bt);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150383_bp, Items.field_151066_bu);
        BlockInfo.addBlockItemMapping(Blocks.field_150374_bv, Blocks.field_150379_bu);
        BlockInfo.addBlockItemMapping(Blocks.field_150375_by, Items.field_151100_aR);
        BlockInfo.addBlockItemMapping(Blocks.field_150473_bD, Items.field_151007_F);
        BlockInfo.addBlockItemMapping(Blocks.field_150457_bL, Items.field_151162_bE);
        BlockInfo.addBlockItemMapping(Blocks.field_150459_bM, Items.field_151172_bF);
        BlockInfo.addBlockItemMapping(Blocks.field_150469_bN, Items.field_151174_bG);
        BlockInfo.addBlockItemMapping(Blocks.field_150465_bP, Items.field_151144_bL);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150441_bU, Items.field_151132_bS);
        BlockInfo.addBlockItemMapping((Block)Blocks.field_150455_bV, Items.field_151132_bS);
    }

    private static Item addBlockItemMapping(Block block, Item item) {
        if (block == null || item == null) {
            return null;
        }
        return BLOCK_ITEM_MAP.put(block, item);
    }

    private static Item addBlockItemMapping(Block block, Block item) {
        return BlockInfo.addBlockItemMapping(block, Item.func_150898_a((Block)item));
    }

    private static Item addBlockItemMapping(Object blockObj, Object itemObj) {
        if (!"minecraft".equals(modId) && !Loader.isModLoaded((String)modId)) {
            return null;
        }
        Block block = null;
        Item item = null;
        if (blockObj instanceof Block) {
            block = (Block)blockObj;
        } else if (blockObj instanceof String) {
            block = (Block)GameData.getBlockRegistry().func_82594_a(String.format("%s:%s", modId, blockObj));
        }
        if (itemObj instanceof Item) {
            item = (Item)itemObj;
        } else if (itemObj instanceof Block) {
            item = Item.func_150898_a((Block)((Block)itemObj));
        } else if (itemObj instanceof String) {
            String formattedName = String.format("%s:%s", modId, itemObj);
            item = (Item)GameData.getItemRegistry().func_82594_a(formattedName);
            if (item == null) {
                item = Item.func_150898_a((Block)((Block)GameData.getBlockRegistry().func_82594_a(formattedName)));
            }
        }
        return BlockInfo.addBlockItemMapping(block, item);
    }

    public static Item getItemFromBlock(Block block) {
        Item item = BLOCK_ITEM_MAP.get(block);
        if (item != null) {
            return item;
        }
        return Item.func_150898_a((Block)block);
    }

    public static void populatePlacementMaps() {
        ITEM_PLACEMENT_MAP.clear();
        BlockInfo.addPlacementMapping(BlockButton.class, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 4, 1, 2).setMaskMeta(7));
        BlockInfo.addPlacementMapping(BlockChest.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        BlockInfo.addPlacementMapping(BlockDispenser.class, new PlacementData(PlacementData.PlacementType.PISTON, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        BlockInfo.addPlacementMapping(BlockEnderChest.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        BlockInfo.addPlacementMapping(BlockFurnace.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        BlockInfo.addPlacementMapping(BlockHopper.class, new PlacementData(PlacementData.PlacementType.BLOCK, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        BlockInfo.addPlacementMapping(BlockPistonBase.class, new PlacementData(PlacementData.PlacementType.PISTON, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        BlockInfo.addPlacementMapping(BlockPumpkin.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(15));
        BlockInfo.addPlacementMapping(BlockRotatedPillar.class, new PlacementData(PlacementData.PlacementType.BLOCK, 0, 0, 8, 8, 4, 4).setMaskMeta(12).setMaskMetaInHand(3));
        BlockInfo.addPlacementMapping(BlockStairs.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 1, 0).setOffset(4, 0.0f, 1.0f).setMaskMeta(3));
        BlockInfo.addPlacementMapping(BlockTorch.class, new PlacementData(PlacementData.PlacementType.BLOCK, 5, -1, 3, 4, 1, 2).setMaskMeta(15));
        BlockInfo.addPlacementMapping(Blocks.field_150346_d, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150344_f, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150322_A, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150325_L, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150327_N, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150328_O, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150334_T, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150333_U, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setOffset(8, 0.0f, 1.0f).setMaskMeta(7).setMaskMetaInHand(7));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150399_cn, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150468_ap, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 2, 5, 4));
        BlockInfo.addPlacementMapping(Blocks.field_150442_at, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 4, 1, 2).setMaskMeta(7));
        BlockInfo.addPlacementMapping(Blocks.field_150431_aC, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(7));
        BlockInfo.addPlacementMapping(Blocks.field_150415_aT, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 1, 0, 3, 2).setOffset(8, 0.0f, 1.0f).setMaskMeta(3));
        BlockInfo.addPlacementMapping(Blocks.field_150418_aU, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150417_aV, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150479_bC, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
        BlockInfo.addPlacementMapping(Blocks.field_150371_ca, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150396_be, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 2, 0, 1, 3).setMaskMeta(3));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150373_bw, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150376_bx, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setOffset(8, 0.0f, 1.0f).setMaskMeta(7).setMaskMetaInHand(7));
        BlockInfo.addPlacementMapping(Blocks.field_150467_bQ, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 1, 3, 0, 2).setMaskMeta(3).setMaskMetaInHand(12).setBitShiftMetaInHand(2));
        BlockInfo.addPlacementMapping(Blocks.field_150406_ce, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Blocks.field_150404_cg, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping((Block)Blocks.field_150397_co, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setMaskMetaInHand(15));
        BlockInfo.addPlacementMapping(Items.field_151135_aq, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 1, 2, 0).setMaskMeta(7));
        BlockInfo.addPlacementMapping(Items.field_151139_aw, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 1, 2, 0).setMaskMeta(7));
        BlockInfo.addPlacementMapping(Items.field_151107_aW, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
        BlockInfo.addPlacementMapping(Items.field_151132_bS, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
    }

    public static PlacementData addPlacementMapping(Class clazz, PlacementData data) {
        if (clazz == null || data == null) {
            return null;
        }
        return CLASS_PLACEMENT_MAP.put(clazz, data);
    }

    public static PlacementData addPlacementMapping(Item item, PlacementData data) {
        if (item == null || data == null) {
            return null;
        }
        return ITEM_PLACEMENT_MAP.put(item, data);
    }

    public static PlacementData addPlacementMapping(Block block, PlacementData data) {
        return BlockInfo.addPlacementMapping(Item.func_150898_a((Block)block), data);
    }

    public static PlacementData addPlacementMapping(Object itemObj, PlacementData data) {
        if (itemObj == null || data == null) {
            return null;
        }
        Item item = null;
        if (itemObj instanceof Item) {
            item = (Item)itemObj;
        } else if (itemObj instanceof Block) {
            item = Item.func_150898_a((Block)((Block)itemObj));
        } else if (itemObj instanceof String) {
            String formattedName = String.format("%s:%s", modId, itemObj);
            item = (Item)GameData.getItemRegistry().func_82594_a(formattedName);
            if (item == null) {
                item = Item.func_150898_a((Block)((Block)GameData.getBlockRegistry().func_82594_a(formattedName)));
            }
        }
        return BlockInfo.addPlacementMapping(item, data);
    }

    public static PlacementData getPlacementDataFromItem(Item item) {
        Block block = Block.func_149634_a((Item)item);
        PlacementData data = null;
        for (Class clazz : CLASS_PLACEMENT_MAP.keySet()) {
            if (!clazz.isInstance(block)) continue;
            data = CLASS_PLACEMENT_MAP.get(clazz);
            break;
        }
        for (Item i : ITEM_PLACEMENT_MAP.keySet()) {
            if (i != item) continue;
            data = ITEM_PLACEMENT_MAP.get(i);
            break;
        }
        return data;
    }

    static {
        BlockInfo.populateIgnoredBlocks();
        BlockInfo.populateIgnoredBlockMetadata();
        BlockInfo.populateBlockItemMap();
        BlockInfo.populatePlacementMaps();
    }
}

