/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.renderer;

import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.renderer.RenderHelper;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunkComparator;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.world.SchematicWorld;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RendererSchematicGlobal {
    public static final RendererSchematicGlobal INSTANCE = new RendererSchematicGlobal();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final Profiler profiler;
    private final Frustrum frustrum;
    public RenderBlocks renderBlocks;
    public final List<RendererSchematicChunk> sortedRendererSchematicChunk;
    private final RendererSchematicChunkComparator rendererSchematicChunkComparator;

    private RendererSchematicGlobal() {
        this.profiler = this.minecraft.field_71424_I;
        this.frustrum = new Frustrum();
        this.renderBlocks = null;
        this.sortedRendererSchematicChunk = new ArrayList<RendererSchematicChunk>();
        this.rendererSchematicChunkComparator = new RendererSchematicChunkComparator();
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        EntityClientPlayerMP player = this.minecraft.field_71439_g;
        if (player != null) {
            ClientProxy.setPlayerData((EntityPlayer)player, event.partialTicks);
            this.profiler.func_76320_a("schematica");
            SchematicWorld schematic = Schematica.proxy.getActiveSchematic();
            if (schematic != null && schematic.isRendering || ClientProxy.isRenderingGuide) {
                this.render(schematic);
            }
            this.profiler.func_76319_b();
        }
    }

    public void render(SchematicWorld schematic) {
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        Vector3d playerPosition = ClientProxy.playerPosition.clone();
        Vector3d extra = new Vector3d();
        if (schematic != null) {
            extra.add(schematic.position.toVector3d());
            playerPosition.sub(extra);
        }
        GL11.glTranslated((double)(-playerPosition.x), (double)(-playerPosition.y), (double)(-playerPosition.z));
        this.profiler.func_76320_a("schematic");
        if (schematic != null && schematic.isRendering) {
            this.profiler.func_76320_a("updateFrustrum");
            this.updateFrustrum(schematic);
            this.profiler.func_76318_c("sortAndUpdate");
            if (RendererSchematicChunk.getCanUpdate()) {
                this.sortAndUpdate(schematic);
            }
            this.profiler.func_76318_c("render");
            for (int pass = 0; pass < 3; ++pass) {
                for (RendererSchematicChunk renderer : this.sortedRendererSchematicChunk) {
                    renderer.render(pass);
                }
            }
            this.profiler.func_76319_b();
        }
        this.profiler.func_76318_c("guide");
        RenderHelper.createBuffers();
        this.profiler.func_76320_a("dataPrep");
        if (schematic != null && schematic.isRendering) {
            RenderHelper.drawCuboidOutline(RenderHelper.VEC_ZERO, schematic.dimensions(), 63, 0.75f, 0.0f, 0.75f, 0.25f);
        }
        if (ClientProxy.isRenderingGuide) {
            Vector3d start = new Vector3d();
            Vector3d end = new Vector3d();
            ClientProxy.pointMin.toVector3d(start).sub(extra);
            ClientProxy.pointMax.toVector3d(end).sub(extra).add(1.0, 1.0, 1.0);
            RenderHelper.drawCuboidOutline(start.toVector3f(), end.toVector3f(), 63, 0.0f, 0.75f, 0.0f, 0.25f);
            ClientProxy.pointA.toVector3d(start).sub(extra);
            end.set(start).add(1.0, 1.0, 1.0);
            RenderHelper.drawCuboidOutline(start.toVector3f(), end.toVector3f(), 63, 0.75f, 0.0f, 0.0f, 0.25f);
            RenderHelper.drawCuboidSurface(start.toVector3f(), end.toVector3f(), 63, 0.75f, 0.0f, 0.0f, 0.25f);
            ClientProxy.pointB.toVector3d(start).sub(extra);
            end.set(start).add(1.0, 1.0, 1.0);
            RenderHelper.drawCuboidOutline(start.toVector3f(), end.toVector3f(), 63, 0.0f, 0.0f, 0.75f, 0.25f);
            RenderHelper.drawCuboidSurface(start.toVector3f(), end.toVector3f(), 63, 0.0f, 0.0f, 0.75f, 0.25f);
        }
        int quadCount = RenderHelper.getQuadCount();
        int lineCount = RenderHelper.getLineCount();
        if (quadCount > 0 || lineCount > 0) {
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)1.5f);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            this.profiler.func_76318_c("quad");
            if (quadCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
            }
            this.profiler.func_76318_c("line");
            if (lineCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
            }
            this.profiler.func_76319_b();
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32884);
            GL11.glEnable((int)3553);
        }
        this.profiler.func_76319_b();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void updateFrustrum(SchematicWorld schematic) {
        this.frustrum.func_78547_a(ClientProxy.playerPosition.x - (double)schematic.position.x, ClientProxy.playerPosition.y - (double)schematic.position.y, ClientProxy.playerPosition.z - (double)schematic.position.z);
        for (RendererSchematicChunk rendererSchematicChunk : this.sortedRendererSchematicChunk) {
            rendererSchematicChunk.isInFrustrum = this.frustrum.func_78546_a(rendererSchematicChunk.getBoundingBox());
        }
    }

    private void sortAndUpdate(SchematicWorld schematic) {
        this.rendererSchematicChunkComparator.setPosition(schematic.position);
        Collections.sort(this.sortedRendererSchematicChunk, this.rendererSchematicChunkComparator);
        for (RendererSchematicChunk rendererSchematicChunk : this.sortedRendererSchematicChunk) {
            if (!rendererSchematicChunk.getDirty()) continue;
            rendererSchematicChunk.updateRenderer();
            break;
        }
    }

    public void createRendererSchematicChunks(SchematicWorld schematic) {
        int width = (schematic.getWidth() - 1) / 16 + 1;
        int height = (schematic.func_72800_K() - 1) / 16 + 1;
        int length = (schematic.getLength() - 1) / 16 + 1;
        this.destroyRendererSchematicChunks();
        this.renderBlocks = new RenderBlocks((IBlockAccess)schematic);
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    this.sortedRendererSchematicChunk.add(new RendererSchematicChunk(schematic, x, y, z));
                }
            }
        }
    }

    public void destroyRendererSchematicChunks() {
        this.renderBlocks = null;
        while (this.sortedRendererSchematicChunk.size() > 0) {
            this.sortedRendererSchematicChunk.remove(0).delete();
        }
    }

    public void refresh() {
        for (RendererSchematicChunk renderer : this.sortedRendererSchematicChunk) {
            renderer.setDirty();
        }
    }
}

