/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.utils;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemDuct;
import erogenousbeef.bigreactors.utils.InventoryHelper;
import erogenousbeef.bigreactors.utils.SidedInventoryHelper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.bigreactors.utils.intermod.ModHelperBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AdjacentInventoryHelper {
    private ForgeDirection dir;
    private TileEntity entity;
    private IItemDuct duct;
    private IPipeTile pipe;
    private InventoryHelper inv;

    public AdjacentInventoryHelper(ForgeDirection dir) {
        this.dir = dir;
        this.entity = null;
        this.duct = null;
        this.pipe = null;
        this.inv = null;
    }

    public ItemStack distribute(ItemStack itemToDistribute) {
        if (this.entity == null || itemToDistribute == null) {
            return itemToDistribute;
        }
        if (!this.hasConnection()) {
            return itemToDistribute;
        }
        if (ModHelperBase.useCofh && this.duct != null) {
            itemToDistribute = this.duct.insertItem(this.dir.getOpposite(), itemToDistribute);
        } else if (ModHelperBase.useBuildcraftTransport && this.pipe != null) {
            if (this.pipe.isPipeConnected(this.dir.getOpposite())) {
                itemToDistribute.field_77994_a -= this.pipe.injectItem(itemToDistribute.func_77946_l(), true, this.dir.getOpposite());
                if (itemToDistribute.field_77994_a <= 0) {
                    itemToDistribute = null;
                }
            }
        } else if (this.inv != null) {
            itemToDistribute = this.inv.addItem(itemToDistribute);
        }
        return itemToDistribute;
    }

    public boolean hasConnection() {
        return this.inv != null || this.pipe != null || this.duct != null;
    }

    public boolean set(TileEntity te) {
        if (this.entity == te) {
            return false;
        }
        if (te == null) {
            this.duct = null;
            this.pipe = null;
            this.inv = null;
        } else if (ModHelperBase.useCofh && te instanceof IItemDuct) {
            this.setDuct((IItemDuct)te);
        } else if (ModHelperBase.useBuildcraftTransport && te instanceof IPipeTile) {
            this.setPipe((IPipeTile)te);
        } else if (te instanceof IInventory) {
            this.setInv(te);
        }
        this.entity = te;
        return true;
    }

    private void setDuct(IItemDuct duct) {
        this.duct = duct;
        this.pipe = null;
        this.inv = null;
    }

    private void setPipe(IPipeTile pipe) {
        this.pipe = pipe;
        this.duct = null;
        this.inv = null;
    }

    private void setInv(TileEntity te) {
        this.pipe = null;
        this.duct = null;
        this.inv = null;
        if (te instanceof ISidedInventory) {
            this.inv = new SidedInventoryHelper((ISidedInventory)te, this.dir.getOpposite());
        } else {
            IInventory inv = (IInventory)te;
            World world = te.func_145831_w();
            if (world.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e) == Blocks.field_150486_ae) {
                inv = StaticUtils.Inventory.checkForDoubleChest(world, inv, te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
            this.inv = new InventoryHelper(inv);
        }
    }
}

