/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.client.ClientProxy;
import erogenousbeef.bigreactors.client.gui.GuiCyaniteReprocessor;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventoryFluid;
import erogenousbeef.bigreactors.gui.container.ContainerCyaniteReprocessor;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCyaniteReprocessor
extends TileEntityPoweredInventoryFluid {
    public static final int SLOT_INLET = 0;
    public static final int SLOT_OUTLET = 1;
    public static final int NUM_SLOTS = 2;
    public static final int FLUIDTANK_WATER = 0;
    public static final int NUM_TANKS = 1;
    protected static final int FLUID_CONSUMED = 1000;
    protected static final int INGOTS_CONSUMED = 2;

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public String func_145825_b() {
        return "Cyanite Reprocessor";
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        if (slot == 1) {
            return Reactants.isFuel(itemstack);
        }
        if (slot == 0) {
            return Reactants.isWaste(itemstack);
        }
        return false;
    }

    @Override
    public int getMaxEnergyStored() {
        return 10000;
    }

    @Override
    public int getCycleEnergyCost() {
        return 2000;
    }

    @Override
    public int getCycleLength() {
        return 200;
    }

    @Override
    public boolean canBeginCycle() {
        FluidStack fluid = this.drain(0, 1000, false);
        if (fluid == null || fluid.amount < 1000) {
            return false;
        }
        if (this._inventories[0] != null && this._inventories[0].field_77994_a >= 2) {
            return this._inventories[1] == null || this._inventories[1].field_77994_a < this.func_70297_j_();
        }
        return false;
    }

    @Override
    public void onPoweredCycleBegin() {
    }

    @Override
    public void onPoweredCycleEnd() {
        if (this._inventories[1] != null) {
            if (this.consumeInputs()) {
                ++this._inventories[1].field_77994_a;
            }
        } else {
            ArrayList candidates = OreDictionaryArbiter.getOres((String)"ingotBlutonium");
            if (candidates == null || candidates.isEmpty()) {
                return;
            }
            if (this.consumeInputs()) {
                this._inventories[1] = ((ItemStack)candidates.get(0)).func_77946_l();
                this._inventories[1].field_77994_a = 1;
            }
        }
        this.distributeItemsFromSlot(1);
        this.markChunkDirty();
    }

    private boolean consumeInputs() {
        this._inventories[0] = StaticUtils.Inventory.consumeItem(this._inventories[0], 2);
        this.drain(0, 1000, true);
        return true;
    }

    @Override
    public int getNumTanks() {
        return 1;
    }

    @Override
    public int getTankSize(int tankIndex) {
        return 5000;
    }

    @Override
    protected boolean isFluidValidForTank(int tankIdx, FluidStack type) {
        if (type == null) {
            return false;
        }
        return type.getFluid().getID() == FluidRegistry.getFluid((String)"water").getID();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(EntityPlayer player) {
        return new GuiCyaniteReprocessor(this.getContainer(player), this);
    }

    @Override
    public Container getContainer(EntityPlayer player) {
        return new ContainerCyaniteReprocessor(this, player);
    }

    @Override
    protected int getDefaultTankForFluid(Fluid fluid) {
        if (fluid.getName() == "water") {
            return 0;
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconForSide(int side) {
        if (side == this.facing) {
            return this.func_145838_q().func_149691_a(side, this.func_145832_p());
        }
        int exposure = this.getExposure(side);
        switch (exposure) {
            case 0: {
                return ClientProxy.CommonBlockIcons.getIcon(2);
            }
            case 1: {
                return ClientProxy.CommonBlockIcons.getIcon(3);
            }
            case 2: {
                return ClientProxy.CommonBlockIcons.getIcon(4);
            }
        }
        return ClientProxy.CommonBlockIcons.getIcon(0);
    }

    public int getNumConfig(int side) {
        if (this.facing == side) {
            return 0;
        }
        return 3;
    }

    @Override
    public int getExposedTankFromSide(int side) {
        int exposure = this.getExposure(side);
        if (exposure == 2) {
            return 0;
        }
        return -1;
    }

    @Override
    protected int getExposedInventorySlotFromSide(int side) {
        int exposure = this.getExposure(side);
        if (exposure == 0) {
            return 0;
        }
        if (exposure == 1) {
            return 1;
        }
        return -1;
    }
}

