/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityExchangerPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityExchangerFluidPort
extends TileEntityExchangerPart
implements IFluidHandler,
INeighborUpdatableEntity,
ITickableMultiblockPart {
    private static final PortDirection[] s_PortDirections = PortDirection.values();
    private IFluidHandler m_PumpDestination;
    private PortDirection m_PortDirection = PortDirection.PrimaryInlet;

    private boolean isInlet() {
        return this.m_PortDirection == PortDirection.PrimaryInlet || this.m_PortDirection == PortDirection.SecondaryInlet;
    }

    private boolean isOutlet() {
        return this.m_PortDirection == PortDirection.PrimaryOutlet || this.m_PortDirection == PortDirection.SecondaryOutlet;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74768_a("direction", this.m_PortDirection.ordinal());
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("direction")) {
            this.setPortDirection(s_PortDirections[packetData.func_74762_e("direction")], false);
        }
    }

    public PortDirection getPortDirection() {
        return this.m_PortDirection;
    }

    public void setPortDirection(PortDirection newDirection, boolean markDirty) {
        if (newDirection == this.m_PortDirection) {
            return;
        }
        this.m_PortDirection = newDirection;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isInlet()) {
                this.checkForAdjacentTank();
            } else {
                this.m_PortDirection = null;
            }
            if (markDirty) {
                this.func_70296_d();
            } else {
                this.notifyNeighborsOfTileChange();
            }
        } else {
            this.notifyNeighborsOfTileChange();
        }
    }

    private void checkForAdjacentTank() {
        this.m_PumpDestination = null;
        if (this.field_145850_b.field_72995_K || this.isInlet()) {
            return;
        }
        ForgeDirection outDir = this.getOutwardsDir();
        if (outDir == ForgeDirection.UNKNOWN) {
            return;
        }
        TileEntity neighbor = this.field_145850_b.func_147438_o(this.field_145851_c + outDir.offsetX, this.field_145848_d + outDir.offsetY, this.field_145849_e + outDir.offsetZ);
        if (neighbor instanceof IFluidHandler) {
            this.m_PumpDestination = (IFluidHandler)neighbor;
        }
    }

    @Override
    public void onMultiblockServerTick() {
        if (!this.isOutlet() || this.m_PumpDestination != null) {
            // empty if block
        }
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForAdjacentTank();
        this.notifyNeighborsOfTileChange();
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.m_PumpDestination = null;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        this.checkForAdjacentTank();
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        this.checkForAdjacentTank();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public static enum PortDirection {
        PrimaryInlet,
        PrimaryOutlet,
        SecondaryInlet,
        SecondaryOutlet;

    }
}

