/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockHeatExchanger;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityExchangerComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityExchangerFluidPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityExchangerPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityExchangerPartBase;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class BlockExchangerPart
extends BlockContainer
implements IPeripheralProvider {
    public static final int METADATA_CASING = 0;
    public static final int METADATA_CONTROLLER = 1;
    public static final int METADATA_FLUIDPORT = 2;
    public static final int METADATA_COMPUTERPORT = 3;
    private static final int CONTROLLER_OFF = 0;
    private static final int CONTROLLER_IDLE = 1;
    private static final int CONTROLLER_ACTIVE = 2;
    private static final int FLUIDPORT_PRIM_INLET = 0;
    private static final int FLUIDPORT_PRIM_OUTLET = 1;
    private static final int FLUIDPORT_SEC_INLET = 2;
    private static final int FLUIDPORT_SEC_OUTLET = 3;
    private static final String[] _subBlocks = new String[]{"casing", "controller", "fluidPort", "computerPort"};
    private static String[][] _states = new String[][]{{"default", "face", "corner", "eastwest", "northsouth", "vertical"}, {"off", "idle", "active"}, {"primaryInlet", "primaryOutlet", "secondaryInlet", "secondaryOutlet"}, {"default"}};
    private IIcon[][] _icons = new IIcon[_states.length][];

    public static final boolean isCasing(int metadata) {
        return metadata == 0;
    }

    public static final boolean isController(int metadata) {
        return metadata == 1;
    }

    public static final boolean isFluidPort(int metadata) {
        return metadata == 2;
    }

    public static final boolean isComputerPort(int metadata) {
        return metadata == 3;
    }

    public BlockExchangerPart(Material material) {
        super(material);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(2.0f);
        this.func_149663_c("blockExchangerPart");
        this.func_149658_d("bigreactors:blockExchangerPart");
        this.func_149647_a(BigReactors.TAB);
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        IIcon icon = null;
        int metadata = blockAccess.func_72805_g(x, y, z);
        switch (metadata) {
            case 0: {
                icon = this.getCasingIcon(blockAccess, x, y, z, side);
                break;
            }
            case 1: {
                icon = this.getControllerIcon(blockAccess, x, y, z, side);
                break;
            }
            case 2: {
                icon = this.getFluidPortIcon(blockAccess, x, y, z, side);
                break;
            }
            case 3: {
                icon = this.getFaceOrBlockIcon(blockAccess, x, y, z, side, metadata);
            }
        }
        return icon != null ? icon : this.func_149691_a(side, metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side > 1 && metadata >= 0 && metadata < this._icons.length) {
            return this._icons[metadata][0];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        String prefix = "bigreactors:" + this.func_149739_a() + ".";
        for (int metadata = 0; metadata < _states.length; ++metadata) {
            String[] blockStates = _states[metadata];
            this._icons[metadata] = new IIcon[blockStates.length];
            for (int state = 0; state < blockStates.length; ++state) {
                this._icons[metadata][state] = par1IconRegister.func_94245_a(prefix + _subBlocks[metadata] + "." + blockStates[state]);
            }
        }
        this.field_149761_L = this._icons[0][0];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 3: {
                return new TileEntityExchangerComputerPort();
            }
            case 2: {
                return new TileEntityExchangerFluidPort();
            }
        }
        return new TileEntityExchangerPart();
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, x, y, z, neighborBlock);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, x, y, z, neighborX, neighborY, neighborZ);
        }
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int metadata = 0; metadata < _subBlocks.length; ++metadata) {
            par3List.add(new ItemStack((Block)this, 1, metadata));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int amountToDrop = world.field_73012_v.nextInt(21) + 10;
                    if (amountToDrop > itemstack.field_77994_a) {
                        amountToDrop = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= amountToDrop;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), amountToDrop, itemstack.func_77960_j()));
                    if (itemstack.func_77978_p() != null) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p());
                    }
                    float motionMultiplier = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityExchangerComputerPort) {
            return (IPeripheral)te;
        }
        return null;
    }

    private IIcon getFluidPortIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityExchangerFluidPort port;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityExchangerFluidPort && (!this.isAssembled(port = (TileEntityExchangerFluidPort)te) || this.isOutwardsSide(port, side))) {
            switch (port.getPortDirection()) {
                case PrimaryInlet: {
                    return this._icons[2][0];
                }
                case PrimaryOutlet: {
                    return this._icons[2][1];
                }
                case SecondaryInlet: {
                    return this._icons[2][2];
                }
                case SecondaryOutlet: {
                    return this._icons[2][3];
                }
            }
            return this.field_149761_L;
        }
        return this.field_149761_L;
    }

    private IIcon getControllerIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityExchangerPartBase) {
            TileEntityExchangerPartBase part = (TileEntityExchangerPartBase)te;
            MultiblockHeatExchanger exchanger = part.getExchangerController();
            if (exchanger == null || !exchanger.isAssembled()) {
                return this._icons[1][0];
            }
            if (exchanger.getActive()) {
                return this._icons[1][2];
            }
            return this._icons[1][1];
        }
        return this.field_149761_L;
    }

    private IIcon getFaceOrBlockIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int metadata) {
        TileEntityExchangerPartBase part;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityExchangerPartBase && (!this.isAssembled(part = (TileEntityExchangerPartBase)te) || this.isOutwardsSide(part, side))) {
            return this._icons[metadata][0];
        }
        return this.field_149761_L;
    }

    private IIcon getCasingIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.field_149761_L;
    }

    private boolean isOutwardsSide(TileEntityExchangerPartBase part, int side) {
        ForgeDirection outDir = part.getOutwardsDir();
        return outDir.ordinal() == side;
    }

    private boolean isAssembled(TileEntityExchangerPartBase part) {
        MultiblockControllerBase exchanger = part.getMultiblockController();
        return exchanger != null && exchanger.isAssembled();
    }

    public ItemStack getItemStack(String name) {
        for (int i = 0; i < _subBlocks.length; ++i) {
            if (!_subBlocks[i].equals(name)) continue;
            return new ItemStack((Block)this, 1, i);
        }
        throw new IllegalArgumentException("Unable to find Heat Exchanger part with name " + name);
    }
}

