/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.util.NBTJsonUtil;

public class ServerCloneController {
    public static ServerCloneController Instance;

    public ServerCloneController() {
        this.loadClones();
    }

    private void loadClones() {
        try {
            File e = new File(CustomNpcs.getWorldSaveDirectory(), "clonednpcs.dat");
            if (e.exists()) {
                Map clones = this.loadOldClones(e);
                e.delete();
                e = new File(CustomNpcs.getWorldSaveDirectory(), "clonednpcs.dat_old");
                if (e.exists()) {
                    e.delete();
                }
                Iterator var3 = clones.keySet().iterator();
                while (var3.hasNext()) {
                    int tab = (Integer)var3.next();
                    Map map = (Map)clones.get(tab);
                    for (String name : map.keySet()) {
                        this.saveClone(tab, name, (NBTTagCompound)map.get(name));
                    }
                }
            }
        }
        catch (Exception var8) {
            LogWriter.except(var8);
        }
    }

    public File getDir() {
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "clones");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private Map loadOldClones(File file) throws Exception {
        HashMap clones = new HashMap();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        if (list == null) {
            return clones;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            HashMap tab;
            NBTTagCompound compound = list.func_150305_b(i);
            if (!compound.func_74764_b("ClonedTab")) {
                compound.func_74768_a("ClonedTab", 1);
            }
            if ((tab = (HashMap)clones.get(compound.func_74762_e("ClonedTab"))) == null) {
                tab = new HashMap();
                clones.put(compound.func_74762_e("ClonedTab"), tab);
            }
            String name = compound.func_74779_i("ClonedName");
            int number = 1;
            while (tab.containsKey(name)) {
                name = String.format("%s%s", compound.func_74779_i("ClonedName"), ++number);
            }
            compound.func_82580_o("ClonedName");
            compound.func_82580_o("ClonedTab");
            compound.func_82580_o("ClonedDate");
            this.cleanTags(compound);
            ((Map)tab).put(name, compound);
        }
        return clones;
    }

    public NBTTagCompound getCloneData(ICommandSender player, String name, int tab) {
        File file = new File(new File(this.getDir(), tab + ""), name + ".json");
        if (!file.exists()) {
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Could not find clone file"));
            }
            return null;
        }
        try {
            return NBTJsonUtil.LoadFile(file);
        }
        catch (Exception var6) {
            LogWriter.except(var6);
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(var6.getMessage()));
            }
            return null;
        }
    }

    public void saveClone(int tab, String name, NBTTagCompound compound) {
        try {
            File e = new File(this.getDir(), tab + "");
            if (!e.exists()) {
                e.mkdir();
            }
            String filename = name + ".json";
            File file = new File(e, filename + "_new");
            File file2 = new File(e, filename);
            NBTJsonUtil.SaveFile(file, compound);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (Exception var8) {
            LogWriter.except(var8);
        }
    }

    public List getClones(int tab) {
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(this.getDir(), tab + "");
        if (dir.exists() && dir.isDirectory()) {
            for (String file : dir.list()) {
                if (!file.endsWith(".json")) continue;
                list.add(file.substring(0, file.length() - 5));
            }
            return list;
        }
        return list;
    }

    public boolean removeClone(String name, int tab) {
        File file = new File(new File(this.getDir(), tab + ""), name + ".json");
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    public String addClone(NBTTagCompound nbttagcompound, String name, int tab) {
        this.cleanTags(nbttagcompound);
        this.saveClone(tab, name, nbttagcompound);
        return name;
    }

    public void cleanTags(NBTTagCompound nbttagcompound) {
        NBTTagCompound adv;
        if (nbttagcompound.func_74764_b("ItemGiverId")) {
            nbttagcompound.func_74768_a("ItemGiverId", 0);
        }
        if (nbttagcompound.func_74764_b("TransporterId")) {
            nbttagcompound.func_74768_a("TransporterId", -1);
        }
        nbttagcompound.func_82580_o("StartPosNew");
        nbttagcompound.func_82580_o("StartPos");
        nbttagcompound.func_82580_o("MovingPathNew");
        nbttagcompound.func_82580_o("Pos");
        nbttagcompound.func_82580_o("Riding");
        if (!nbttagcompound.func_74764_b("ModRev")) {
            nbttagcompound.func_74768_a("ModRev", 1);
        }
        if (nbttagcompound.func_74764_b("TransformRole")) {
            adv = nbttagcompound.func_74775_l("TransformRole");
            adv.func_74768_a("TransporterId", -1);
            nbttagcompound.func_74782_a("TransformRole", (NBTBase)adv);
        }
        if (nbttagcompound.func_74764_b("TransformJob")) {
            adv = nbttagcompound.func_74775_l("TransformJob");
            adv.func_74768_a("ItemGiverId", 0);
            nbttagcompound.func_74782_a("TransformJob", (NBTBase)adv);
        }
        if (nbttagcompound.func_74764_b("TransformAI")) {
            adv = nbttagcompound.func_74775_l("TransformAI");
            adv.func_82580_o("StartPosNew");
            adv.func_82580_o("StartPos");
            adv.func_82580_o("MovingPathNew");
            nbttagcompound.func_74782_a("TransformAI", (NBTBase)adv);
        }
    }
}

