/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.util.NBTJsonUtil;

public class QuestController {
    public HashMap categories = new HashMap();
    public HashMap quests = new HashMap();
    public static QuestController instance;
    private int lastUsedCatID = 0;
    private int lastUsedQuestID = 0;

    public QuestController() {
        instance = this;
    }

    public void load() {
        File dir;
        this.categories.clear();
        this.quests.clear();
        this.lastUsedCatID = 0;
        this.lastUsedQuestID = 0;
        try {
            dir = new File(CustomNpcs.getWorldSaveDirectory(), "quests.dat");
            if (dir.exists()) {
                this.loadCategoriesOld(dir);
                dir.delete();
                dir = new File(CustomNpcs.getWorldSaveDirectory(), "quests.dat_old");
                if (dir.exists()) {
                    dir.delete();
                }
                return;
            }
        }
        catch (Exception var10) {
            // empty catch block
        }
        dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            for (File file : dir.listFiles()) {
                if (!file.isDirectory()) continue;
                QuestCategory category = this.loadCategoryDir(file);
                Iterator ite = category.quests.keySet().iterator();
                while (ite.hasNext()) {
                    int id = (Integer)ite.next();
                    if (id > this.lastUsedQuestID) {
                        this.lastUsedQuestID = id;
                    }
                    Quest quest = (Quest)category.quests.get(id);
                    if (this.quests.containsKey(id)) {
                        LogWriter.error("Duplicate id " + quest.id + " from category " + category.title);
                        ite.remove();
                        continue;
                    }
                    this.quests.put(id, quest);
                }
                category.id = ++this.lastUsedCatID;
                this.categories.put(category.id, category);
            }
        }
    }

    private QuestCategory loadCategoryDir(File dir) {
        QuestCategory category = new QuestCategory();
        category.title = dir.getName();
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            try {
                Quest e = new Quest();
                e.id = Integer.parseInt(file.getName().substring(0, file.getName().length() - 5));
                e.readNBTPartial(NBTJsonUtil.LoadFile(file));
                category.quests.put(e.id, e);
                e.category = category;
            }
            catch (Exception var8) {
                // empty catch block
            }
        }
        return category;
    }

    private void loadCategoriesOld(File file) throws Exception {
        HashMap<Integer, QuestCategory> categories = new HashMap<Integer, QuestCategory>();
        HashMap quests = new HashMap();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        this.lastUsedCatID = nbttagcompound1.func_74762_e("lastID");
        this.lastUsedQuestID = nbttagcompound1.func_74762_e("lastQuestID");
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                QuestCategory category = new QuestCategory();
                category.readNBT(list.func_150305_b(i));
                categories.put(category.id, category);
                Iterator ita = category.quests.entrySet().iterator();
                while (ita.hasNext()) {
                    Map.Entry entry = ita.next();
                    if (quests.containsKey(((Quest)entry.getValue()).id)) {
                        ita.remove();
                        continue;
                    }
                    quests.put(((Quest)entry.getValue()).id, entry.getValue());
                }
            }
        }
        this.quests = quests;
        this.categories = categories;
    }

    public void removeCategory(int category) {
        File dir;
        QuestCategory cat = (QuestCategory)this.categories.get(category);
        if (cat != null && (dir = new File(this.getDir(), cat.title)).delete()) {
            Iterator var4 = cat.quests.keySet().iterator();
            while (var4.hasNext()) {
                int dia = (Integer)var4.next();
                this.quests.remove(dia);
            }
            this.categories.remove(category);
        }
    }

    public void saveCategory(QuestCategory category) {
        if (this.categories.containsKey(category.id)) {
            QuestCategory dir = (QuestCategory)this.categories.get(category.id);
            if (!dir.title.equals(category.title)) {
                while (this.containsCategoryName(category.title)) {
                    category.title = category.title + "_";
                }
                File newdir = new File(this.getDir(), category.title);
                File olddir = new File(this.getDir(), dir.title);
                if (newdir.exists()) {
                    return;
                }
                if (!olddir.renameTo(newdir)) {
                    return;
                }
            }
            category.quests = dir.quests;
        } else {
            if (category.id < 0) {
                ++this.lastUsedCatID;
                category.id = this.lastUsedCatID;
            }
            while (this.containsCategoryName(category.title)) {
                category.title = category.title + "_";
            }
            File dir1 = new File(this.getDir(), category.title);
            if (!dir1.exists()) {
                dir1.mkdirs();
            }
        }
        this.categories.put(category.id, category);
    }

    private boolean containsCategoryName(String name) {
        QuestCategory cat;
        name = name.toLowerCase();
        Iterator var2 = this.categories.values().iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            cat = (QuestCategory)var2.next();
        } while (!cat.title.toLowerCase().equals(name));
        return true;
    }

    private boolean containsQuestName(QuestCategory category, Quest quest) {
        Quest q;
        Iterator var3 = category.quests.values().iterator();
        do {
            if (!var3.hasNext()) {
                return false;
            }
            q = (Quest)var3.next();
        } while (q.id == quest.id || !q.title.equalsIgnoreCase(quest.title));
        return true;
    }

    public void saveQuest(int categoryID, Quest quest) {
        QuestCategory category = (QuestCategory)this.categories.get(categoryID);
        if (category != null) {
            quest.category = category;
            while (this.containsQuestName(quest.category, quest)) {
                quest.title = quest.title + "_";
            }
            if (quest.id < 0) {
                ++this.lastUsedQuestID;
                quest.id = this.lastUsedQuestID;
            }
            this.quests.put(quest.id, quest);
            category.quests.put(quest.id, quest);
            File dir = new File(this.getDir(), category.title);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, quest.id + ".json_new");
            File file2 = new File(dir, quest.id + ".json");
            try {
                NBTJsonUtil.SaveFile(file, quest.writeToNBTPartial(new NBTTagCompound()));
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
            }
            catch (Exception var8) {
                var8.printStackTrace();
            }
        }
    }

    public void removeQuest(Quest quest) {
        File file = new File(new File(this.getDir(), quest.category.title), quest.id + ".json");
        if (file.delete()) {
            this.quests.remove(quest.id);
            quest.category.quests.remove(quest.id);
        }
    }

    private File getDir() {
        return new File(CustomNpcs.getWorldSaveDirectory(), "quests");
    }
}

