/*
 * Decompiled with CFR 0.152.
 */
package foxz.utils;

import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.util.NBTJsonUtil;

public class Market {
    public static void save(RoleTrader r, String name) {
        if (!name.isEmpty()) {
            File file = Market.getFile(name + "_new");
            File file1 = Market.getFile(name);
            try {
                NBTJsonUtil.SaveFile(file, r.writeToNBT(new NBTTagCompound()));
                if (file1.exists()) {
                    file1.delete();
                }
                file.renameTo(file1);
            }
            catch (Exception var5) {
                // empty catch block
            }
        }
    }

    public static void load(RoleTrader role, String name) {
        File file;
        if (!role.npc.field_70170_p.field_72995_K && (file = Market.getFile(name)).exists()) {
            try {
                role.readFromNBT(NBTJsonUtil.LoadFile(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static File getFile(String name) {
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "markets");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return new File(dir, name.toLowerCase() + ".json");
    }

    public static void setMarket(EntityNPCInterface npc, String marketName) {
        if (!marketName.isEmpty()) {
            if (!Market.getFile(marketName).exists()) {
                Market.save((RoleTrader)npc.roleInterface, marketName);
            }
            Market.load((RoleTrader)npc.roleInterface, marketName);
        }
    }
}

