/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import java.util.ArrayList;
import java.util.Iterator;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.Utils;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.LocalizedChat;
import mcp.mobius.betterbarrels.common.blocks.StorageLocal;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.ItemBarrelHammer;
import mcp.mobius.betterbarrels.common.items.upgrades.StructuralLevel;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import mcp.mobius.betterbarrels.network.BarrelPacketHandler;
import mcp.mobius.betterbarrels.network.Message0x04Structuralupdate;
import mcp.mobius.betterbarrels.network.Message0x05CoreUpdate;
import mcp.mobius.betterbarrels.network.Message0x06FullStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BarrelCoreUpgrades {
    private TileEntityBarrel barrel;
    public ArrayList<UpgradeCore> upgradeList = new ArrayList();
    public int levelStructural = 0;
    public int nStorageUpg = 0;
    public boolean hasRedstone = false;
    public boolean hasHopper = false;
    public boolean hasEnder = false;
    public boolean hasVoid = false;
    public boolean hasCreative = false;

    public BarrelCoreUpgrades(TileEntityBarrel barrel) {
        this.barrel = barrel;
    }

    public int getMaxUpgradeSlots() {
        return StructuralLevel.LEVELS[this.levelStructural].getMaxCoreSlots();
    }

    public int getUsedSlots() {
        int nslots = 0;
        for (UpgradeCore core : this.upgradeList) {
            nslots += core.slotsUsed;
        }
        return nslots;
    }

    public int getFreeSlots() {
        return this.getMaxUpgradeSlots() - this.getUsedSlots();
    }

    public boolean hasUpgrade(UpgradeCore upgrade) {
        for (UpgradeCore core : this.upgradeList) {
            if (core != upgrade) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgradeType(UpgradeCore.Type upgradeType) {
        for (UpgradeCore core : this.upgradeList) {
            if (core.type != upgradeType) continue;
            return true;
        }
        return false;
    }

    private int findUpgradeIndex(UpgradeCore.Type type, Boolean first, Boolean exclude) {
        if (first.booleanValue()) {
            for (int i = 0; i < this.upgradeList.size(); ++i) {
                if (!(exclude != false ? this.upgradeList.get((int)i).type != type : this.upgradeList.get((int)i).type == type)) continue;
                return i;
            }
        } else {
            for (int i = this.upgradeList.size() - 1; i >= 0; --i) {
                if (!(exclude != false ? this.upgradeList.get((int)i).type != type : this.upgradeList.get((int)i).type == type)) continue;
                return i;
            }
        }
        return -1;
    }

    private void createAndDropItem(Item item, int meta, EntityPlayer player) {
        ItemStack droppedStack = new ItemStack(item, 1, meta);
        Utils.dropItemInWorld(this.barrel, player, droppedStack, 0.02);
    }

    private void removeAndDropUpgrade(UpgradeCore upgrade, EntityPlayer player) {
        int coreIndex = this.findUpgradeIndex(upgrade.type, true, false);
        if (coreIndex >= 0) {
            this.upgradeList.remove(coreIndex);
            this.createAndDropItem(BetterBarrels.itemUpgradeCore, upgrade.ordinal(), player);
        }
    }

    private void removeEnder(EntityPlayer player) {
        if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_REMOVE, new Integer[0]);
            this.barrel.storage = new StorageLocal(this.nStorageUpg);
        }
        BSpaceStorageHandler.instance().unregisterEnderBarrel(this.barrel.id);
    }

    private void removeStorage(EntityPlayer player) {
        int indexLastUpdate = this.findUpgradeIndex(UpgradeCore.Type.STORAGE, false, false);
        if (indexLastUpdate == -1) {
            return;
        }
        UpgradeCore core = this.upgradeList.get(indexLastUpdate);
        if (this.barrel.getStorage().getItem() != null) {
            int newMaxStoredItems = (this.barrel.getStorage().getMaxStacks() - 64 * core.slotsUsed) * this.barrel.getStorage().getItem().func_77976_d();
            if (this.barrel.getStorage().getAmount() > newMaxStoredItems) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.STACK_REMOVE, new Integer[0]);
                return;
            }
        }
        this.upgradeList.remove(indexLastUpdate);
        this.createAndDropItem(BetterBarrels.itemUpgradeCore, core.ordinal(), player);
        for (int i = 0; i < core.slotsUsed; ++i) {
            this.barrel.getStorage().rmStorageUpgrade();
        }
        this.nStorageUpg -= core.slotsUsed;
    }

    public void removeUpgrade(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        switch (ItemBarrelHammer.HammerMode.getMode(stack)) {
            default: {
                int indexLastUpdate = this.findUpgradeIndex(UpgradeCore.Type.STORAGE, false, true);
                if (indexLastUpdate != -1) {
                    UpgradeCore core = this.upgradeList.get(indexLastUpdate);
                    if (core.type == UpgradeCore.Type.VOID && BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                        return;
                    }
                    this.upgradeList.remove(indexLastUpdate);
                    this.createAndDropItem(BetterBarrels.itemUpgradeCore, core.ordinal(), player);
                    this.hasRedstone = this.hasUpgrade(UpgradeCore.REDSTONE);
                    this.hasHopper = this.hasUpgrade(UpgradeCore.HOPPER);
                    this.hasEnder = this.hasUpgrade(UpgradeCore.ENDER);
                    this.barrel.setVoid(this.hasUpgrade(UpgradeCore.VOID));
                    this.barrel.setCreative(this.hasUpgrade(UpgradeCore.CREATIVE));
                    if (core.type == UpgradeCore.Type.ENDER) {
                        this.removeEnder(player);
                    }
                    if (this.hasHopper) {
                        this.barrel.startTicking();
                    } else {
                        this.barrel.stopTicking();
                    }
                    this.barrel.removeUpgradeFacades(player);
                    break;
                }
                if (this.upgradeList.size() > 0) {
                    this.removeStorage(player);
                    break;
                }
                if (this.levelStructural > 0) {
                    this.createAndDropItem(BetterBarrels.itemUpgradeStructural, this.levelStructural - 1, player);
                    --this.levelStructural;
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case REDSTONE: {
                if (this.hasUpgrade(UpgradeCore.REDSTONE)) {
                    this.removeAndDropUpgrade(UpgradeCore.REDSTONE, player);
                    this.hasRedstone = false;
                    this.barrel.removeUpgradeFacades(player);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case BSPACE: {
                if (this.hasUpgrade(UpgradeCore.ENDER)) {
                    this.removeAndDropUpgrade(UpgradeCore.ENDER, player);
                    this.hasEnder = false;
                    this.removeEnder(player);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case HOPPER: {
                if (this.hasUpgrade(UpgradeCore.HOPPER)) {
                    this.barrel.stopTicking();
                    this.removeAndDropUpgrade(UpgradeCore.HOPPER, player);
                    this.hasHopper = false;
                    this.barrel.removeUpgradeFacades(player);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case STORAGE: {
                if (this.hasUpgradeType(UpgradeCore.Type.STORAGE)) {
                    if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                        break;
                    }
                    this.removeStorage(player);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case STRUCTURAL: {
                if (this.levelStructural > 0) {
                    if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                        break;
                    }
                    int newLevel = this.levelStructural - 1;
                    int newTotalSlots = 0;
                    for (int i = 0; i < newLevel; ++i) {
                        newTotalSlots += MathHelper.func_76128_c((double)Math.pow(2.0, i));
                    }
                    if (newTotalSlots < this.getUsedSlots()) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.UPGRADE_REMOVE, new Integer[0]);
                        break;
                    }
                    this.createAndDropItem(BetterBarrels.itemUpgradeStructural, this.levelStructural - 1, player);
                    this.levelStructural = newLevel;
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case VOID: {
                if (this.hasUpgrade(UpgradeCore.VOID)) {
                    if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                        break;
                    }
                    this.removeAndDropUpgrade(UpgradeCore.VOID, player);
                    this.barrel.setVoid(false);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
                break;
            }
            case CREATIVE: {
                if (this.hasUpgrade(UpgradeCore.CREATIVE)) {
                    if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                        break;
                    }
                    this.removeAndDropUpgrade(UpgradeCore.CREATIVE, player);
                    this.barrel.setCreative(false);
                    break;
                }
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BONK, new Integer[0]);
            }
        }
    }

    void applyUpgrade(ItemStack stack, EntityPlayer player) {
        UpgradeCore core = UpgradeCore.values()[stack.func_77960_j()];
        if (core.type != UpgradeCore.Type.STORAGE && this.hasUpgrade(core)) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.COREUPGRADE_EXISTS, new Integer[0]);
            return;
        }
        if (core.slotsUsed > this.getFreeSlots()) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.UPGRADE_INSUFFICIENT, core.slotsUsed);
            return;
        }
        if (core.type == UpgradeCore.Type.STORAGE) {
            if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                return;
            }
            this.upgradeList.add(core);
            for (int i = 0; i < core.slotsUsed; ++i) {
                this.barrel.getStorage().addStorageUpgrade();
            }
            this.nStorageUpg += core.slotsUsed;
            BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x06FullStorage(this.barrel), this.barrel.func_145831_w().field_73011_w.field_76574_g);
        }
        if (core == UpgradeCore.REDSTONE) {
            this.upgradeList.add(UpgradeCore.REDSTONE);
            this.hasRedstone = true;
        } else if (core == UpgradeCore.HOPPER) {
            this.upgradeList.add(UpgradeCore.HOPPER);
            this.hasHopper = true;
            this.barrel.startTicking();
        } else if (core == UpgradeCore.ENDER) {
            this.upgradeList.add(UpgradeCore.ENDER);
            this.hasEnder = true;
            BSpaceStorageHandler.instance().registerEnderBarrel(this.barrel.id, this.barrel.storage);
        } else if (core == UpgradeCore.VOID) {
            if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                return;
            }
            this.upgradeList.add(UpgradeCore.VOID);
            this.barrel.setVoid(true);
        } else if (core == UpgradeCore.CREATIVE) {
            if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
                return;
            }
            this.upgradeList.add(UpgradeCore.CREATIVE);
            this.barrel.setCreative(true);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        this.barrel.func_70296_d();
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x05CoreUpdate(this.barrel), this.barrel.func_145831_w().field_73011_w.field_76574_g);
    }

    void applyStructural(ItemStack stack, EntityPlayer player) {
        if (BSpaceStorageHandler.instance().hasLinks(this.barrel.id)) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_PREVENT, new Integer[0]);
            return;
        }
        if (stack.func_77960_j() == this.levelStructural) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            ++this.levelStructural;
        } else if (player instanceof EntityPlayerMP && stack.func_77960_j() == this.levelStructural - 1) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.UPGRADE_EXISTS, new Integer[0]);
        } else if (player instanceof EntityPlayerMP && stack.func_77960_j() < this.levelStructural) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.DOWNGRADE, new Integer[0]);
        } else if (player instanceof EntityPlayerMP && stack.func_77960_j() > this.levelStructural) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.UPGRADE_REQUIRED, stack.func_77960_j());
        }
        this.barrel.func_70296_d();
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x04Structuralupdate(this.barrel), this.barrel.func_145831_w().field_73011_w.field_76574_g);
    }

    public void writeToNBT(NBTTagCompound NBTTag) {
        int[] savedUpgrades = new int[this.upgradeList.size()];
        Iterator<UpgradeCore> iterator = this.upgradeList.iterator();
        for (int i = 0; i < savedUpgrades.length; ++i) {
            savedUpgrades[i] = iterator.next().ordinal();
        }
        NBTTag.func_74783_a("coreUpgrades", savedUpgrades);
        NBTTag.func_74768_a("structural", this.levelStructural);
        NBTTag.func_74757_a("redstone", this.hasRedstone);
        NBTTag.func_74757_a("hopper", this.hasHopper);
        NBTTag.func_74757_a("ender", this.hasEnder);
        NBTTag.func_74757_a("void", this.hasVoid);
        NBTTag.func_74757_a("creative", this.hasCreative);
        NBTTag.func_74768_a("nStorageUpg", this.nStorageUpg);
    }

    public void readFromNBT(NBTTagCompound NBTTag, int saveVersion) {
        int[] savedUpgrades = NBTTag.func_74759_k("coreUpgrades");
        this.upgradeList = new ArrayList();
        for (int i = 0; i < savedUpgrades.length; ++i) {
            this.upgradeList.add(UpgradeCore.values()[savedUpgrades[i] + (saveVersion == 3 ? -1 : 0)]);
        }
        this.levelStructural = NBTTag.func_74762_e("structural");
        this.hasRedstone = NBTTag.func_74767_n("redstone");
        this.hasHopper = NBTTag.func_74767_n("hopper");
        this.hasEnder = NBTTag.func_74767_n("ender");
        this.nStorageUpg = saveVersion < 5 ? (int)NBTTag.func_74771_c("nStorageUpg") : NBTTag.func_74762_e("nStorageUpg");
        this.barrel.setVoid(NBTTag.func_74767_n("void"));
        this.barrel.setCreative(NBTTag.func_74767_n("creative"));
    }
}

