/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.bspace;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipException;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.ServerTickHandler;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.StorageLocal;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class BSpaceStorageHandler {
    private int version = 1;
    public static BSpaceStorageHandler _instance = new BSpaceStorageHandler();
    private HashMap<Integer, Coordinates> barrels = new HashMap();
    private HashMap<Integer, IBarrelStorage> storageMap = new HashMap();
    private HashMap<Integer, IBarrelStorage> storageMapOriginal = new HashMap();
    private HashMap<Integer, HashSet<Integer>> links = new HashMap();
    private int maxBarrelID = 0;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private NBTTagCompound saveTag;

    private BSpaceStorageHandler() {
    }

    public static BSpaceStorageHandler instance() {
        return _instance;
    }

    public int getNextBarrelID() {
        ++this.maxBarrelID;
        return this.maxBarrelID;
    }

    public void updateBarrel(int id, int dim, int x, int y, int z) {
        Coordinates coord = new Coordinates(dim, x, y, z);
        if (!coord.equals(this.barrels.get(id))) {
            this.barrels.put(id, coord);
            this.writeToFile();
        }
    }

    public void registerEnderBarrel(int id, IBarrelStorage storage) {
        this.storageMap.put(id, storage);
        this.storageMapOriginal.put(id, storage);
        this.writeToFile();
    }

    public IBarrelStorage unregisterEnderBarrel(int id) {
        IBarrelStorage storage = this.storageMapOriginal.get(id);
        this.storageMap.remove(id);
        this.storageMapOriginal.remove(id);
        this.unlinkStorage(id);
        this.writeToFile();
        return storage;
    }

    public IBarrelStorage getStorage(int id) {
        IBarrelStorage storage = this.storageMap.get(id);
        return storage;
    }

    public IBarrelStorage getStorageOriginal(int id) {
        return this.storageMapOriginal.get(id);
    }

    public TileEntityBarrel getBarrel(int id) {
        if (this.barrels.containsKey(id)) {
            Coordinates coord = this.barrels.get(id);
            WorldServer world = DimensionManager.getWorld((int)coord.dim);
            if (world == null) {
                return null;
            }
            TileEntity te = world.func_147438_o(MathHelper.func_76128_c((double)coord.x), MathHelper.func_76128_c((double)coord.y), MathHelper.func_76128_c((double)coord.z));
            if (!(te instanceof TileEntityBarrel)) {
                return null;
            }
            TileEntityBarrel barrel = (TileEntityBarrel)te;
            if (barrel.id != id) {
                return null;
            }
            return barrel;
        }
        return null;
    }

    public void linkStorages(int sourceID, int targetID) {
        this.unlinkStorage(targetID);
        this.storageMap.put(targetID, this.storageMap.get(sourceID));
        if (!this.links.containsKey(sourceID)) {
            this.links.put(sourceID, new HashSet());
        }
        this.links.put(targetID, new HashSet());
        for (HashSet<Integer> set : this.links.values()) {
            set.remove(targetID);
        }
        this.links.get(sourceID).add(targetID);
        HashSet<Integer> transferSet = new HashSet<Integer>();
        transferSet.add(sourceID);
        transferSet.add(targetID);
        transferSet.addAll((Collection)this.links.get(sourceID));
        for (Integer i : this.links.get(sourceID)) {
            this.links.get(i).clear();
            this.links.get(i).addAll(transferSet);
            this.links.get(i).remove(i);
            TileEntityBarrel barrel = this.getBarrel(i);
            if (barrel == null) continue;
            barrel.setLinked(true);
        }
        TileEntityBarrel source = this.getBarrel(sourceID);
        if (source != null) {
            source.setLinked(true);
        }
        this.cleanUpLinks();
        this.writeToFile();
    }

    private void cleanUpLinks() {
        HashSet<Integer> keys = new HashSet<Integer>(this.links.keySet());
        for (Integer i : keys) {
            if (this.links.get(i).size() != 0) continue;
            this.links.remove(i);
            TileEntityBarrel barrel = this.getBarrel(i);
            if (barrel == null) continue;
            barrel.setLinked(false);
        }
    }

    public IBarrelStorage unlinkStorage(int sourceID) {
        if (!this.links.containsKey(sourceID)) {
            return this.storageMapOriginal.get(sourceID);
        }
        HashSet copy = new HashSet(this.links.get(sourceID));
        for (Integer targetID : copy) {
            this.links.get(targetID).remove(sourceID);
        }
        this.links.remove(sourceID);
        TileEntityBarrel barrel = this.getBarrel(sourceID);
        if (barrel != null) {
            barrel.setLinked(false);
        }
        this.cleanUpLinks();
        this.writeToFile();
        return this.storageMapOriginal.get(sourceID);
    }

    private void relinkStorages() {
        for (Integer source : this.links.keySet()) {
            for (Integer target : this.links.get(source)) {
                this.storageMap.put(target, this.storageMap.get(source));
            }
        }
    }

    public boolean hasLinks(int sourceID) {
        return this.links.containsKey(sourceID);
    }

    public void updateAllBarrels(int sourceID) {
        if (!this.links.containsKey(sourceID)) {
            return;
        }
        TileEntityBarrel source = this.getBarrel(sourceID);
        if (source == null) {
            return;
        }
        boolean updateRequiredContent = source.sendContentSyncPacket(false);
        boolean updateRequiredGhost = source.sendGhostSyncPacket(false);
        for (Integer targetID : this.links.get(sourceID)) {
            TileEntityBarrel target = this.getBarrel(targetID);
            if (target == null) continue;
            target.getStorage().setGhosting(source.getStorage().isGhosting());
            target.sendContentSyncPacket(updateRequiredContent);
            target.sendGhostSyncPacket(updateRequiredGhost);
        }
    }

    public void markAllDirty(int sourceID) {
        if (!this.links.containsKey(sourceID)) {
            return;
        }
        TileEntityBarrel source = this.getBarrel(sourceID);
        if (source == null) {
            return;
        }
        for (Integer targetID : this.links.get(sourceID)) {
            TileEntityBarrel target = this.getBarrel(targetID);
            if (target == null) continue;
            ServerTickHandler.INSTANCE.markDirty(target, false);
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("version", this.version);
        nbt.func_74768_a("maxBarrelID", this.maxBarrelID);
        NBTTagCompound coords = new NBTTagCompound();
        for (Integer key : this.barrels.keySet()) {
            coords.func_74782_a(String.valueOf(key), (NBTBase)this.barrels.get(key).writeToNBT());
        }
        nbt.func_74782_a("barrelCoords", (NBTBase)coords);
        NBTTagCompound stores = new NBTTagCompound();
        for (Integer key : this.storageMap.keySet()) {
            stores.func_74782_a(String.valueOf(key), (NBTBase)this.storageMap.get(key).writeTagCompound());
        }
        nbt.func_74782_a("storages", (NBTBase)stores);
        NBTTagCompound storesOriginal = new NBTTagCompound();
        for (Integer key : this.storageMapOriginal.keySet()) {
            storesOriginal.func_74782_a(String.valueOf(key), (NBTBase)this.storageMapOriginal.get(key).writeTagCompound());
        }
        nbt.func_74782_a("storagesOriginal", (NBTBase)storesOriginal);
        NBTTagCompound list = new NBTTagCompound();
        for (Integer key : this.links.keySet()) {
            list.func_74783_a(String.valueOf(key), this.convertInts((Set<Integer>)this.links.get(key)));
        }
        nbt.func_74782_a("links", (NBTBase)list);
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tag;
        this.maxBarrelID = nbt.func_74764_b("maxBarrelID") ? nbt.func_74762_e("maxBarrelID") : 0;
        this.links = new HashMap();
        if (nbt.func_74764_b("barrelCoords")) {
            tag = nbt.func_74775_l("barrelCoords");
            for (Object key : tag.func_150296_c()) {
                this.barrels.put(Integer.valueOf((String)key), new Coordinates(tag.func_74775_l((String)key)));
            }
        }
        if (nbt.func_74764_b("storages")) {
            tag = nbt.func_74775_l("storages");
            for (Object key : tag.func_150296_c()) {
                this.storageMap.put(Integer.valueOf((String)key), new StorageLocal(tag.func_74775_l((String)key)));
            }
        }
        if (nbt.func_74764_b("storagesOriginal")) {
            tag = nbt.func_74775_l("storagesOriginal");
            for (Object key : tag.func_150296_c()) {
                this.storageMapOriginal.put(Integer.valueOf((String)key), new StorageLocal(tag.func_74775_l((String)key)));
            }
        }
        if (nbt.func_74764_b("links")) {
            tag = nbt.func_74775_l("links");
            for (Object key : tag.func_150296_c()) {
                this.links.put(Integer.valueOf((String)key), this.convertHashSet(tag.func_74759_k((String)key)));
            }
            this.relinkStorages();
        }
    }

    public void writeToFile() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        try {
            this.writeToNBT(this.saveTag);
            File saveFile = this.saveFiles[this.saveTo];
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)dout);
            dout.close();
            FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
            fout.write(this.saveTo);
            fout.close();
            this.saveTo ^= 1;
        }
        catch (Exception e) {
            System.out.printf("JABBA state directory missing. Skipping saving state. If you are in hardcore mode, this is a perfectly normal situation, otherwise, please report to my bugtracker.\n", new Object[0]);
        }
    }

    public void loadFromFile() {
        System.out.printf("Attemping to load JABBA data.\n", new Object[0]);
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "JABBA");
        try {
            boolean dataLoaded;
            block9: {
                if (!this.saveDir.exists()) {
                    this.saveDir.mkdirs();
                }
                this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
                dataLoaded = false;
                if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                    FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                    this.saveTo = fin.read() ^ 1;
                    fin.close();
                    try {
                        if (this.saveFiles[this.saveTo ^ 1].exists()) {
                            DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                            this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                            din.close();
                            dataLoaded = true;
                        }
                    }
                    catch (ZipException e) {
                        if (!this.saveFiles[this.saveTo].exists()) break block9;
                        DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo]));
                        this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                        din.close();
                        dataLoaded = true;
                    }
                }
            }
            if (!dataLoaded) {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            if (e instanceof ZipException) {
                BetterBarrels.log.log(Level.SEVERE, "Primary and Backup JABBA data files have been corrupted.");
            }
            throw new RuntimeException(e);
        }
        this.readFromNBT(this.saveTag);
    }

    private int[] convertInts(Set<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    private HashSet<Integer> convertHashSet(int[] list) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i = 0; i < list.length; ++i) {
            ret.add(list[i]);
        }
        return ret;
    }
}

