/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.PlateCutter")
@ModOnly(value={"gregtech"})
public class PlateCutter {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddRecipeAction(output, null, input, null, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int durationTicks, int euPerTick) {
        if (outputs.length == 0) {
            MineTweakerAPI.logError("cutter recipe must have at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs[0], outputs.length > 1 ? outputs[1] : null, input, null, durationTicks, euPerTick));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        if (outputs.length == 0) {
            MineTweakerAPI.logError("cutter recipe must have at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs[0], outputs.length > 1 ? outputs[1] : null, input, lubricant, durationTicks, euPerTick));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddRecipeAction(output, null, input, lubricant, durationTicks, euPerTick));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output1;
        private final IItemStack output2;
        private final ILiquidStack lubricant;
        private final IItemStack input;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output1, IItemStack output2, IItemStack input, ILiquidStack lubricant, int duration, int euPerTick) {
            this.output1 = output1;
            this.output2 = output2;
            this.lubricant = lubricant;
            this.input = input;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addCutterRecipe(MineTweakerMC.getItemStack(this.input), MineTweakerMC.getLiquidStack(this.lubricant), MineTweakerMC.getItemStack(this.output1), MineTweakerMC.getItemStack(this.output2), this.duration, this.euPerTick);
        }

        @Override
        public String describe() {
            return "Adding plate cutter recipe for " + this.output1;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.output1 != null ? this.output1.hashCode() : 0);
            hash = 17 * hash + (this.output2 != null ? this.output2.hashCode() : 0);
            hash = 17 * hash + (this.lubricant != null ? this.lubricant.hashCode() : 0);
            hash = 17 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 17 * hash + this.duration;
            hash = 17 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!(this.output1 == other.output1 || this.output1 != null && this.output1.equals(other.output1))) {
                return false;
            }
            if (!(this.output2 == other.output2 || this.output2 != null && this.output2.equals(other.output2))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

