/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.FusionReactor")
@ModOnly(value={"gregtech"})
public class FusionReactor {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2, int durationTicks, int energyPerTick, int startEnergy) {
        MineTweakerAPI.apply(new AddRecipeAction(output, input1, input2, durationTicks, energyPerTick, startEnergy));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input1;
        private final IItemStack input2;
        private final int durationTicks;
        private final int energyPerTick;
        private final int startEnergy;

        public AddRecipeAction(IItemStack output, IItemStack input1, IItemStack input2, int durationTicks, int energyPerTick, int startEnergy) {
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
            this.durationTicks = durationTicks;
            this.energyPerTick = energyPerTick;
            this.startEnergy = startEnergy;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addFusionReactorRecipe(MineTweakerMC.getItemStack(this.input1), MineTweakerMC.getItemStack(this.input2), MineTweakerMC.getItemStack(this.output), this.durationTicks, this.energyPerTick, this.startEnergy);
        }

        @Override
        public String describe() {
            return "Adding fusion reactor recipe for " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 97 * hash + (this.input1 != null ? this.input1.hashCode() : 0);
            hash = 97 * hash + (this.input2 != null ? this.input2.hashCode() : 0);
            hash = 97 * hash + this.durationTicks;
            hash = 97 * hash + this.energyPerTick;
            hash = 97 * hash + this.startEnergy;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input1 == other.input1 || this.input1 != null && this.input1.equals(other.input1))) {
                return false;
            }
            if (!(this.input2 == other.input2 || this.input2 != null && this.input2.equals(other.input2))) {
                return false;
            }
            if (this.durationTicks != other.durationTicks) {
                return false;
            }
            if (this.energyPerTick != other.energyPerTick) {
                return false;
            }
            return this.startEnergy == other.startEnergy;
        }
    }
}

