/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Canner")
@ModOnly(value={"gregtech"})
public class Canner {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddRecipeAction(output, null, input1, input2, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IItemStack input1, IItemStack input2, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError("canner requires at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(output[0], output.length > 1 ? output[1] : null, input1, input2, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output1;
        private final IItemStack output2;
        private final IItemStack input1;
        private final IItemStack input2;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output1, IItemStack output2, IItemStack input1, IItemStack input2, int duration, int euPerTick) {
            this.output1 = output1;
            this.output2 = output2;
            this.input1 = input1;
            this.input2 = input2;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addCannerRecipe(MineTweakerMC.getItemStack(this.input1), MineTweakerMC.getItemStack(this.input2), MineTweakerMC.getItemStack(this.output1), MineTweakerMC.getItemStack(this.output2), this.duration, this.euPerTick);
        }

        @Override
        public String describe() {
            return "Adding canner recipe for " + this.output1;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.output1 != null ? this.output1.hashCode() : 0);
            hash = 79 * hash + (this.output2 != null ? this.output2.hashCode() : 0);
            hash = 79 * hash + (this.input1 != null ? this.input1.hashCode() : 0);
            hash = 79 * hash + (this.input2 != null ? this.input2.hashCode() : 0);
            hash = 79 * hash + this.duration;
            hash = 79 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!(this.output1 == other.output1 || this.output1 != null && this.output1.equals(other.output1))) {
                return false;
            }
            if (!(this.output2 == other.output2 || this.output2 != null && this.output2.equals(other.output2))) {
                return false;
            }
            if (!(this.input1 == other.input1 || this.input1 != null && this.input1.equals(other.input1))) {
                return false;
            }
            if (!(this.input2 == other.input2 || this.input2 != null && this.input2.equals(other.input2))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

