/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.logging;

import com.khorn.terraincontrol.configuration.PluginConfig;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.List;
import org.apache.logging.log4j.Marker;

public class Logger {
    private org.apache.logging.log4j.Logger baseLogger;
    public static final String PLUGIN_NAME = "TerrainControl";
    private Marker logLevel = PluginConfig.LogLevels.Standard.getLevel();

    protected Logger(org.apache.logging.log4j.Logger logger) {
        this.baseLogger = logger;
    }

    public org.apache.logging.log4j.Logger getBaseLogger() {
        return this.baseLogger;
    }

    public void setLevel(Marker level) {
        this.logLevel = level;
    }

    public void log(Marker level, List<String> message) {
        this.log(level, "{}", StringHelper.join(message, " "));
    }

    public void log(Marker level, String message, Object ... params) {
        String levelName = level.getName();
        StringBuilder sb = new StringBuilder(50).append('[').append(PLUGIN_NAME).append("] [").append(levelName.substring(levelName.lastIndexOf(46) + 1)).append("] ").append(message);
        if (LogMarker.compare(this.logLevel, level) >= 0) {
            if (LogMarker.compare(LogMarker.FATAL, level) == 0) {
                this.baseLogger.fatal(sb.toString(), params);
            } else if (LogMarker.compare(LogMarker.ERROR, level) == 0) {
                this.baseLogger.error(sb.toString(), params);
            } else if (LogMarker.compare(LogMarker.WARN, level) == 0) {
                this.baseLogger.warn(sb.toString(), params);
            } else {
                this.baseLogger.info(level, sb.toString(), params);
            }
        }
    }

    public void logIfLevel(Marker ifLevel, List<String> messages) {
        if (LogMarker.compare(this.logLevel, ifLevel) == 0) {
            this.log(ifLevel, messages);
        }
    }

    public void logIfLevel(Marker ifLevel, String message, Object ... params) {
        if (LogMarker.compare(this.logLevel, ifLevel) == 0) {
            this.log(ifLevel, message, params);
        }
    }

    public void logIfLevel(Marker min, Marker max, List<String> messages) {
        if (LogMarker.compare(this.logLevel, max) <= 0 && LogMarker.compare(this.logLevel, min) >= 0) {
            this.log(max, messages);
        }
    }

    public void logIfLevel(Marker min, Marker max, String message, Object ... params) {
        if (LogMarker.compare(this.logLevel, max) <= 0 && LogMarker.compare(this.logLevel, min) >= 0) {
            this.log(max, message, params);
        }
    }
}

