/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.surface;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.generator.noise.NoiseGeneratorNewOctaves;
import com.khorn.terraincontrol.generator.surface.SurfaceGenerator;
import com.khorn.terraincontrol.util.helpers.MathHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.Arrays;
import java.util.Random;

public class MesaSurfaceGenerator
implements SurfaceGenerator {
    public static final String NAME_NORMAL = "Mesa";
    public static final String NAME_FOREST = "MesaForest";
    public static final String NAME_BRYCE = "MesaBryce";
    private byte[] blockDataValuesArray;
    private boolean isForestMesa;
    private boolean isBryceMesa;
    private NoiseGeneratorNewOctaves noiseGenBryce1;
    private NoiseGeneratorNewOctaves noiseGenBryce2;
    private NoiseGeneratorNewOctaves noiseGenBlockData;
    private Random random = new Random();
    private final LocalMaterialData hardenedClay;
    private final LocalMaterialData redSand;
    private final LocalMaterialData whiteStainedClay;
    private final LocalMaterialData orangeStainedClay;

    public static MesaSurfaceGenerator getFor(String settingValue) {
        if (NAME_NORMAL.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(false, false);
        }
        if (NAME_FOREST.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(false, true);
        }
        if (NAME_BRYCE.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(true, false);
        }
        return null;
    }

    public MesaSurfaceGenerator(boolean mountainMesa, boolean forestMesa) {
        this.isBryceMesa = mountainMesa;
        this.isForestMesa = forestMesa;
        this.hardenedClay = TerrainControl.toLocalMaterialData(DefaultMaterial.HARD_CLAY, 0);
        this.redSand = TerrainControl.toLocalMaterialData(DefaultMaterial.SAND, 1);
        this.whiteStainedClay = TerrainControl.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 0);
        this.orangeStainedClay = TerrainControl.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 1);
    }

    private byte getBlockData(int i, int j, int k) {
        int l = (int)Math.round(this.noiseGenBlockData.a((double)i * 1.0 / 512.0, (double)i * 1.0 / 512.0) * 2.0);
        return this.blockDataValuesArray[(j + l + 64) % 64];
    }

    private void initializeSmallByteArray(long worldSeed) {
        int j;
        int numberBelow64;
        int i;
        this.blockDataValuesArray = new byte[64];
        Arrays.fill(this.blockDataValuesArray, (byte)16);
        Random random = new Random(worldSeed);
        this.noiseGenBlockData = new NoiseGeneratorNewOctaves(random, 1);
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((i2 += random.nextInt(5) + 1) >= 64) continue;
            this.blockDataValuesArray[i2] = 1;
        }
        int maxValues = random.nextInt(4) + 2;
        for (int i3 = 0; i3 < maxValues; ++i3) {
            int oneTwoOrThree = random.nextInt(3) + 1;
            int numberBelow642 = random.nextInt(64);
            for (int j2 = 0; numberBelow642 + j2 < 64 && j2 < oneTwoOrThree; ++j2) {
                this.blockDataValuesArray[numberBelow642 + j2] = 4;
            }
        }
        int numberFromTwoToFive = random.nextInt(4) + 2;
        for (i = 0; i < numberFromTwoToFive; ++i) {
            int twoThreeOrFour = random.nextInt(3) + 2;
            numberBelow64 = random.nextInt(64);
            for (j = 0; numberBelow64 + j < 64 && j < twoThreeOrFour; ++j) {
                this.blockDataValuesArray[numberBelow64 + j] = 12;
            }
        }
        numberFromTwoToFive = random.nextInt(4) + 2;
        for (i = 0; i < numberFromTwoToFive; ++i) {
            int oneTwoOrThree = random.nextInt(3) + 1;
            numberBelow64 = random.nextInt(64);
            for (j = 0; numberBelow64 + j < 64 && j < oneTwoOrThree; ++j) {
                this.blockDataValuesArray[numberBelow64 + j] = 14;
            }
        }
        int numberFromThreeToFive = random.nextInt(3) + 3;
        int increasingNumber = 0;
        for (int i4 = 0; i4 < numberFromThreeToFive; ++i4) {
            increasingNumber += random.nextInt(16) + 4;
            for (j = 0; increasingNumber + j < 64 && j < 1; ++j) {
                this.blockDataValuesArray[increasingNumber + j] = 0;
                if (increasingNumber + j > 1 && random.nextBoolean()) {
                    this.blockDataValuesArray[increasingNumber + j - 1] = 8;
                }
                if (increasingNumber + j >= 63 || !random.nextBoolean()) continue;
                this.blockDataValuesArray[increasingNumber + j + 1] = 8;
            }
        }
    }

    @Override
    public void spawn(LocalWorld world, BiomeConfig biomeConfig, double noise, int x, int z) {
        this.random.setSeed(world.getSeed() ^ (long)x ^ (long)z);
        if (this.blockDataValuesArray == null) {
            this.initializeSmallByteArray(world.getSeed());
        }
        LocalMaterialData biomeSurfaceBlock = biomeConfig.surfaceBlock;
        LocalMaterialData biomeGroundBlock = biomeConfig.groundBlock;
        int biomeGroundBlockData = biomeGroundBlock.isMaterial(DefaultMaterial.DIRT) ? 1 : 0;
        boolean foundWater = false;
        int highestBlockY = world.getHighestBlockYAt(x, z) - 1;
        if (highestBlockY <= biomeConfig.riverWaterLevel) {
            foundWater = true;
        }
        double bryceHeight = 0.0;
        if (this.isBryceMesa && !foundWater) {
            double bryceNoiseValue;
            if (this.noiseGenBryce1 == null || this.noiseGenBryce2 == null) {
                Random newRandom = new Random(world.getSeed());
                this.noiseGenBryce1 = new NoiseGeneratorNewOctaves(newRandom, 4);
                this.noiseGenBryce2 = new NoiseGeneratorNewOctaves(newRandom, 1);
            }
            if ((bryceNoiseValue = Math.min(Math.abs(noise), this.noiseGenBryce1.a((double)x * 0.25, (double)z * 0.25))) > 0.0) {
                bryceHeight = bryceNoiseValue * bryceNoiseValue * 2.5;
                double d3 = 0.001953125;
                double d4 = Math.abs(this.noiseGenBryce2.a((double)x * d3, (double)z * d3));
                double d5 = Math.ceil(d4 * 50.0) + 14.0;
                if (bryceHeight > d5) {
                    bryceHeight = d5;
                }
                bryceHeight += 64.0;
            }
        }
        int waterLevel = biomeConfig.waterLevelMax;
        LocalMaterialData currentGroundBlock = this.whiteStainedClay;
        int noisePlusRandomFactor = (int)(noise / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
        boolean cosNoiseIsLargerThanZero = (double)MathHelper.cos((float)(noise / 3.0 * Math.PI)) > 0.0;
        int j1 = -1;
        boolean belowSand = false;
        int maxHeight = world.getSolidHeight(x, z) - 1;
        int minHeight = Math.min(maxHeight - 6, waterLevel - 4);
        if (this.isBryceMesa && !foundWater) {
            maxHeight = Math.max((int)bryceHeight, maxHeight);
        }
        for (int y = maxHeight; y >= minHeight; --y) {
            int blockData;
            LocalMaterialData blockAtPosition = world.getMaterial(x, y, z);
            if (!blockAtPosition.isSolid() && (double)y < bryceHeight) {
                blockAtPosition = TerrainControl.toLocalMaterialData(DefaultMaterial.STONE, 0);
            }
            if (blockAtPosition.isAir()) {
                j1 = -1;
                continue;
            }
            if (!blockAtPosition.isSolid()) continue;
            if (j1 == -1) {
                belowSand = false;
                if (y >= waterLevel - 4 && y <= waterLevel + 1) {
                    currentGroundBlock = this.whiteStainedClay;
                }
                j1 = noisePlusRandomFactor + Math.max(0, y - waterLevel);
                if (y >= waterLevel - 1) {
                    if (this.isForestMesa && y > 86 + noisePlusRandomFactor * 2) {
                        currentGroundBlock = cosNoiseIsLargerThanZero ? biomeGroundBlock.withBlockData(biomeGroundBlockData) : biomeSurfaceBlock;
                        world.setBlock(x, y, z, currentGroundBlock);
                        continue;
                    }
                    if (y > waterLevel + 3 + noisePlusRandomFactor) {
                        blockData = 16;
                        if (y >= 64 && y <= 127) {
                            if (!cosNoiseIsLargerThanZero) {
                                blockData = this.getBlockData(x, y, z);
                            }
                        } else {
                            blockData = 1;
                        }
                        if (blockData < 16) {
                            world.setBlock(x, y, z, TerrainControl.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, blockData));
                            continue;
                        }
                        world.setBlock(x, y, z, this.hardenedClay);
                        continue;
                    }
                    world.setBlock(x, y, z, this.redSand);
                    belowSand = true;
                    continue;
                }
                if (currentGroundBlock.isMaterial(DefaultMaterial.STAINED_CLAY)) {
                    world.setBlock(x, y, z, this.orangeStainedClay);
                    continue;
                }
                world.setBlock(x, y, z, currentGroundBlock.withBlockData(0));
                continue;
            }
            if (j1 <= 0) continue;
            --j1;
            if (belowSand) {
                world.setBlock(x, y, z, this.orangeStainedClay);
                continue;
            }
            blockData = this.getBlockData(x, y, z);
            if (blockData < 16) {
                world.setBlock(x, y, z, this.whiteStainedClay.withBlockData(blockData));
                continue;
            }
            world.setBlock(x, y, z, this.hardenedClay);
        }
    }

    @Override
    public String toString() {
        if (this.isForestMesa) {
            return NAME_FOREST;
        }
        if (this.isBryceMesa) {
            return NAME_BRYCE;
        }
        return NAME_NORMAL;
    }
}

