/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.LayerBiome;
import com.khorn.terraincontrol.generator.biome.layers.LayerBiomeBorder;
import com.khorn.terraincontrol.generator.biome.layers.LayerBiomeInBiome;
import com.khorn.terraincontrol.generator.biome.layers.LayerEmpty;
import com.khorn.terraincontrol.generator.biome.layers.LayerFromImage;
import com.khorn.terraincontrol.generator.biome.layers.LayerIce;
import com.khorn.terraincontrol.generator.biome.layers.LayerLand;
import com.khorn.terraincontrol.generator.biome.layers.LayerLandRandom;
import com.khorn.terraincontrol.generator.biome.layers.LayerMix;
import com.khorn.terraincontrol.generator.biome.layers.LayerMixWithRiver;
import com.khorn.terraincontrol.generator.biome.layers.LayerRiver;
import com.khorn.terraincontrol.generator.biome.layers.LayerRiverInit;
import com.khorn.terraincontrol.generator.biome.layers.LayerSmooth;
import com.khorn.terraincontrol.generator.biome.layers.LayerZoom;
import com.khorn.terraincontrol.generator.biome.layers.LayerZoomFuzzy;
import com.khorn.terraincontrol.generator.biome.layers.LayerZoomVoronoi;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.util.ArrayList;

public abstract class Layer {
    protected long worldGenSeed;
    protected Layer child;
    private long chunkSeed;
    protected long baseSeed;
    protected static final int BiomeBits = 1023;
    protected static final int LandBit = 1024;
    protected static final int RiverBits = 12288;
    protected static final int RiverBitOne = 4096;
    protected static final int RiverBitTwo = 8192;
    protected static final int IceBit = 2048;
    protected static final int IslandBit = 16384;

    protected static int GetBiomeFromLayer(int BiomeAndLand) {
        if ((BiomeAndLand & 0x400) != 0) {
            return BiomeAndLand & 0x3FF;
        }
        return 0;
    }

    public static Layer[] Init(long paramLong, LocalWorld world) {
        ConfigProvider configs = world.getConfigs();
        WorldConfig worldConfig = configs.getWorldConfig();
        LocalBiome[][] NormalBiomeMap = new LocalBiome[worldConfig.GenerationDepth + 1][];
        LocalBiome[][] IceBiomeMap = new LocalBiome[worldConfig.GenerationDepth + 1][];
        for (int i = 0; i < worldConfig.GenerationDepth + 1; ++i) {
            ArrayList<LocalBiome> normalBiomes = new ArrayList<LocalBiome>();
            ArrayList<LocalBiome> iceBiomes = new ArrayList<LocalBiome>();
            for (LocalBiome biome : configs.getBiomeArray()) {
                int t;
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize != i) continue;
                if (worldConfig.NormalBiomes.contains(biomeConfig.getName())) {
                    for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                        normalBiomes.add(biome);
                    }
                    worldConfig.normalBiomesRarity -= biomeConfig.biomeRarity;
                }
                if (!worldConfig.IceBiomes.contains(biomeConfig.getName())) continue;
                for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                    iceBiomes.add(biome);
                }
                worldConfig.iceBiomesRarity -= biomeConfig.biomeRarity;
            }
            NormalBiomeMap[i] = !normalBiomes.isEmpty() ? normalBiomes.toArray(new LocalBiome[normalBiomes.size() + worldConfig.normalBiomesRarity]) : new LocalBiome[0];
            IceBiomeMap[i] = !iceBiomes.isEmpty() ? iceBiomes.toArray(new LocalBiome[iceBiomes.size() + worldConfig.iceBiomesRarity]) : new LocalBiome[0];
        }
        Layer MainLayer = new LayerEmpty(1L);
        Layer RiverLayer = new LayerEmpty(1L);
        boolean riversStarted = false;
        for (int depth = 0; depth <= worldConfig.GenerationDepth; ++depth) {
            MainLayer = new LayerZoom(2001 + depth, MainLayer);
            if (worldConfig.randomRivers && riversStarted) {
                RiverLayer = new LayerZoom(2001 + depth, RiverLayer);
            }
            if (worldConfig.LandSize == depth) {
                MainLayer = new LayerLand(1L, MainLayer, worldConfig.LandRarity);
                MainLayer = new LayerZoomFuzzy(2000L, MainLayer);
            }
            if (depth < worldConfig.LandSize + worldConfig.LandFuzzy) {
                MainLayer = new LayerLandRandom(depth, MainLayer);
            }
            if (NormalBiomeMap[depth].length != 0 || IceBiomeMap[depth].length != 0) {
                MainLayer = new LayerBiome(200L, MainLayer, NormalBiomeMap[depth], IceBiomeMap[depth]);
            }
            if (worldConfig.IceSize == depth) {
                MainLayer = new LayerIce(depth, MainLayer, worldConfig.IceRarity);
            }
            if (worldConfig.riverRarity == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiverInit(155L, RiverLayer);
                    riversStarted = true;
                } else {
                    MainLayer = new LayerRiverInit(155L, MainLayer);
                }
            }
            if (worldConfig.GenerationDepth - worldConfig.riverSize == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiver(5 + depth, RiverLayer);
                } else {
                    MainLayer = new LayerRiver(5 + depth, MainLayer);
                }
            }
            LayerBiomeBorder layerBiomeBorder = new LayerBiomeBorder(3000 + depth, world);
            boolean haveBorder = false;
            for (LocalBiome biome : configs.getBiomeArray()) {
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize != depth) continue;
                if (worldConfig.IsleBiomes.contains(biomeConfig.getName()) && biomeConfig.isleInBiome != null) {
                    int id = biome.getIds().getGenerationId();
                    LayerBiomeInBiome layerBiome = new LayerBiomeInBiome(4000 + id, MainLayer);
                    layerBiome.biome = biome;
                    for (String islandInName : biomeConfig.isleInBiome) {
                        int islandIn = world.getBiomeByName(islandInName).getIds().getGenerationId();
                        if (islandIn == DefaultBiome.OCEAN.Id) {
                            layerBiome.inOcean = true;
                            continue;
                        }
                        layerBiome.biomeIsles[islandIn] = true;
                    }
                    layerBiome.chance = worldConfig.BiomeRarityScale + 1 - biomeConfig.biomeRarity;
                    MainLayer = layerBiome;
                }
                if (!worldConfig.BorderBiomes.contains(biomeConfig.getName()) || biomeConfig.biomeIsBorder == null) continue;
                haveBorder = true;
                for (String replaceFromName : biomeConfig.biomeIsBorder) {
                    int replaceFrom = world.getBiomeByName(replaceFromName).getIds().getGenerationId();
                    layerBiomeBorder.addBiome(biome, replaceFrom, world);
                }
            }
            if (!haveBorder) continue;
            layerBiomeBorder.child = MainLayer;
            MainLayer = layerBiomeBorder;
        }
        MainLayer = worldConfig.randomRivers ? new LayerMixWithRiver(1L, MainLayer, RiverLayer, configs, world) : new LayerMix(1L, MainLayer, configs, world);
        MainLayer = new LayerSmooth(400L, MainLayer);
        if (worldConfig.biomeMode == TerrainControl.getBiomeModeManager().FROM_IMAGE) {
            MainLayer = worldConfig.imageMode == WorldConfig.ImageMode.ContinueNormal ? new LayerFromImage(1L, MainLayer, worldConfig, world) : new LayerFromImage(1L, null, worldConfig, world);
        }
        LayerZoomVoronoi ZoomedLayer = new LayerZoomVoronoi(10L, MainLayer);
        ZoomedLayer.initWorldGenSeed(paramLong);
        return new Layer[]{MainLayer, ZoomedLayer};
    }

    public Layer(long seed) {
        this.baseSeed = seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
    }

    public void initWorldGenSeed(long seed) {
        this.worldGenSeed = seed;
        if (this.child != null) {
            this.child.initWorldGenSeed(seed);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    protected void initChunkSeed(long x, long z) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += x;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += z;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += x;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += z;
    }

    protected int nextInt(int x) {
        int i = (int)((this.chunkSeed >> 24) % (long)x);
        if (i < 0) {
            i += x;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return i;
    }

    public abstract int[] getInts(ArraysCache var1, int var2, int var3, int var4, int var5);

    protected int getRandomInArray(int ... biomes) {
        return biomes[this.nextInt(biomes.length)];
    }

    protected int getRandomOf4(int a, int b, int c, int d) {
        return b == c && c == d ? b : (a == b && a == c ? a : (a == b && a == d ? a : (a == c && a == d ? a : (a == b && c != d ? a : (a == c && b != d ? a : (a == d && b != c ? a : (b == c && a != d ? b : (b == d && a != c ? b : (c == d && a != b ? c : this.getRandomInArray(a, b, c, d))))))))));
    }
}

