/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.util;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    public static NamedBinaryTag getNBTFromNMSTagCompound(String name, NBTTagCompound nmsTag) {
        NamedBinaryTag compoundTag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_Compound, name, new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, null, null)});
        Map nmsChildTags = null;
        try {
            Field mapField = NBTTagCompound.class.getDeclaredField("map");
            mapField.setAccessible(true);
            nmsChildTags = (Map)mapField.get(nmsTag);
        }
        catch (Exception e) {
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
        }
        if (nmsChildTags == null) {
            return compoundTag;
        }
        for (Map.Entry entry : nmsChildTags.entrySet()) {
            NBTBase nmsChildTag = (NBTBase)entry.getValue();
            NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsChildTag.func_74732_a()];
            switch (type) {
                case TAG_End: {
                    break;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    compoundTag.addTag(new NamedBinaryTag(type, (String)entry.getKey(), NBTHelper.getValueFromNms(nmsChildTag)));
                    break;
                }
                case TAG_List: {
                    NamedBinaryTag listChildTag = NBTHelper.getNBTFromNMSTagList((String)entry.getKey(), (NBTTagList)nmsChildTag);
                    if (listChildTag == null) break;
                    compoundTag.addTag(listChildTag);
                    break;
                }
                case TAG_Compound: {
                    compoundTag.addTag(NBTHelper.getNBTFromNMSTagCompound((String)entry.getKey(), (NBTTagCompound)nmsChildTag));
                    break;
                }
            }
        }
        return compoundTag;
    }

    private static NamedBinaryTag getNBTFromNMSTagList(String name, NBTTagList nmsListTag) {
        if (nmsListTag.func_74745_c() == 0) {
            return null;
        }
        NamedBinaryTag.Type listType = NamedBinaryTag.Type.values()[nmsListTag.func_150303_d()];
        NamedBinaryTag listTag = new NamedBinaryTag(name, listType);
        block7: for (int i = 0; i < nmsListTag.func_74745_c(); ++i) {
            switch (listType) {
                case TAG_Int_Array: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.func_150306_c(i)));
                    continue block7;
                }
                case TAG_Float: {
                    listTag.addTag(new NamedBinaryTag(listType, null, Float.valueOf(nmsListTag.func_150308_e(i))));
                    continue block7;
                }
                case TAG_Double: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.func_150309_d(i)));
                    continue block7;
                }
                case TAG_String: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.func_150307_f(i)));
                    continue block7;
                }
                case TAG_Compound: {
                    listTag.addTag(NBTHelper.getNBTFromNMSTagCompound(null, nmsListTag.func_150305_b(i)));
                    continue block7;
                }
                default: {
                    TerrainControl.log(LogMarker.INFO, "Cannot convert list subtype {} from it's NMS value", new Object[]{listType});
                }
            }
        }
        return listTag;
    }

    private static Object getValueFromNms(NBTBase nmsTag) {
        NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsTag.func_74732_a()];
        switch (type) {
            case TAG_Byte: {
                return ((NBTTagByte)nmsTag).func_150290_f();
            }
            case TAG_Short: {
                return ((NBTTagShort)nmsTag).func_150289_e();
            }
            case TAG_Int: {
                return ((NBTTagInt)nmsTag).func_150287_d();
            }
            case TAG_Long: {
                return ((NBTTagLong)nmsTag).func_150291_c();
            }
            case TAG_Float: {
                return Float.valueOf(((NBTTagFloat)nmsTag).func_150288_h());
            }
            case TAG_Double: {
                return ((NBTTagDouble)nmsTag).func_150286_g();
            }
            case TAG_Byte_Array: {
                return ((NBTTagByteArray)nmsTag).func_150292_c();
            }
            case TAG_String: {
                return ((NBTTagString)nmsTag).func_150285_a_();
            }
            case TAG_Int_Array: {
                return ((NBTTagIntArray)nmsTag).func_150302_c();
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }

    public static NBTTagCompound getNMSFromNBTTagCompound(NamedBinaryTag compoundTag) {
        NamedBinaryTag[] childTags;
        NBTTagCompound nmsTag = new NBTTagCompound();
        block6: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])compoundTag.getValue()) {
            switch (tag.getType()) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.func_74782_a(tag.getName(), NBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block6;
                }
                case TAG_List: {
                    nmsTag.func_74782_a(tag.getName(), (NBTBase)NBTHelper.getNMSFromNBTTagList(tag));
                    continue block6;
                }
                case TAG_Compound: {
                    nmsTag.func_74782_a(tag.getName(), (NBTBase)NBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block6;
                }
            }
        }
        return nmsTag;
    }

    private static NBTTagList getNMSFromNBTTagList(NamedBinaryTag listTag) {
        NamedBinaryTag[] childTags;
        NBTTagList nmsTag = new NBTTagList();
        block6: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])listTag.getValue()) {
            switch (tag.getType()) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.func_74742_a(NBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block6;
                }
                case TAG_List: {
                    nmsTag.func_74742_a((NBTBase)NBTHelper.getNMSFromNBTTagList(tag));
                    continue block6;
                }
                case TAG_Compound: {
                    nmsTag.func_74742_a((NBTBase)NBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block6;
                }
            }
        }
        return nmsTag;
    }

    private static NBTBase createTagNms(NamedBinaryTag.Type type, Object value) {
        switch (type) {
            case TAG_Byte: {
                return new NBTTagByte(((Byte)value).byteValue());
            }
            case TAG_Short: {
                return new NBTTagShort(((Short)value).shortValue());
            }
            case TAG_Int: {
                return new NBTTagInt(((Integer)value).intValue());
            }
            case TAG_Long: {
                return new NBTTagLong(((Long)value).longValue());
            }
            case TAG_Float: {
                return new NBTTagFloat(((Float)value).floatValue());
            }
            case TAG_Double: {
                return new NBTTagDouble(((Double)value).doubleValue());
            }
            case TAG_Byte_Array: {
                return new NBTTagByteArray((byte[])value);
            }
            case TAG_String: {
                return new NBTTagString((String)value);
            }
            case TAG_Int_Array: {
                return new NBTTagIntArray((int[])value);
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }

    private NBTHelper() {
    }
}

