/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.forge.ForgeBiome;
import com.khorn.terraincontrol.forge.generator.structure.RareBuildingStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class RareBuildingGen
extends MapGenStructure {
    public List<BiomeGenBase> biomeList = new ArrayList<BiomeGenBase>();
    private List scatteredFeatureSpawnList;
    private int maxDistanceBetweenScatteredFeatures;
    private int minDistanceBetweenScatteredFeatures;

    public RareBuildingGen(WorldSettings configs) {
        for (LocalBiome biome : configs.biomes) {
            if (biome == null || biome.getBiomeConfig().rareBuildingType == BiomeConfig.RareBuildingType.disabled) continue;
            this.biomeList.add(((ForgeBiome)biome).getHandle());
        }
        this.scatteredFeatureSpawnList = new ArrayList();
        this.maxDistanceBetweenScatteredFeatures = configs.worldConfig.maximumDistanceBetweenRareBuildings;
        this.minDistanceBetweenScatteredFeatures = configs.worldConfig.minimumDistanceBetweenRareBuildings - 1;
        this.scatteredFeatureSpawnList.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int var3 = chunkX;
        int var4 = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int var5 = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int var6 = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(var5, var6, 14357617);
        var5 *= this.maxDistanceBetweenScatteredFeatures;
        var6 *= this.maxDistanceBetweenScatteredFeatures;
        if (var3 == (var5 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && var4 == (var6 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            BiomeGenBase biomeAtPosition = this.field_75039_c.func_72959_q().func_76935_a(var3 * 16 + 8, var4 * 16 + 8);
            for (BiomeGenBase biome : this.biomeList) {
                if (biomeAtPosition.field_76756_M != biome.field_76756_M) continue;
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new RareBuildingStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public List getScatteredFeatureSpawnList() {
        return this.scatteredFeatureSpawnList;
    }

    public String func_143025_a() {
        return "TCTemple";
    }
}

