/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.generator.ChunkBuffer;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

class ForgeChunkBuffer
implements ChunkBuffer {
    private final ChunkCoordinate chunkCoord;
    private final Block[] blocks = new Block[65536];
    private final byte[] blockData = new byte[65536];

    ForgeChunkBuffer(ChunkCoordinate chunkCoord) {
        this.chunkCoord = chunkCoord;
    }

    @Override
    public ChunkCoordinate getChunkCoordinate() {
        return this.chunkCoord;
    }

    @Override
    public void setBlock(int blockX, int blockY, int blockZ, LocalMaterialData material) {
        int arrayPos = (blockX * 16 + blockZ) * 256 + blockY;
        this.blocks[arrayPos] = ((ForgeMaterialData)material).internalBlock();
        this.blockData[arrayPos] = material.getBlockData();
    }

    @Override
    public LocalMaterialData getBlock(int blockX, int blockY, int blockZ) {
        int arrayPos = (blockX * 16 + blockZ) * 256 + blockY;
        Block block = this.blocks[arrayPos];
        if (block == null) {
            block = Blocks.field_150350_a;
        }
        byte data = this.blockData[arrayPos];
        return ForgeMaterialData.ofMinecraftBlock(block, data);
    }

    Chunk toChunk(World world) {
        return new Chunk(world, this.blocks, this.blockData, this.chunkCoord.getChunkX(), this.chunkCoord.getChunkZ());
    }
}

