/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.configuration.io.BracketSettingsReader;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectLoader;
import com.khorn.terraincontrol.util.helpers.FileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CustomObjectCollection
implements Iterable<CustomObject> {
    private final List<CustomObject> objects = new ArrayList<CustomObject>();
    private final Map<String, CustomObject> objectsByName = new HashMap<String, CustomObject>();
    private CustomObjectCollection fallback;

    public CustomObjectCollection() {
    }

    public CustomObjectCollection(Map<String, CustomObjectLoader> loaders, File directory) {
        this();
        this.load(loaders, directory);
    }

    public void load(Map<String, CustomObjectLoader> loaders, File directory) {
        if (!FileHelper.makeFolder(directory)) {
            return;
        }
        Map<String, CustomObject> objects = CustomObjectCollection.loadObjectsRecursive(loaders, directory);
        for (CustomObject object : objects.values()) {
            object.onEnable(objects);
            this.addLoadedObject(object);
        }
    }

    public void addLoadedObject(CustomObject object) {
        String lowerCaseName = object.getName().toLowerCase();
        if (!this.objectsByName.containsKey(lowerCaseName)) {
            this.objectsByName.put(lowerCaseName, object);
            this.objects.add(object);
        }
    }

    public void setFallback(CustomObjectCollection customObjects) {
        this.fallback = customObjects;
    }

    private static Map<String, CustomObject> loadObjectsRecursive(Map<String, CustomObjectLoader> loaders, File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given file is not a directory: " + directory.getAbsolutePath());
        }
        HashMap<String, CustomObject> objects = new HashMap<String, CustomObject>();
        for (File file : directory.listFiles()) {
            String fileName = file.getName();
            int index = fileName.lastIndexOf(46);
            if (file.isDirectory()) {
                objects.putAll(CustomObjectCollection.loadObjectsRecursive(loaders, file));
                continue;
            }
            if (index == -1) continue;
            String objectType = fileName.substring(index + 1, fileName.length());
            String objectName = fileName.substring(0, index);
            CustomObjectLoader loader = loaders.get(objectType.toLowerCase());
            if (loader == null) continue;
            CustomObject object = loader.loadFromFile(objectName, file);
            objects.put(objectName.toLowerCase(), object);
        }
        return objects;
    }

    public CustomObject getRandomObject(Random random) {
        if (this.objects.isEmpty()) {
            return null;
        }
        return this.objects.get(random.nextInt(this.objects.size()));
    }

    public CustomObject getObjectByName(String name) {
        CustomObject object = this.objectsByName.get(name.toLowerCase());
        if (object == null && this.fallback != null) {
            return this.fallback.getObjectByName(name);
        }
        return object;
    }

    public CustomObject parseCustomObject(String string) {
        CustomObject object;
        String objectName = string;
        String objectExtraSettings = "";
        int start = string.indexOf(40);
        int end = string.lastIndexOf(41);
        if (start != -1 && end != -1) {
            objectName = string.substring(0, start);
            objectExtraSettings = string.substring(start + 1, end);
        }
        if ((object = this.getObjectByName(objectName)) != null && objectExtraSettings.length() != 0) {
            object = object.applySettings(new BracketSettingsReader(object.getName(), objectExtraSettings));
        }
        return object;
    }

    public List<CustomObject> getAll() {
        return Collections.unmodifiableList(this.objects);
    }

    @Override
    public Iterator<CustomObject> iterator() {
        return this.objects.iterator();
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    Map<String, CustomObject> accessMap() {
        return this.objectsByName;
    }
}

