/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.io;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileSettingsWriter
implements SettingsWriter {
    private final File file;
    private boolean writeComments;
    private BufferedWriter writer;

    public static final void writeToFile(ConfigFile config, WorldConfig.ConfigMode configMode) {
        FileSettingsWriter.writeToFile(config, config.getFile(), configMode);
    }

    public static final void writeToFile(ConfigFile config, File file, WorldConfig.ConfigMode configMode) {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            return;
        }
        try {
            FileSettingsWriter writer = new FileSettingsWriter(file);
            config.write(writer, configMode);
        }
        catch (IOException e) {
            config.logIOError(e);
        }
    }

    public FileSettingsWriter(ConfigFile configFile) {
        this.file = configFile.getFile();
    }

    public FileSettingsWriter(File file) {
        this.file = file;
    }

    @Override
    public void bigTitle(String title) throws IOException {
        this.checkState();
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        StringBuilder builder = new StringBuilder(title);
        builder.insert(0, ' ');
        builder.append(' ');
        boolean flag = true;
        while (builder.length() < 65) {
            if (flag) {
                builder.insert(0, ' ');
            } else {
                builder.append(' ');
            }
            flag = !flag;
        }
        this.writer.write("# |" + builder.toString() + "| #");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.newLine();
    }

    private void checkState() throws IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Not started writing yet");
        }
    }

    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            TerrainControl.log(LogMarker.WARN, "Failed to close file {} ({})", this.file.getAbsolutePath(), e.getMessage());
        }
        this.writer = null;
    }

    @Override
    public void comment(String comment) throws IOException {
        this.checkState();
        if (!this.writeComments) {
            return;
        }
        if (comment.length() > 0) {
            this.writer.write("# " + comment);
        }
        this.writer.newLine();
    }

    @Override
    public void function(ConfigFunction<?> function) throws IOException {
        this.checkState();
        this.writer.write(function.write());
        this.writer.newLine();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void open() throws IOException {
        this.file.getParentFile().mkdirs();
        this.writer = new BufferedWriter(new FileWriter(this.file));
    }

    @Override
    public void setConfigMode(WorldConfig.ConfigMode configMode) {
        if (configMode == WorldConfig.ConfigMode.WriteAll) {
            this.writeComments = true;
        } else if (configMode == WorldConfig.ConfigMode.WriteWithoutComments) {
            this.writeComments = false;
        } else {
            throw new IllegalArgumentException("Invalid config mode: " + (Object)((Object)configMode));
        }
    }

    public <T> void setting(Setting<T> setting, T value) throws IOException {
        this.checkState();
        this.writer.write(setting.getName() + ": " + setting.write(value));
        this.writer.newLine();
        this.writer.newLine();
    }

    @Override
    public void smallTitle(String title) throws IOException {
        this.checkState();
        int titleLength = title.length();
        StringBuilder rowBuilder = new StringBuilder(titleLength + 4);
        for (int i = 0; i < titleLength + 4; ++i) {
            rowBuilder.append('#');
        }
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.write("# " + title + " #");
        this.writer.newLine();
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.newLine();
    }
}

