/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.io;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BracketSettingsReader
implements SettingsReader {
    private SettingsReader fallback;
    private final String name;
    private final Map<String, String> settingsMap;

    public BracketSettingsReader(String name, String rawSettings) {
        String[] settings;
        this.name = name;
        this.settingsMap = new HashMap<String, String>();
        for (String setting : settings = rawSettings.split(";")) {
            String[] settingParts = setting.split("=", 2);
            String settingName = settingParts[0].toLowerCase().trim();
            if (settingName.isEmpty()) continue;
            if (settingParts.length == 1) {
                this.settingsMap.put(settingName, "true");
                continue;
            }
            if (settingParts.length != 2) continue;
            this.settingsMap.put(settingName, settingParts[1].trim());
        }
    }

    @Override
    public <T> void addConfigFunction(ConfigFunction<T> function) {
    }

    @Override
    public <T> List<ConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback) {
        if (useFallback && this.fallback != null) {
            return this.fallback.getConfigFunctions(holder, true);
        }
        return Collections.emptyList();
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getRawSettings() {
        return Collections.emptyList();
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue) {
        String stringValue = this.settingsMap.get(setting.getName().toLowerCase());
        if (stringValue != null) {
            try {
                return setting.read(stringValue);
            }
            catch (InvalidConfigException e) {
                TerrainControl.log(LogMarker.ERROR, "The value \"{}\" is not valid for the setting {} in {}: {}", stringValue, setting, this.name, e.getMessage());
            }
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        if (this.settingsMap.containsKey(setting.getName().toLowerCase())) {
            return true;
        }
        if (this.fallback != null) {
            return this.fallback.hasSetting(setting);
        }
        return false;
    }

    @Override
    public boolean isNewConfig() {
        return true;
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value) {
        this.settingsMap.put(setting.getName().toLowerCase(), setting.write(value));
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
        if (this.settingsMap.containsKey(oldValue.toLowerCase())) {
            this.settingsMap.put(newValue.getName().toLowerCase(), this.settingsMap.get(oldValue.toLowerCase()));
        }
    }

    @Override
    public void setFallbackReader(SettingsReader reader) {
        this.fallback = reader;
    }
}

