/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.ReplacedBlocksMatrix;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.configuration.standard.BiomeStandardValues;
import com.khorn.terraincontrol.configuration.standard.StandardBiomeTemplate;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.UseBiome;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.CustomStructureGen;
import com.khorn.terraincontrol.generator.resource.IceSpikeGen;
import com.khorn.terraincontrol.generator.resource.PlantType;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.generator.resource.SaplingGen;
import com.khorn.terraincontrol.generator.resource.SaplingType;
import com.khorn.terraincontrol.generator.resource.SmallLakeGen;
import com.khorn.terraincontrol.generator.surface.NullSurfaceGenerator;
import com.khorn.terraincontrol.generator.surface.SurfaceGenerator;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class BiomeConfig
extends ConfigFile {
    public String biomeExtends;
    public boolean biomeExtendsProcessed = false;
    private boolean processHasRun = false;
    private boolean doResourceInheritance = true;
    public String riverBiome;
    public float riverHeight;
    public float riverVolatility;
    public double[] riverHeightMatrix;
    public int biomeSize;
    public int biomeRarity;
    public int biomeColor;
    public List<String> biomeIsBorder;
    public List<String> isleInBiome;
    public List<String> notBorderNear;
    public float biomeHeight;
    public float biomeVolatility;
    public int smoothRadius;
    public float biomeTemperature;
    public float biomeWetness;
    public LocalMaterialData stoneBlock;
    public LocalMaterialData surfaceBlock;
    public LocalMaterialData groundBlock;
    public ReplacedBlocksMatrix replacedBlocks;
    public SurfaceGenerator surfaceAndGroundControl;
    public String replaceToBiomeName;
    public boolean useWorldWaterLevel;
    public int waterLevelMax;
    public int waterLevelMin;
    public LocalMaterialData waterBlock;
    public LocalMaterialData iceBlock;
    public int riverWaterLevel;
    private int configWaterLevelMax;
    private int configWaterLevelMin;
    private LocalMaterialData configWaterBlock;
    private LocalMaterialData configIceBlock;
    private int configRiverWaterLevel;
    public int skyColor;
    public int waterColor;
    public int grassColor;
    public boolean grassColorIsMultiplier;
    public int foliageColor;
    public boolean foliageColorIsMultiplier;
    public List<Resource> resourceSequence = new ArrayList<Resource>();
    private Map<SaplingType, SaplingGen> saplingGrowers = new EnumMap<SaplingType, SaplingGen>(SaplingType.class);
    public ArrayList<CustomObject> biomeObjects;
    public CustomStructureGen structureGen;
    public ArrayList<String> biomeObjectStrings;
    public double maxAverageHeight;
    public double maxAverageDepth;
    public double volatility1;
    public double volatility2;
    public double volatilityWeight1;
    public double volatilityWeight2;
    private double volatilityRaw1;
    private double volatilityRaw2;
    private double volatilityWeightRaw1;
    private double volatilityWeightRaw2;
    public boolean disableNotchHeightControl;
    public double[] heightMatrix;
    public boolean strongholdsEnabled;
    public boolean netherFortressesEnabled;
    public VillageType villageType;
    public double mineshaftsRarity;
    public RareBuildingType rareBuildingType;
    public final int generationId;
    public StandardBiomeTemplate defaultSettings;
    public WorldConfig worldConfig;
    public List<WeightedMobSpawnGroup> spawnMonsters = new ArrayList<WeightedMobSpawnGroup>();
    public List<WeightedMobSpawnGroup> spawnCreatures = new ArrayList<WeightedMobSpawnGroup>();
    public List<WeightedMobSpawnGroup> spawnWaterCreatures = new ArrayList<WeightedMobSpawnGroup>();
    public List<WeightedMobSpawnGroup> spawnAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();

    public BiomeConfig(SettingsReader reader, BiomeLoadInstruction loadInstruction, WorldConfig worldConfig) {
        super(reader);
        this.generationId = loadInstruction.getGenerationId();
        this.worldConfig = worldConfig;
        this.defaultSettings = loadInstruction.getBiomeTemplate();
        this.biomeExtends = this.readSettings(BiomeStandardValues.BIOME_EXTENDS, this.defaultSettings.defaultExtends);
    }

    public void process() {
        if (!this.processHasRun) {
            this.processHasRun = true;
            this.renameOldSettings();
            this.readConfigSettings();
            this.correctSettings();
            if (this.isNewConfig) {
                this.resourceSequence.addAll(this.defaultSettings.createDefaultResources(this));
            }
            if (this.useWorldWaterLevel) {
                this.waterLevelMax = this.worldConfig.waterLevelMax;
                this.waterLevelMin = this.worldConfig.waterLevelMin;
                this.waterBlock = this.worldConfig.waterBlock;
                this.iceBlock = this.worldConfig.iceBlock;
                this.riverWaterLevel = this.worldConfig.waterLevelMax;
            } else {
                this.waterLevelMax = this.configWaterLevelMax;
                this.waterLevelMin = this.configWaterLevelMin;
                this.waterBlock = this.configWaterBlock;
                this.iceBlock = this.configIceBlock;
                this.riverWaterLevel = this.configRiverWaterLevel;
            }
        }
    }

    public void outputToFile() {
        if (!this.processHasRun) {
            throw new IllegalStateException("Run process() first!");
        }
        if (!this.biomeExtends.isEmpty()) {
            File inheritedFile = new File(this.getFile().getAbsolutePath() + ".inherited");
            FileSettingsWriter.writeToFile(this, inheritedFile, WorldConfig.ConfigMode.WriteAll);
        } else {
            FileSettingsWriter.writeToFile(this, this.worldConfig.SettingsMode);
        }
    }

    public SaplingGen getSaplingGen(SaplingType type) {
        SaplingGen gen = this.saplingGrowers.get((Object)type);
        if (gen == null && type.growsTree()) {
            gen = this.saplingGrowers.get((Object)SaplingType.All);
        }
        return gen;
    }

    @Override
    protected void readConfigSettings() {
        this.doResourceInheritance = this.readSettings(BiomeStandardValues.RESOURCE_INHERITANCE);
        this.biomeSize = this.readSettings(BiomeStandardValues.BIOME_SIZE, this.defaultSettings.defaultSize);
        this.biomeRarity = this.readSettings(BiomeStandardValues.BIOME_RARITY, this.defaultSettings.defaultRarity);
        this.biomeColor = this.readSettings(BiomeStandardValues.BIOME_COLOR, this.defaultSettings.defaultColor);
        this.riverBiome = this.readSettings(BiomeStandardValues.RIVER_BIOME, this.defaultSettings.defaultRiverBiome);
        this.isleInBiome = this.readSettings(BiomeStandardValues.ISLE_IN_BIOME, this.defaultSettings.defaultIsle);
        this.biomeIsBorder = this.readSettings(BiomeStandardValues.BIOME_IS_BORDER, this.defaultSettings.defaultBorder);
        this.notBorderNear = this.readSettings(BiomeStandardValues.NOT_BORDER_NEAR, this.defaultSettings.defaultNotBorderNear);
        this.biomeTemperature = this.readSettings(BiomeStandardValues.BIOME_TEMPERATURE, Float.valueOf(this.defaultSettings.defaultBiomeTemperature)).floatValue();
        this.biomeWetness = this.readSettings(BiomeStandardValues.BIOME_WETNESS, Float.valueOf(this.defaultSettings.defaultBiomeWetness)).floatValue();
        this.replaceToBiomeName = this.defaultSettings.isCustomBiome ? this.readSettings(BiomeStandardValues.REPLACE_TO_BIOME_NAME) : "";
        this.biomeHeight = this.readSettings(BiomeStandardValues.BIOME_HEIGHT, Float.valueOf(this.defaultSettings.defaultBiomeSurface)).floatValue();
        this.biomeVolatility = this.readSettings(BiomeStandardValues.BIOME_VOLATILITY, Float.valueOf(this.defaultSettings.defaultBiomeVolatility)).floatValue();
        this.smoothRadius = this.readSettings(BiomeStandardValues.SMOOTH_RADIUS);
        this.stoneBlock = this.readSettings(BiomeStandardValues.STONE_BLOCK);
        this.surfaceBlock = this.readSettings(BiomeStandardValues.SURFACE_BLOCK, TerrainControl.toLocalMaterialData(this.defaultSettings.defaultSurfaceBlock, 0));
        this.groundBlock = this.readSettings(BiomeStandardValues.GROUND_BLOCK, TerrainControl.toLocalMaterialData(this.defaultSettings.defaultGroundBlock, 0));
        this.replacedBlocks = this.readSettings(BiomeStandardValues.REPLACED_BLOCKS);
        this.surfaceAndGroundControl = this.readSurfaceAndGroundControlSettings();
        this.useWorldWaterLevel = this.readSettings(BiomeStandardValues.USE_WORLD_WATER_LEVEL);
        this.configWaterLevelMax = this.readSettings(BiomeStandardValues.WATER_LEVEL_MAX);
        this.configWaterLevelMin = this.readSettings(BiomeStandardValues.WATER_LEVEL_MIN);
        this.configWaterBlock = this.readSettings(BiomeStandardValues.WATER_BLOCK);
        this.configIceBlock = this.readSettings(BiomeStandardValues.ICE_BLOCK);
        this.skyColor = this.readSettings(BiomeStandardValues.SKY_COLOR);
        this.waterColor = this.readSettings(BiomeStandardValues.WATER_COLOR, this.defaultSettings.defaultWaterColorMultiplier);
        this.grassColor = this.readSettings(BiomeStandardValues.GRASS_COLOR, this.defaultSettings.defaultGrassColor);
        this.grassColorIsMultiplier = this.readSettings(BiomeStandardValues.GRASS_COLOR_IS_MULTIPLIER);
        this.foliageColor = this.readSettings(BiomeStandardValues.FOLIAGE_COLOR, this.defaultSettings.defaultFoliageColor);
        this.foliageColorIsMultiplier = this.readSettings(BiomeStandardValues.FOLIAGE_COLOR_IS_MULTIPLIER);
        this.volatilityRaw1 = this.readSettings(BiomeStandardValues.VOLATILITY_1);
        this.volatilityRaw2 = this.readSettings(BiomeStandardValues.VOLATILITY_2);
        this.volatilityWeightRaw1 = this.readSettings(BiomeStandardValues.VOLATILITY_WEIGHT_1);
        this.volatilityWeightRaw2 = this.readSettings(BiomeStandardValues.VOLATILITY_WEIGHT_2);
        this.disableNotchHeightControl = this.readSettings(BiomeStandardValues.DISABLE_BIOME_HEIGHT);
        this.maxAverageHeight = this.readSettings(BiomeStandardValues.MAX_AVERAGE_HEIGHT);
        this.maxAverageDepth = this.readSettings(BiomeStandardValues.MAX_AVERAGE_DEPTH);
        this.riverHeight = this.readSettings(BiomeStandardValues.RIVER_HEIGHT).floatValue();
        this.riverVolatility = this.readSettings(BiomeStandardValues.RIVER_VOLATILITY).floatValue();
        this.configRiverWaterLevel = this.readSettings(BiomeStandardValues.RIVER_WATER_LEVEL);
        this.strongholdsEnabled = this.readSettings(BiomeStandardValues.STRONGHOLDS_ENABLED, this.defaultSettings.defaultStrongholds);
        this.netherFortressesEnabled = this.readSettings(BiomeStandardValues.NETHER_FORTRESSES_ENABLED, true);
        this.villageType = this.readSettings(BiomeStandardValues.VILLAGE_TYPE, this.defaultSettings.defaultVillageType);
        this.mineshaftsRarity = this.readSettings(BiomeStandardValues.MINESHAFT_RARITY);
        this.rareBuildingType = this.readSettings(BiomeStandardValues.RARE_BUILDING_TYPE, this.defaultSettings.defaultRareBuildingType);
        if (this.defaultSettings.isCustomBiome) {
            this.spawnMonsters = this.readSettings(BiomeStandardValues.SPAWN_MONSTERS, this.defaultSettings.defaultMonsters);
            this.spawnCreatures = this.readSettings(BiomeStandardValues.SPAWN_CREATURES, this.defaultSettings.defaultCreatures);
            this.spawnWaterCreatures = this.readSettings(BiomeStandardValues.SPAWN_WATER_CREATURES, this.defaultSettings.defaultWaterCreatures);
            this.spawnAmbientCreatures = this.readSettings(BiomeStandardValues.SPAWN_AMBIENT_CREATURES, this.defaultSettings.defaultAmbientCreatures);
        } else {
            this.spawnMonsters = this.defaultSettings.defaultMonsters;
            this.spawnCreatures = this.defaultSettings.defaultCreatures;
            this.spawnWaterCreatures = this.defaultSettings.defaultWaterCreatures;
            this.spawnAmbientCreatures = this.defaultSettings.defaultAmbientCreatures;
        }
        this.ReadCustomObjectSettings();
        this.ReadResourceSettings();
        this.heightMatrix = new double[this.worldConfig.worldHeightCap / 8 + 1];
        this.readHeightSettings(this.heightMatrix, BiomeStandardValues.CUSTOM_HEIGHT_CONTROL);
        this.riverHeightMatrix = new double[this.worldConfig.worldHeightCap / 8 + 1];
        this.readHeightSettings(this.riverHeightMatrix, BiomeStandardValues.RIVER_CUSTOM_HEIGHT_CONTROL);
    }

    private void readHeightSettings(double[] heightMatrix, Setting<double[]> setting) {
        double[] keys = this.readSettings(setting);
        for (int i = 0; i < heightMatrix.length && i < keys.length; ++i) {
            heightMatrix[i] = keys[i];
        }
    }

    private SurfaceGenerator readSurfaceAndGroundControlSettings() {
        SurfaceGenerator defaultSetting;
        if (this.isNewConfig) {
            String defaultString = StringHelper.join(this.defaultSettings.defaultSurfaceSurfaceAndGroundControl, ",");
            try {
                defaultSetting = BiomeStandardValues.SURFACE_AND_GROUND_CONTROL.read(defaultString);
            }
            catch (InvalidConfigException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            defaultSetting = new NullSurfaceGenerator();
        }
        return this.readSettings(BiomeStandardValues.SURFACE_AND_GROUND_CONTROL, defaultSetting);
    }

    private void ReadResourceSettings() {
        for (ConfigFunction<BiomeConfig> res : this.reader.getConfigFunctions(this, this.doResourceInheritance)) {
            if (res == null || res.getHolderType() == null) continue;
            if (res instanceof SaplingGen && res.isValid()) {
                SaplingGen sapling = (SaplingGen)res;
                this.saplingGrowers.put(sapling.saplingType, sapling);
                continue;
            }
            if (!(res instanceof Resource)) continue;
            this.resourceSequence.add((Resource)res);
        }
    }

    public void merge(BiomeConfig parent) {
        this.reader.setFallbackReader(parent.reader);
        this.biomeExtendsProcessed = true;
    }

    private void ReadCustomObjectSettings() {
        this.biomeObjects = new ArrayList();
        this.biomeObjectStrings = new ArrayList();
        List<String> customObjectStrings = this.readSettings(BiomeStandardValues.BIOME_OBJECTS);
        for (String customObjectString : customObjectStrings) {
            CustomObject object = this.worldConfig.worldObjects.parseCustomObject(customObjectString);
            if (object == null || object instanceof UseBiome) continue;
            this.biomeObjects.add(object);
            this.biomeObjectStrings.add(customObjectString);
        }
    }

    @Override
    protected void writeConfigSettings(SettingsWriter writer) throws IOException {
        if (this.defaultSettings.isCustomBiome) {
            writer.comment("This is the biome config file of the " + this.getName() + " biome, which is a custom biome.");
        } else {
            writer.comment("This is the biome config file of the " + this.getName() + " biome, which is one of the vanilla biomes.");
        }
        writer.bigTitle("Biome Inheritance");
        writer.comment("This should be the value of the biomeConfig you wish to extend.");
        writer.comment("The extended config will be loaded, at which point the configs included below");
        writer.comment("will overwrite any configs loaded from the extended config.");
        writer.setting(BiomeStandardValues.BIOME_EXTENDS, this.biomeExtends);
        writer.comment("When set to true, all resources of the parent biome (if any) will be copied");
        writer.comment("to the resources queue of this biome. If a resource in the parent biome looks");
        writer.comment("very similar to that of a child biome (for example, two ores of the same type)");
        writer.comment("it won't be copied.");
        writer.setting(BiomeStandardValues.RESOURCE_INHERITANCE, this.doResourceInheritance);
        writer.bigTitle("Biome placement");
        writer.comment("Biome size from 0 to GenerationDepth. Defines in which biome layer this biome will be generated (see GenerationDepth).");
        writer.comment("Higher numbers give a smaller biome, lower numbers a larger biome.");
        writer.comment("Oceans and rivers are generated using a dirrerent algorithm in the default settings,");
        writer.comment("(they aren't in one of the biome lists), so this setting won't affect them.");
        writer.setting(BiomeStandardValues.BIOME_SIZE, this.biomeSize);
        writer.comment("Biome rarity from 100 to 1. If this is normal or ice biome - chance for spawn this biome then others.");
        writer.comment("Example for normal biome :");
        writer.comment("  100 rarity mean 1/6 chance than other ( with 6 default normal biomes).");
        writer.comment("  50 rarity mean 1/11 chance than other");
        writer.comment("For isle biome this is chance to spawn isle in good place.");
        writer.comment("Don`t work on Ocean and River (frozen versions too) biomes until not added as normal biome.");
        writer.setting(BiomeStandardValues.BIOME_RARITY, this.biomeRarity);
        writer.comment("The hexadecimal color value of this biome. Used in the output of the /tc map command,");
        writer.comment("and used in the input of BiomeMode:FromImage.");
        writer.setting(BiomeStandardValues.BIOME_COLOR, this.biomeColor);
        if (this.defaultSettings.isCustomBiome) {
            writer.comment("Replace this biome to specified after the terrain is generated.");
            writer.comment("This will make the world files contain the id of the specified biome, instead of the id of this biome.");
            writer.comment("This will cause saplings, colors and mob spawning work as in specified biome.");
            writer.setting(BiomeStandardValues.REPLACE_TO_BIOME_NAME, this.replaceToBiomeName);
        } else {
            writer.comment("(ReplaceToBiomeName is only available in custom biomes.)");
            writer.comment("");
        }
        writer.smallTitle("Isle biomes only");
        writer.comment("Biome name list where this biome will be spawned as isle. Like Mushroom isle in Ocean.  This work only if this biome is in IsleBiomes in world config");
        writer.setting(BiomeStandardValues.ISLE_IN_BIOME, this.isleInBiome);
        writer.smallTitle("Border biomes only");
        writer.comment("Biome name list where this biome will be border.Like Mushroom isle shore. Use is compared as IsleInBiome");
        writer.setting(BiomeStandardValues.BIOME_IS_BORDER, this.biomeIsBorder);
        writer.comment("Biome name list near border is not applied. ");
        writer.setting(BiomeStandardValues.NOT_BORDER_NEAR, this.notBorderNear);
        writer.bigTitle("Terrain height and volatility");
        writer.comment("BiomeHeight mean how much height will be added in terrain generation");
        writer.comment("It is double value from -10.0 to 10.0");
        writer.comment("Value 0.0 equivalent half of map height with all other default settings");
        writer.setting(BiomeStandardValues.BIOME_HEIGHT, Float.valueOf(this.biomeHeight));
        writer.comment("Biome volatility.");
        writer.setting(BiomeStandardValues.BIOME_VOLATILITY, Float.valueOf(this.biomeVolatility));
        writer.comment("Smooth radius between biomes. Must be between 0 and 32, inclusive. The resulting");
        writer.comment("smooth radius seems to be  (thisSmoothRadius + 1 + smoothRadiusOfBiomeOnOtherSide) * 4 .");
        writer.comment("So if two biomes next to each other have both a smooth radius of 2, the");
        writer.comment("resulting smooth area will be (2 + 1 + 2) * 4 = 20 blocks wide.");
        writer.setting(BiomeStandardValues.SMOOTH_RADIUS, this.smoothRadius);
        writer.comment("If this value is greater than 0, then it will affect how much, on average, the terrain will rise before leveling off when it begins to increase in elevation.");
        writer.comment("If the value is less than 0, then it will cause the terrain to either increase to a lower height before leveling out or decrease in height if the value is a large enough negative.");
        writer.setting(BiomeStandardValues.MAX_AVERAGE_HEIGHT, this.maxAverageHeight);
        writer.comment("If this value is greater than 0, then it will affect how much, on average, the terrain (usually at the ottom of the ocean) will fall before leveling off when it begins to decrease in elevation. ");
        writer.comment("If the value is less than 0, then it will cause the terrain to either fall to a lesser depth before leveling out or increase in height if the value is a large enough negative.");
        writer.setting(BiomeStandardValues.MAX_AVERAGE_DEPTH, this.maxAverageDepth);
        writer.comment("Another type of noise. This noise is independent from biomes. The larger the values the more chaotic/volatile landscape generation becomes.");
        writer.comment("Setting the values to negative will have the opposite effect and make landscape generation calmer/gentler.");
        writer.setting(BiomeStandardValues.VOLATILITY_1, this.volatilityRaw1);
        writer.setting(BiomeStandardValues.VOLATILITY_2, this.volatilityRaw2);
        writer.comment("Adjust the weight of the corresponding volatility settings. This allows you to change how prevalent you want either of the volatility settings to be in the terrain.");
        writer.setting(BiomeStandardValues.VOLATILITY_WEIGHT_1, this.volatilityWeightRaw1);
        writer.setting(BiomeStandardValues.VOLATILITY_WEIGHT_2, this.volatilityWeightRaw2);
        writer.comment("Disable all noises except Volatility1 and Volatility2. Also disable default block chance from height.");
        writer.setting(BiomeStandardValues.DISABLE_BIOME_HEIGHT, this.disableNotchHeightControl);
        writer.comment("List of custom height factor, 17 double entries, each entire control of about 7 blocks height from down. Positive entry - better chance of spawn blocks, negative - smaller");
        writer.comment("Values which affect your configuration may be found only experimental. That may be very big, like ~3000.0 depends from height");
        writer.comment("Example:");
        writer.comment("  CustomHeightControl:0.0,-2500.0,0.0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0");
        writer.comment("Make empty layer above bedrock layer. ");
        writer.setting(BiomeStandardValues.CUSTOM_HEIGHT_CONTROL, this.heightMatrix);
        writer.bigTitle("Rivers");
        writer.comment("There are two different river systems - the standard one and the improved one.");
        writer.comment("See the ImprovedRivers settting in the WorldConfig. Both modes have different");
        writer.comment("river settings, so carefully read the headers to know which settings you can use.");
        writer.comment("");
        writer.smallTitle("ImprovedRivers:false");
        writer.comment("Only available when ImprovedRivers is set to false in the WorldConfig.");
        writer.comment("Sets which biome is used as the river biome.");
        writer.setting(BiomeStandardValues.RIVER_BIOME, this.riverBiome);
        writer.smallTitle("ImprovedRivers:true");
        writer.comment("Only available when ImprovedRivers is set to true in the WorldConfig.");
        writer.comment("");
        writer.comment("Works the same as BiomeHeight (scroll up), but is used where a river is generated in this biome");
        writer.setting(BiomeStandardValues.RIVER_HEIGHT, Float.valueOf(this.riverHeight));
        writer.comment("Works the same as BiomeVolatility (scroll up), but is used where a river is generated in this biome");
        writer.setting(BiomeStandardValues.RIVER_VOLATILITY, Float.valueOf(this.riverVolatility));
        writer.comment("Works the same as WaterLevelMax (scroll down), but is used where a river is generated in this biome");
        writer.comment("Can be used to create elevated rivers");
        writer.setting(BiomeStandardValues.RIVER_WATER_LEVEL, this.configRiverWaterLevel);
        writer.comment("Works the same as CustomHeightControl (scroll up), but is used where a river is generated in this biome");
        writer.setting(BiomeStandardValues.RIVER_CUSTOM_HEIGHT_CONTROL, this.riverHeightMatrix);
        writer.bigTitle("Blocks");
        writer.comment("Change this to generate something else than stone in the biome. Doesn't support block data.");
        writer.setting(BiomeStandardValues.STONE_BLOCK, this.stoneBlock);
        writer.comment("Surface block, usually GRASS. Doesn't support block data.");
        writer.setting(BiomeStandardValues.SURFACE_BLOCK, this.surfaceBlock);
        writer.comment("Block from stone to surface, like dirt in most biomes. Doesn't support block data.");
        writer.setting(BiomeStandardValues.GROUND_BLOCK, this.groundBlock);
        writer.comment("Setting for biomes with more complex surface and ground blocks.");
        writer.comment("Each column in the world has a noise value from what appears to be -7 to 7.");
        writer.comment("Values near 0 are more common than values near -7 and 7. This setting is");
        writer.comment("used to change the surface block based on the noise value for the column.");
        writer.comment("Syntax: SurfaceBlockName,GroundBlockName,MaxNoise,[AnotherSurfaceBlockName,[AnotherGroundBlockName,MaxNoise[,...]]");
        writer.comment("Example: " + BiomeStandardValues.SURFACE_AND_GROUND_CONTROL + ": STONE,STONE,-0.8,GRAVEL,STONE,0.0,DIRT,DIRT,10.0");
        writer.comment("  When the noise is below -0.8, stone is the surface and ground block, between -0.8 and 0");
        writer.comment("  gravel with stone just below and between 0.0 and 10.0 there's only dirt.");
        writer.comment("  Because 10.0 is higher than the noise can ever get, the normal " + BiomeStandardValues.SURFACE_BLOCK);
        writer.comment("  and " + BiomeStandardValues.GROUND_BLOCK + " will never appear in this biome.");
        writer.comment("");
        writer.comment("Alternatively, you can use Mesa, MesaForest or MesaBryce to get blocks");
        writer.comment("like the blocks found in the Mesa biomes.");
        writer.setting(BiomeStandardValues.SURFACE_AND_GROUND_CONTROL, this.surfaceAndGroundControl);
        writer.comment("Replace Variable: (blockFrom,blockTo[:blockDataTo][,minHeight,maxHeight])");
        writer.comment("Example :");
        writer.comment("  ReplacedBlocks: (GRASS,DIRT,100,127),(GRAVEL,GLASS)");
        writer.comment("Replace grass block to dirt from 100 to 127 height and replace gravel to glass on all height ");
        writer.setting(BiomeStandardValues.REPLACED_BLOCKS, this.replacedBlocks);
        writer.smallTitle("Water and ice");
        writer.comment("Set this to false to use the water and ice settings of this biome.");
        writer.setting(BiomeStandardValues.USE_WORLD_WATER_LEVEL, this.useWorldWaterLevel);
        writer.comment("Set water level. Every empty between this levels will be fill water or another block from WaterBlock.");
        writer.setting(BiomeStandardValues.WATER_LEVEL_MAX, this.configWaterLevelMax);
        writer.setting(BiomeStandardValues.WATER_LEVEL_MIN, this.configWaterLevelMin);
        writer.comment("Block used as water in WaterLevelMax");
        writer.setting(BiomeStandardValues.WATER_BLOCK, this.configWaterBlock);
        writer.comment("Block used as ice. Ice only spawns if the BiomeTemperture is low enough.");
        writer.setting(BiomeStandardValues.ICE_BLOCK, this.configIceBlock);
        writer.bigTitle("Visuals and weather");
        writer.comment("Most of the settings here only have an effect on players with the client version of Terrain Control installed.");
        writer.comment("Biome temperature. Float value from 0.0 to 2.0.");
        if (this.defaultSettings.isCustomBiome) {
            writer.comment("When this value is around 0.2, snow will fall on mountain peaks above y=90.");
            writer.comment("When this value is around 0.1, the whole biome will be covered in snow and ice.");
        } else {
            writer.comment("On default biomes, this won't do anything except changing the grass and leaves colors slightly.");
        }
        writer.setting(BiomeStandardValues.BIOME_TEMPERATURE, Float.valueOf(this.biomeTemperature));
        writer.comment("Biome wetness. Float value from 0.0 to 1.0.");
        if (this.defaultSettings.isCustomBiome) {
            writer.comment("When this is set to 0, no rain will fall.");
        } else {
            writer.comment("On default biomes, this won't do anything except changing the grass and leaves colors slightly.");
        }
        writer.setting(BiomeStandardValues.BIOME_WETNESS, Float.valueOf(this.biomeWetness));
        writer.comment("Biome sky color.");
        writer.setting(BiomeStandardValues.SKY_COLOR, this.skyColor);
        writer.comment("Biome water color multiplier.");
        writer.setting(BiomeStandardValues.WATER_COLOR, this.waterColor);
        writer.comment("Biome grass color.");
        writer.setting(BiomeStandardValues.GRASS_COLOR, this.grassColor);
        writer.comment("Whether the grass color is a multiplier.");
        writer.comment("If you set it to true, the color will be based on this value, the BiomeTemperature and the BiomeWetness.");
        writer.comment("If you set it to false, the grass color will be just this color.");
        writer.setting(BiomeStandardValues.GRASS_COLOR_IS_MULTIPLIER, this.grassColorIsMultiplier);
        writer.comment("Biome foliage color.");
        writer.setting(BiomeStandardValues.FOLIAGE_COLOR, this.foliageColor);
        writer.comment("Whether the foliage color is a multiplier. See GrassColorIsMultiplier for details.");
        writer.setting(BiomeStandardValues.FOLIAGE_COLOR_IS_MULTIPLIER, this.foliageColorIsMultiplier);
        writer.bigTitle("Resource queue");
        writer.comment("This section control all resources spawning after terrain generation.");
        writer.comment("The resources will be placed in this order.");
        writer.comment("");
        writer.comment("Keep in mind that a high size, frequency or rarity might slow down terrain generation.");
        writer.comment("");
        writer.comment("Possible resources:");
        writer.comment("DoResourceInheritance(true|false)");
        writer.comment("SmallLake(BlockName,Frequency,Rarity,MinAltitude,MaxAltitude)");
        writer.comment("Dungeon(Frequency,Rarity,MinAltitude,MaxAltitude)");
        writer.comment("UnderGroundLake(MinSize,MaxSize,Frequency,Rarity,MinAltitude,MaxAltitude)");
        writer.comment("Ore(BlockName,Size,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("UnderWaterOre(BlockName,Size,Frequency,Rarity,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("CustomObject(Object[,AnotherObject[,...]])");
        writer.comment("CustomStructure([Object,Object_Chance[,AnotherObject,Object_Chance[,...]]])");
        writer.comment("Tree(Frequency,TreeType,TreeTypeChance[,AdditionalTreeType,AdditionalTreeTypeChance.....])");
        writer.comment("Plant(PlantType,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("Grass(PlantType,Grouped/NotGrouped,Frequency,Rarity,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("Reed(BlockName,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("Cactus(BlockName,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("Liquid(BlockName,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,BlockSource3.....])");
        writer.comment("AboveWaterRes(BlockName,Frequency,Rarity)");
        writer.comment("Vines(Frequency,Rarity,MinAltitude,MaxAltitude)");
        writer.comment("Vein(BlockName,MinRadius,MaxRadius,Rarity,OreSize,OreFrequency,OreRarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,..])");
        writer.comment("Well(BaseBlockName,HalfSlabBlockName,WaterBlockName,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,..])");
        writer.comment("Boulder(BlockName,Frequency,Rarity,MinAltitude,MaxAltitude,BlockSource[,BlockSource2,..]");
        writer.comment("IceSpike(BlockName,IceSpikeType,Frequency,Rarity,MinAltitude,MaxAltitude,Blocksource[,BlockSource2,...])");
        writer.comment("");
        writer.comment("BlockName:      must be the name of a block. May include block data, like \"WOOL:1\".");
        writer.comment("BlockSource:    list of blocks the resource can spawn on/in. You can also use \"Solid\" or \"All\".");
        writer.comment("Frequency:      number of attempts to place this resource in each chunk.");
        writer.comment("Rarity:         chance for each attempt, Rarity:100 - mean 100% to pass, Rarity:1 - mean 1% to pass.");
        writer.comment("MinAltitude and MaxAltitude: height limits.");
        writer.comment("BlockSource:    mean where or whereupon resource will be placed ");
        writer.comment("TreeType:       Tree (original oak tree) - BigTree - Birch - TallBirch - SwampTree");
        writer.comment("                HugeMushroom (not a tree but still counts) - Taiga1 - Taiga2 - HugeTaiga1 - HugeTaiga2");
        writer.comment("                JungleTree (the huge jungle tree) - GroundBush - CocoaTree (smaller jungle tree)");
        writer.comment("                DarkOak (from the roofed forest biome) - Acacia");
        writer.comment("                You can also use your own custom objects, as long as they have set Tree to true in their settings.");
        writer.comment("TreeTypeChance: similar to Rarity. Example:");
        writer.comment("                Tree(10,Taiga1,35,Taiga2,100) - plugin tries 10 times, for each attempt it tries to place Taiga1 (35% chance),");
        writer.comment("                if that fails, it attempts to place Taiga2 (100% chance).");
        writer.comment("PlantType:      one of the plant types: " + StringHelper.join(PlantType.values(), ", "));
        writer.comment("                or simply a BlockName");
        writer.comment("IceSpikeType:   one of the ice spike types: " + StringHelper.join((Object[])IceSpikeGen.SpikeType.values(), ","));
        writer.comment("Object:         can be a any kind of custom object (bo2 or bo3) but without the file extension. You can");
        writer.comment("                also use UseWorld to spawn one of the object in the WorldObjects folder and UseBiome to spawn");
        writer.comment("                one of the objects in the BiomeObjects setting. When using BO2s for UseWorld, the BO2 must have");
        writer.comment("                this biome in their spawnInBiome setting.");
        writer.comment("");
        writer.comment("Plant and Grass resource: both a resource of one block. Plant can place blocks underground, Grass cannot.");
        writer.comment("Liquid resource: a one-block water or lava source");
        writer.comment("SmallLake and UnderGroundLake resources: small lakes of about 8x8 blocks");
        writer.comment("Vein resource: not in vanilla. Starts an area where ores will spawn. Can be slow, so use a low Rarity (smaller than 1).");
        writer.comment("CustomStructure resource: starts a BO3 structure in the chunk.");
        writer.comment("");
        this.WriteResources(writer);
        writer.bigTitle("Sapling resource");
        writer.comment("Terrain Control allows you to grow your custom objects from saplings, instead");
        writer.comment("of the vanilla trees. Add one or more Sapling functions here to override vanilla");
        writer.comment("spawning for that sapling.");
        writer.comment("");
        writer.comment("The syntax is: Sapling(SaplingType,TreeType,TreeType_Chance[,Additional_TreeType,Additional_TreeType_Chance.....])");
        writer.comment("Works like Tree resource instead first parameter.");
        writer.comment("");
        writer.comment("Sapling types: " + StringHelper.join((Object[])SaplingType.values(), ", "));
        writer.comment("All - will make the tree spawn from all saplings, but not from mushrooms.");
        writer.comment("BigJungle - for when 4 jungle saplings grow at once.");
        writer.comment("RedMushroom/BrownMushroom - will only grow when bonemeal is used.");
        this.WriteSaplingSettings(writer);
        writer.bigTitle("Custom objects");
        writer.comment("These objects will spawn when using the UseBiome keyword.");
        this.WriteCustomObjects(writer);
        writer.bigTitle("Structures");
        writer.comment("Here you can change, enable or disable the stuctures.");
        writer.comment("If you have disabled the structure in the WorldConfig, it won't spawn,");
        writer.comment("regardless of these settings.");
        writer.comment("Disables strongholds for this biome. If there is no suitable biome nearby,");
        writer.comment("Minecraft will ignore this setting.");
        writer.setting(BiomeStandardValues.STRONGHOLDS_ENABLED, this.strongholdsEnabled);
        writer.comment("Whether a Nether Fortress can start in this biome. Might extend to neighbor biomes.");
        writer.setting(BiomeStandardValues.NETHER_FORTRESSES_ENABLED, this.netherFortressesEnabled);
        writer.comment("The village type in this biome. Can be wood, sandstone or disabled.");
        writer.setting(BiomeStandardValues.VILLAGE_TYPE, this.villageType);
        writer.comment("The mineshaft rarity from 0 to 100. 0 = no mineshafts, 1 = default rarity, 100 = a wooden chaos.");
        writer.setting(BiomeStandardValues.MINESHAFT_RARITY, this.mineshaftsRarity);
        writer.comment("The type of the aboveground rare building in this biome. Can be desertPyramid, jungleTemple, swampHut or disabled.");
        writer.setting(BiomeStandardValues.RARE_BUILDING_TYPE, this.rareBuildingType);
        writer.bigTitle("Mob spawning");
        if (this.defaultSettings.isCustomBiome) {
            writer.comment("This is where you configure mob spawning. Mobs spawn in groups,");
            writer.comment("see http://minecraft.gamepedia.com/Spawn#Mob_spawning");
            writer.comment("");
            writer.comment("A mobgroups is made of four parts. They are mob, weight, min and max.");
            writer.comment("The mob is one of the Minecraft internal mob names.");
            writer.comment("See http://minecraft.gamepedia.com/Chunk_format#Mobs");
            writer.comment("The weight is used for a random selection. This is a positive integer.");
            writer.comment("The min is the minimum amount of mobs spawning as a group. This is a positive integer.");
            writer.comment("The max is the maximum amount of mobs spawning as a group. This is a positive integer.");
            writer.comment("");
            writer.comment("Mob groups are written to the config files in Json.");
            writer.comment("Json is a tree document format: http://en.wikipedia.org/wiki/JSON");
            writer.comment("Write a mobgroup like this: {\"mob\": \"mobname\", \"weight\": integer, \"min\": integer, \"max\": integer}");
            writer.comment("For example: {\"mob\": \"Ocelot\", \"weight\": 10, \"min\": 2, \"max\": 6}");
            writer.comment("For example: {\"mob\": \"MushroomCow\", \"weight\": 5, \"min\": 2, \"max\": 2}");
            writer.comment("A json list of mobgroups looks like this: [mobgroup, mobgroup, mobgroup...]");
            writer.comment("This would be an ampty list: []");
            writer.comment("You can validate your json here: http://jsonlint.com/");
            writer.comment("");
            writer.comment("There are four categories of mobs: monsters, creatures, water creatures and ambient creatures.");
            writer.comment("In custom biomes, you can add your own mobgroups in the lists below. In the vanilla biomes,");
            writer.comment("your changes are ignored.");
            writer.comment("");
        } else {
            writer.comment("It's not possible to change mob spawns in vanilla biomes. These");
            writer.comment("are the values used by vanilla for this biome. They are read-only:");
            writer.comment("changes to this setting are ignored and overwritten.");
            writer.comment("");
        }
        writer.comment("The monsters (skeletons, zombies, etc.) that spawn in this biome");
        writer.setting(BiomeStandardValues.SPAWN_MONSTERS, this.spawnMonsters);
        writer.comment("The friendly creatures (cows, pigs, etc.) that spawn in this biome");
        writer.setting(BiomeStandardValues.SPAWN_CREATURES, this.spawnCreatures);
        writer.comment("The water creatures (only squids in vanilla) that spawn in this biome");
        writer.setting(BiomeStandardValues.SPAWN_WATER_CREATURES, this.spawnWaterCreatures);
        writer.comment("The ambient creatures (only bats in vanila) that spawn in this biome");
        writer.setting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES, this.spawnAmbientCreatures);
    }

    private void WriteResources(SettingsWriter writer) throws IOException {
        for (Resource resource : this.resourceSequence) {
            writer.function(resource);
        }
    }

    private void WriteCustomObjects(SettingsWriter writer) throws IOException {
        ArrayList<String> objectStrings = new ArrayList<String>(this.biomeObjectStrings.size());
        for (String objectString : this.biomeObjectStrings) {
            objectStrings.add(objectString);
        }
        writer.setting(BiomeStandardValues.BIOME_OBJECTS, objectStrings);
    }

    private void WriteSaplingSettings(SettingsWriter writer) throws IOException {
        for (SaplingGen res : this.saplingGrowers.values()) {
            writer.function(res);
        }
    }

    @Override
    protected void correctSettings() {
        this.biomeExtends = this.biomeExtends == null || this.biomeExtends.equals("null") ? "" : this.biomeExtends;
        this.biomeSize = this.lowerThanOrEqualTo(this.biomeSize, this.worldConfig.GenerationDepth);
        this.biomeRarity = this.lowerThanOrEqualTo(this.biomeRarity, this.worldConfig.BiomeRarityScale);
        this.isleInBiome = this.filterBiomes(this.isleInBiome, this.worldConfig.customBiomeGenerationIds.keySet());
        this.biomeIsBorder = this.filterBiomes(this.biomeIsBorder, this.worldConfig.customBiomeGenerationIds.keySet());
        this.notBorderNear = this.filterBiomes(this.notBorderNear, this.worldConfig.customBiomeGenerationIds.keySet());
        this.volatility1 = this.volatilityRaw1 < 0.0 ? 1.0 / (Math.abs(this.volatilityRaw1) + 1.0) : this.volatilityRaw1 + 1.0;
        this.volatility2 = this.volatilityRaw2 < 0.0 ? 1.0 / (Math.abs(this.volatilityRaw2) + 1.0) : this.volatilityRaw2 + 1.0;
        this.volatilityWeight1 = (this.volatilityWeightRaw1 - 0.5) * 24.0;
        this.volatilityWeight2 = (0.5 - this.volatilityWeightRaw2) * 24.0;
        this.waterLevelMax = this.lowerThanOrEqualTo(this.waterLevelMax, this.waterLevelMin);
        this.replaceToBiomeName = DefaultBiome.Contain(this.replaceToBiomeName) || this.worldConfig.customBiomeGenerationIds.keySet().contains(this.replaceToBiomeName) ? this.replaceToBiomeName : "";
        this.riverBiome = DefaultBiome.Contain(this.riverBiome) || this.worldConfig.customBiomeGenerationIds.keySet().contains(this.riverBiome) ? this.riverBiome : "";
    }

    private <T> void moveSettingFromWorld(Setting<T> setting) {
        if (this.worldConfig.reader.hasSetting(setting)) {
            T value = this.worldConfig.reader.getSetting(setting, setting.getDefaultValue());
            this.reader.putSetting(setting, value);
        }
    }

    @Override
    protected void renameOldSettings() {
        String replacedBlocksValue;
        int customTreeChance;
        Setting[] copyFromWorld;
        for (Setting setting : copyFromWorld = new Setting[]{BiomeStandardValues.MAX_AVERAGE_HEIGHT, BiomeStandardValues.MAX_AVERAGE_DEPTH, BiomeStandardValues.VOLATILITY_1, BiomeStandardValues.VOLATILITY_2, BiomeStandardValues.VOLATILITY_WEIGHT_1, BiomeStandardValues.VOLATILITY_WEIGHT_2, BiomeStandardValues.DISABLE_BIOME_HEIGHT, BiomeStandardValues.CUSTOM_HEIGHT_CONTROL}) {
            this.moveSettingFromWorld(setting);
        }
        if (this.reader.hasSetting(BiomeStandardValues.DISABLE_NOTCH_PONDS) && !this.readSettings(BiomeStandardValues.DISABLE_NOTCH_PONDS, false).booleanValue()) {
            this.reader.addConfigFunction(ConfigFunction.create(this, SmallLakeGen.class, new Object[]{DefaultMaterial.WATER, 4, 7, 8, this.worldConfig.worldHeightCap}));
            this.reader.addConfigFunction(ConfigFunction.create(this, SmallLakeGen.class, new Object[]{DefaultMaterial.LAVA, 2, 3, 8, this.worldConfig.worldHeightCap - 8}));
        }
        if ((customTreeChance = this.worldConfig.reader.getSetting(WorldStandardValues.CUSTOM_TREE_CHANCE, 0).intValue()) == 100) {
            this.reader.addConfigFunction(ConfigFunction.create(this, SaplingGen.class, "All", "UseWorld", 100));
        }
        if (customTreeChance > 0 && customTreeChance < 100) {
            this.reader.addConfigFunction(ConfigFunction.create(this, SaplingGen.class, new Object[]{SaplingType.Oak, "UseWorld", customTreeChance, TreeType.BigTree, 10, TreeType.Tree, 100}));
            this.reader.addConfigFunction(ConfigFunction.create(this, SaplingGen.class, new Object[]{SaplingType.Redwood, "UseWorld", customTreeChance, TreeType.Taiga2, 100}));
            this.reader.addConfigFunction(ConfigFunction.create(this, SaplingGen.class, new Object[]{SaplingType.Birch, "UseWorld", customTreeChance, TreeType.Birch, 100}));
            this.reader.addConfigFunction(ConfigFunction.create(this, SaplingGen.class, new Object[]{SaplingType.SmallJungle, "UseWorld", customTreeChance, TreeType.CocoaTree, 100}));
        }
        if (!this.worldConfig.readSettings(WorldStandardValues.FROZEN_RIVERS).booleanValue()) {
            this.reader.putSetting(BiomeStandardValues.RIVER_BIOME, "River");
        }
        if (!this.readSettings(BiomeStandardValues.BIOME_RIVERS).booleanValue()) {
            this.reader.putSetting(BiomeStandardValues.RIVER_BIOME, "");
        }
        if ((replacedBlocksValue = this.readSettings(BiomeStandardValues.REPLACED_BLOCKS_OLD)).contains("=")) {
            String[] values = replacedBlocksValue.split(",");
            ArrayList<ReplacedBlocksMatrix.ReplacedBlocksInstruction> output = new ArrayList<ReplacedBlocksMatrix.ReplacedBlocksInstruction>();
            for (String replacedBlock : values) {
                try {
                    LocalMaterialData to;
                    LocalMaterialData fromId = TerrainControl.readMaterial(replacedBlock.split("=")[0]);
                    String rest = replacedBlock.split("=")[1];
                    int minHeight = 0;
                    int maxHeight = this.worldConfig.worldHeightCap;
                    int start = rest.indexOf(40);
                    int end = rest.indexOf(41);
                    if (start != -1 && end != -1) {
                        String[] ranges = rest.substring(start + 1, end).split("-");
                        to = TerrainControl.readMaterial(rest.substring(0, start));
                        minHeight = StringHelper.readInt(ranges[0], minHeight, maxHeight);
                        maxHeight = StringHelper.readInt(ranges[1], minHeight, maxHeight);
                    } else {
                        to = TerrainControl.readMaterial(rest);
                    }
                    output.add(new ReplacedBlocksMatrix.ReplacedBlocksInstruction(fromId, to, minHeight, maxHeight));
                }
                catch (InvalidConfigException ignored) {
                    // empty catch block
                }
            }
            ReplacedBlocksMatrix replacedBlocks = ReplacedBlocksMatrix.createEmptyMatrix(this.worldConfig.worldHeightCap);
            replacedBlocks.setInstructions(output);
            this.reader.putSetting(BiomeStandardValues.REPLACED_BLOCKS, replacedBlocks);
        }
        if (this.reader.getSetting(BiomeStandardValues.SPAWN_MONSTERS_ADD_DEFAULTS, false).booleanValue()) {
            this.addDefaultMobGroups(BiomeStandardValues.SPAWN_MONSTERS, this.defaultSettings.defaultMonsters);
        }
        if (this.reader.getSetting(BiomeStandardValues.SPAWN_CREATURES_ADD_DEFAULTS, false).booleanValue()) {
            this.addDefaultMobGroups(BiomeStandardValues.SPAWN_CREATURES, this.defaultSettings.defaultCreatures);
        }
        if (this.reader.getSetting(BiomeStandardValues.SPAWN_WATER_CREATURES_ADD_DEFAULTS, false).booleanValue()) {
            this.addDefaultMobGroups(BiomeStandardValues.SPAWN_WATER_CREATURES, this.defaultSettings.defaultWaterCreatures);
        }
        if (this.reader.getSetting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES_ADD_DEFAULTS, false).booleanValue()) {
            this.addDefaultMobGroups(BiomeStandardValues.SPAWN_AMBIENT_CREATURES, this.defaultSettings.defaultAmbientCreatures);
        }
    }

    private void addDefaultMobGroups(Setting<List<WeightedMobSpawnGroup>> setting, List<WeightedMobSpawnGroup> defaultGroups) {
        List emptyList = Collections.emptyList();
        ArrayList<WeightedMobSpawnGroup> groups = new ArrayList<WeightedMobSpawnGroup>();
        groups.addAll(defaultGroups);
        groups.addAll(this.reader.getSetting(setting, emptyList));
        this.reader.putSetting(setting, groups);
    }

    public void writeToStream(DataOutputStream stream) throws IOException {
        BiomeConfig.writeStringToStream(stream, this.getName());
        stream.writeFloat(this.biomeTemperature);
        stream.writeFloat(this.biomeWetness);
        stream.writeInt(this.skyColor);
        stream.writeInt(this.waterColor);
        stream.writeInt(this.grassColor);
        stream.writeBoolean(this.grassColorIsMultiplier);
        stream.writeInt(this.foliageColor);
        stream.writeBoolean(this.foliageColorIsMultiplier);
    }

    public static enum RareBuildingType {
        disabled,
        desertPyramid,
        jungleTemple,
        swampHut;

    }

    public static enum VillageType {
        disabled,
        wood,
        sandstone;

    }
}

